/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PlotQueryInfo.h>
#include <DataNode.h>

//
// Enum conversion methods for PlotQueryInfo::ChangeType
//

static const char *ChangeType_strings[] = {
"None", "Database", "VarName", 
"AddOp", "OpAtts", "PlotAtts", 
"MoveOperator", "RemoveOperator", "RemoveAll", 
"RemoveLast", "CacheIndex"};

std::string
PlotQueryInfo::ChangeType_ToString(PlotQueryInfo::ChangeType t)
{
    int index = int(t);
    if(index < 0 || index >= 11) index = 0;
    return ChangeType_strings[index];
}

std::string
PlotQueryInfo::ChangeType_ToString(int t)
{
    int index = (t < 0 || t >= 11) ? 0 : t;
    return ChangeType_strings[index];
}

bool
PlotQueryInfo::ChangeType_FromString(const std::string &s, PlotQueryInfo::ChangeType &val)
{
    val = PlotQueryInfo::None;
    for(int i = 0; i < 11; ++i)
    {
        if(s == ChangeType_strings[i])
        {
            val = (ChangeType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: PlotQueryInfo::PlotQueryInfo
//
// Purpose: 
//   Init utility for the PlotQueryInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void PlotQueryInfo::Init()
{
    changeType = None;
    oldFrameIndex = 0;
    newFrameIndex = 0;

    PlotQueryInfo::SelectAll();
}

// ****************************************************************************
// Method: PlotQueryInfo::PlotQueryInfo
//
// Purpose: 
//   Copy utility for the PlotQueryInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void PlotQueryInfo::Copy(const PlotQueryInfo &obj)
{
    changeType = obj.changeType;
    oldFrameIndex = obj.oldFrameIndex;
    newFrameIndex = obj.newFrameIndex;

    PlotQueryInfo::SelectAll();
}

// Type map format string
const char *PlotQueryInfo::TypeMapFormatString = PLOTQUERYINFO_TMFS;
const AttributeGroup::private_tmfs_t PlotQueryInfo::TmfsStruct = {PLOTQUERYINFO_TMFS};


// ****************************************************************************
// Method: PlotQueryInfo::PlotQueryInfo
//
// Purpose: 
//   Default constructor for the PlotQueryInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PlotQueryInfo::PlotQueryInfo() : 
    AttributeSubject(PlotQueryInfo::TypeMapFormatString)
{
    PlotQueryInfo::Init();
}

// ****************************************************************************
// Method: PlotQueryInfo::PlotQueryInfo
//
// Purpose: 
//   Constructor for the derived classes of PlotQueryInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PlotQueryInfo::PlotQueryInfo(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    PlotQueryInfo::Init();
}

// ****************************************************************************
// Method: PlotQueryInfo::PlotQueryInfo
//
// Purpose: 
//   Copy constructor for the PlotQueryInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PlotQueryInfo::PlotQueryInfo(const PlotQueryInfo &obj) : 
    AttributeSubject(PlotQueryInfo::TypeMapFormatString)
{
    PlotQueryInfo::Copy(obj);
}

// ****************************************************************************
// Method: PlotQueryInfo::PlotQueryInfo
//
// Purpose: 
//   Copy constructor for derived classes of the PlotQueryInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PlotQueryInfo::PlotQueryInfo(const PlotQueryInfo &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    PlotQueryInfo::Copy(obj);
}

// ****************************************************************************
// Method: PlotQueryInfo::~PlotQueryInfo
//
// Purpose: 
//   Destructor for the PlotQueryInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PlotQueryInfo::~PlotQueryInfo()
{
    // nothing here
}

// ****************************************************************************
// Method: PlotQueryInfo::operator = 
//
// Purpose: 
//   Assignment operator for the PlotQueryInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PlotQueryInfo& 
PlotQueryInfo::operator = (const PlotQueryInfo &obj)
{
    if (this == &obj) return *this;

    PlotQueryInfo::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: PlotQueryInfo::operator == 
//
// Purpose: 
//   Comparison operator == for the PlotQueryInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PlotQueryInfo::operator == (const PlotQueryInfo &obj) const
{
    // Create the return value
    return ((changeType == obj.changeType) &&
            (oldFrameIndex == obj.oldFrameIndex) &&
            (newFrameIndex == obj.newFrameIndex));
}

// ****************************************************************************
// Method: PlotQueryInfo::operator != 
//
// Purpose: 
//   Comparison operator != for the PlotQueryInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PlotQueryInfo::operator != (const PlotQueryInfo &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: PlotQueryInfo::TypeName
//
// Purpose: 
//   Type name method for the PlotQueryInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
PlotQueryInfo::TypeName() const
{
    return "PlotQueryInfo";
}

// ****************************************************************************
// Method: PlotQueryInfo::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the PlotQueryInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PlotQueryInfo::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const PlotQueryInfo *tmp = (const PlotQueryInfo *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: PlotQueryInfo::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the PlotQueryInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PlotQueryInfo::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new PlotQueryInfo(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: PlotQueryInfo::NewInstance
//
// Purpose: 
//   NewInstance method for the PlotQueryInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PlotQueryInfo::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new PlotQueryInfo(*this);
    else
        retval = new PlotQueryInfo;

    return retval;
}

// ****************************************************************************
// Method: PlotQueryInfo::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
PlotQueryInfo::SelectAll()
{
    Select(ID_changeType,    (void *)&changeType);
    Select(ID_oldFrameIndex, (void *)&oldFrameIndex);
    Select(ID_newFrameIndex, (void *)&newFrameIndex);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
PlotQueryInfo::SetChangeType(PlotQueryInfo::ChangeType changeType_)
{
    changeType = changeType_;
    Select(ID_changeType, (void *)&changeType);
}

void
PlotQueryInfo::SetOldFrameIndex(int oldFrameIndex_)
{
    oldFrameIndex = oldFrameIndex_;
    Select(ID_oldFrameIndex, (void *)&oldFrameIndex);
}

void
PlotQueryInfo::SetNewFrameIndex(int newFrameIndex_)
{
    newFrameIndex = newFrameIndex_;
    Select(ID_newFrameIndex, (void *)&newFrameIndex);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

PlotQueryInfo::ChangeType
PlotQueryInfo::GetChangeType() const
{
    return ChangeType(changeType);
}

int
PlotQueryInfo::GetOldFrameIndex() const
{
    return oldFrameIndex;
}

int
PlotQueryInfo::GetNewFrameIndex() const
{
    return newFrameIndex;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PlotQueryInfo::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
PlotQueryInfo::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_changeType:    return "changeType";
    case ID_oldFrameIndex: return "oldFrameIndex";
    case ID_newFrameIndex: return "newFrameIndex";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PlotQueryInfo::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
PlotQueryInfo::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_changeType:    return FieldType_enum;
    case ID_oldFrameIndex: return FieldType_int;
    case ID_newFrameIndex: return FieldType_int;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: PlotQueryInfo::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
PlotQueryInfo::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_changeType:    return "enum";
    case ID_oldFrameIndex: return "int";
    case ID_newFrameIndex: return "int";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PlotQueryInfo::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PlotQueryInfo::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const PlotQueryInfo &obj = *((const PlotQueryInfo*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_changeType:
        {  // new scope
        retval = (changeType == obj.changeType);
        }
        break;
    case ID_oldFrameIndex:
        {  // new scope
        retval = (oldFrameIndex == obj.oldFrameIndex);
        }
        break;
    case ID_newFrameIndex:
        {  // new scope
        retval = (newFrameIndex == obj.newFrameIndex);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

