/***********************************************************************************************************************************
LZ4 Compress

Compress IO to the lz4 format.
***********************************************************************************************************************************/
#ifdef HAVE_LIBLZ4

#ifndef COMMON_COMPRESS_LZ4_COMPRESS_H
#define COMMON_COMPRESS_LZ4_COMPRESS_H

#include "common/io/filter/filter.h"

/***********************************************************************************************************************************
Filter type constant
***********************************************************************************************************************************/
#define LZ4_COMPRESS_FILTER_TYPE                                    STRID6("lz4-cmp", 0x103436e068c1)

/***********************************************************************************************************************************
Level constants
***********************************************************************************************************************************/
#define LZ4_COMPRESS_LEVEL_DEFAULT                                  1
#define LZ4_COMPRESS_LEVEL_MIN                                      -5
#define LZ4_COMPRESS_LEVEL_MAX                                      12

/***********************************************************************************************************************************
Constructors
***********************************************************************************************************************************/
FN_EXTERN IoFilter *lz4CompressNew(int level, bool raw);

#endif

#endif // HAVE_LIBLZ4
