/* $Cambridge: hermes/src/prayer/cmd/cmd_resume.c,v 1.4 2008/09/17 17:20:25 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

void cmd_resume(struct session *session)
{
    struct request *request = session->request;
    struct draft *draft = session->draft;
    MAILSTREAM *stream = session->stream;
    unsigned long msgno;
    unsigned long msguid;

    if (request->argc < 3) {
        session_alert(session, "Unexpected resume");
        session_redirect(session, request, "list");
        return;
    }

    msgno = atoi(request->argv[1]);
    msguid = atoi(request->argv[2]);

    if (!(msgno = stream_check_uid(session, stream, msgno, msguid))) {
        session_redirect(session, request, "restart");
        return;
    }

    draft_role_set(draft, NIL); /* Set up default role */
    draft_init(draft);

    /* Reload draft message */
    if (!draft_restore_postponed(draft, request->pool,
                                 session->draft_stream, msgno)) {
        session_redirect(session, request, "restart");
        return;
    }

    /* Remove from draft folder */
    if (!draft_delete(session, msgno)) {
        session_redirect(session, request, "restart");
        return;
    }

    if (draft_att_count(draft) > 1)
        session_message(session,
                        "Restored postponed draft, including %lu attachments",
                        draft_att_count(draft));
    else if (draft_att_count(draft) == 1)
        session_message(session,
                        "Restored postponed draft, including 1 attachment");
    else
        session_message(session,
                        "Restored postponed draft, no attachments");

    session_redirect(session, request, "compose");
}
