# Contributing to PyEnsembl

[PyEnsembl](http://www.github.com/hammerlab/pyensembl) is open source software and
we welcome your contributions. This document should help you get started
contributing to PyEnsembl.

## Filing Issues

If you find any bugs or problems while using PyEnsembl or have any feature requests, please feel free to file an issue against the project. When doing so, please follow the guidelines below:

To report any bugs, issues, or feature requests, please [open an issue](https://github.com/hammerlab/pyensembl/issues)
Please check the [current open issues](https://github.com/hammerlab/pyensembl/issues) to see if the request already exists
If you are filing a bug report, please describe the version of PyEnsembl and Python you are using. If your problem involves a particular gene, transcript, or genomic locus, please include that information (e.g. "Missing transcript sequence for BRCA1-002 for Ensembl release 74").

## Coding Guidelines

- PyEnsembl is written in Python and adheres to the [PEP8](https://www.python.org/dev/peps/pep-0008/)
  style guidelines.
- Contributions should come in the form of GitHub pull requests.
- New features should start with a GitHub issue explaining their scope and rationale.
- If the work is based on an existing issue, please reference the issue in the PR.
- All new code should be accompanied by comprehensive unit tests.
- If the PR fixes or implements an issue, please state "Closes #XYZ" or "Fixes #XYZ", where XYZ is the issue number.
- Please ensure that your code works under Python >= 3.7.

## Licensing

PyEnsembl is licensed under the Apache 2.0 license. Your code is assumed to be as well.
