# Pyntor::Titlepage - Display text on a titlepage
# Copyright (C) 2004-2006 Josef Spillner <josef@coolprojects.org>
# Published under GNU GPL conditions

import pygame
from pygame.locals import *
import sys
import time
import random
import os, pwd
import re

class Titlepage:
	def init(self, options):
		titlefile = options["title"]

		f = open(titlefile)
		blines = f.readlines()
		f.close()

		self.dict = {}
		self.dict["title"] = ""
		self.dict["subtitle"] = ""
		self.dict["date"] = ""
		self.dict["author"] = ""
		self.dict["???"] = ""

		word = None
		for line in blines:
			line = unicode(line.rstrip(), "utf-8")
			if word:
				self.dict[word] = line
				word = None
			if line[-1:] == ":" and line[0] != "#":
				word = line[:-1]
				if word not in self.dict.keys():
					print "(Titlepage) Error: unknown parameter", word
					word = None

		#self.pages = 1

	def render(self, screen, page, globalpage):
		surface = pygame.Surface((screen.get_width(), screen.get_height()))
		surface.blit(screen, (0, 0))

		titlefont = pygame.font.SysFont("Vera Sans", 40)
		smallfont = pygame.font.SysFont("Vera Sans", 24)

		f = titlefont.render(self.dict["title"], 1, (200, 200, 100))
		surface.blit(f, ((surface.get_width() - f.get_width()) / 2, 300))

		f = smallfont.render(self.dict["subtitle"], 1, (200, 200, 100))
		surface.blit(f, ((surface.get_width() - f.get_width()) / 2, 370))

		f = smallfont.render(self.dict["author"], 1, (255, 255, 255))
		surface.blit(f, ((surface.get_width() - f.get_width()) / 2, 500))

		f = smallfont.render(self.dict["date"], 1, (255, 255, 255))
		surface.blit(f, ((surface.get_width() - f.get_width()) / 2, 550))

		screen.blit(surface, (0, 0))

component = Titlepage()

parameters = (
	("title", "Filename containing title information", None),
)

metainfo = {
	"version": "0.2",
	"author": "Josef Spillner",
	"authoremail": "<josef@coolprojects.org>",
	"licence": "GPL"
}

doc = """
Titlepage: creation of slides from Plain Old Documentation

Title pages contain several entries consisting of two lines each, the first
one being the keyword and the second one being the string to be used, for
example:
 title:
 Pyntor

Usage: 'titlepage' -title <titlefile>
 Where <titlefile> is a special text file containing information about the
 title, subtitle, author, date and event.

Display: yes

Interactivity: proceed/go back with enter/backspace
"""

