% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colWeightedMads.R, R/rowWeightedMads.R
\name{colWeightedMads,DelayedMatrix-method}
\alias{colWeightedMads,DelayedMatrix-method}
\alias{rowWeightedMads,DelayedMatrix-method}
\title{Calculates the weighted median absolute deviation for each row (column) of a
matrix-like object}
\usage{
\S4method{colWeightedMads}{DelayedMatrix}(
  x,
  w = NULL,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  constant = 1.4826,
  center = NULL,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)

\S4method{rowWeightedMads}{DelayedMatrix}(
  x,
  w = NULL,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  constant = 1.4826,
  center = NULL,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)
}
\arguments{
\item{x}{A NxK \linkS4class{DelayedMatrix}.}

\item{w}{A \code{\link{numeric}} vector of length K (N) that specifies by
how much each element is weighted.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{constant}{A scale factor. See \code{stats::\link[stats]{mad}()} for
details.}

\item{center}{(optional) the center, defaults to the row means}

\item{force_block_processing}{\code{FALSE} (the default) means that a
seed-aware, optimised method is used (if available). This can be overridden
to use the general block-processing strategy by setting this to \code{TRUE}
(typically not advised). The block-processing strategy loads one or more
(depending on \verb{\link[DelayedArray]\{getAutoBlockSize\}()}) columns (\code{colFoo()})
or rows (\code{rowFoo()}) into memory as an ordinary \link[base:array]{base::array}.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the weighted  median absolute deviation for each row (column) of
a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowWeightedMads}} /
\code{matrixStats::\link[matrixStats]{colWeightedMads}}.
}
\examples{
# A DelayedMatrix with a 'matrix' seed
dm_matrix <- DelayedArray(matrix(c(rep(1L, 5),
                                   as.integer((0:4) ^ 2),
                                   seq(-5L, -1L, 1L)),
                                 ncol = 3))

colWeightedMads(dm_matrix, w = 1:5)

rowWeightedMads(dm_matrix, w = 3:1)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:weightedMad]{rowWeightedMads}()} and
\code{matrixStats::\link[matrixStats:weightedMad]{colWeightedMads}()}
which are used when the input is a \code{matrix} or \code{numeric} vector.
\item See also \link[MatrixGenerics]{rowMads} for the corresponding unweighted function.
}
}
\author{
Peter Hickey
}
