% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-day.R
\name{year-day-narrow}
\alias{year-day-narrow}
\alias{calendar_narrow.clock_year_day}
\title{Narrow: year-day}
\usage{
\method{calendar_narrow}{clock_year_day}(x, precision)
}
\arguments{
\item{x}{\verb{[clock_year_day]}

A year-day vector.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
\item \code{"day"}
\item \code{"hour"}
\item \code{"minute"}
\item \code{"second"}
\item \code{"millisecond"}
\item \code{"microsecond"}
\item \code{"nanosecond"}
}}
}
\value{
\code{x} narrowed to the supplied \code{precision}.
}
\description{
This is a year-day method for the \code{\link[=calendar_narrow]{calendar_narrow()}} generic. It
narrows a year-day vector to the specified \code{precision}.
}
\examples{
# Hour precision
x <- year_day(2019, 3, 4)
x

# Narrowed to day precision
calendar_narrow(x, "day")

# Or year precision
calendar_narrow(x, "year")

# Subsecond precision can be narrowed to second precision
milli <- calendar_widen(x, "millisecond")
micro <- calendar_widen(x, "microsecond")
milli
micro

calendar_narrow(milli, "second")
calendar_narrow(micro, "second")

# But once you have "locked in" a subsecond precision, it can't be
# narrowed to another subsecond precision
try(calendar_narrow(micro, "millisecond"))
}
