% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_flextable.tabular.R
\name{as_flextable.tabular}
\alias{as_flextable.tabular}
\title{Transform a 'tables::tabular' object into a flextable}
\usage{
\method{as_flextable}{tabular}(
  x,
  spread_first_col = FALSE,
  fp_p = fp_par(text.align = "center", padding.top = 4),
  row_title = as_paragraph(as_chunk(.row_title)),
  add_tab = FALSE,
  ...
)
}
\arguments{
\item{x}{object produced by \code{\link[tables:tabular]{tables::tabular()}}.}

\item{spread_first_col}{if TRUE, first row is spread as a new line separator
instead of being a column. This helps to reduce the width and allows for
clear divisions.}

\item{fp_p}{paragraph formatting properties associated with row titles,
see \code{\link[officer:fp_par]{officer::fp_par()}}.}

\item{row_title}{a call to \code{\link[=as_paragraph]{as_paragraph()}} - it
will be applied to the row titles if any
when \code{spread_first_col=TRUE}.}

\item{add_tab}{adds a tab in front of "list_data"
label lines (located in column \code{.type}).}

\item{...}{unused argument}
}
\description{
Produce a flextable from a 'tabular' object
produced with function \code{\link[tables:tabular]{tables::tabular()}}.

When \code{as_flextable.tabular=TRUE}, the first column is
used as row separator acting as a row title. It can
be formated with arguments \code{fp_p} (the formatting
properties of the paragraph) and \code{row_title} that
specifies the content and eventually formattings
of the content.

Two hidden columns can be used for conditional formatting
after the creation of the flextable (use only when
\code{spread_first_col=TRUE}):
\itemize{
\item The column \code{.row_title} that contains the title label
\item The column \code{.type} that can contain the following values:
\itemize{
\item "one_row": Indicates that there is only one row for this group. In this case, the row is not expanded with a title above.
\item "list_title": Indicates a row that serves as a title for the data that are displayed after it.
\item "list_data": Indicates rows that follow a title and contain data to be displayed.
}
}

The result is paginated (see \code{\link[=paginate]{paginate()}}).
}
\examples{
if (require("tables")) {
  set.seed(42)
  genders <- c("Male", "Female")
  status <- c("low", "medium", "high")
  Sex <- factor(sample(genders, 100, rep = TRUE))
  Status <- factor(sample(status, 100, rep = TRUE))
  z <- rnorm(100) + 5
  fmt <- function(x) {
    s <- format(x, digits = 2)
    even <- ((1:length(s)) \%\% 2) == 0
    s[even] <- sprintf("(\%s)", s[even])
    s
  }
  tab <- tabular(
    Justify(c) * Heading() * z *
      Sex * Heading(Statistic) *
      Format(fmt()) *
      (mean + sd) ~ Status
  )
  as_flextable(tab)
}

if (require("tables")) {
  tab <- tabular(
    (Species + 1) ~ (n = 1) + Format(digits = 2) *
      (Sepal.Length + Sepal.Width) * (mean + sd),
    data = iris
  )
  as_flextable(tab)
}

if (require("tables")) {
  x <- tabular((Factor(gear, "Gears") + 1)
  * ((n = 1) + Percent()
      + (RowPct = Percent("row"))
      + (ColPct = Percent("col")))
  ~ (Factor(carb, "Carburetors") + 1)
    * Format(digits = 1), data = mtcars)

  ft <- as_flextable(
    x,
    spread_first_col = TRUE,
    row_title = as_paragraph(
      colorize("Gears: ", color = "#666666"),
      colorize(as_b(.row_title), color = "red")
    )
  )
  ft
}

if (require("tables")) {
  tab <- tabular(
    (mean + mean) * (Sepal.Length + Sepal.Width) ~ 1,
    data = iris
  )
  as_flextable(tab)
}
}
\seealso{
Other as_flextable methods: 
\code{\link{as_flextable}()},
\code{\link{as_flextable.data.frame}()},
\code{\link{as_flextable.gam}()},
\code{\link{as_flextable.glm}()},
\code{\link{as_flextable.grouped_data}()},
\code{\link{as_flextable.htest}()},
\code{\link{as_flextable.kmeans}()},
\code{\link{as_flextable.lm}()},
\code{\link{as_flextable.merMod}()},
\code{\link{as_flextable.pam}()},
\code{\link{as_flextable.summarizor}()},
\code{\link{as_flextable.table}()},
\code{\link{as_flextable.tabulator}()},
\code{\link{as_flextable.xtable}()}
}
\concept{as_flextable methods}
