% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naive.R
\name{rw_model}
\alias{rw_model}
\title{Random walk model}
\usage{
rw_model(y, lag = 1, drift = FALSE, lambda = NULL, biasadj = FALSE)
}
\arguments{
\item{y}{a numeric vector or univariate time series of class \code{ts}}

\item{lag}{Lag parameter. \code{lag = 1} corresponds to a standard random walk (giving naive forecasts if \code{drift = FALSE} or drift forecasts if \code{drift = TRUE}),
while \code{lag = m} corresponds to a seasonal random walk where m is the seasonal period (giving seasonal naive forecasts if \code{drift = FALSE}).}

\item{drift}{Logical flag. If \code{TRUE}, fits a random walk with drift model.}

\item{lambda}{Box-Cox transformation parameter. If \code{lambda = "auto"},
then a transformation is automatically selected using \code{BoxCox.lambda}.
The transformation is ignored if NULL. Otherwise,
data transformed before model is estimated.}

\item{biasadj}{Use adjusted back-transformed mean for Box-Cox
transformations. If transformed data is used to produce forecasts and fitted
values, a regular back transformation will result in median forecasts. If
biasadj is \code{TRUE}, an adjustment will be made to produce mean forecasts
and fitted values.}
}
\value{
An object of class \code{rw_model}.
}
\description{
Fit a generalized random walk with Gaussian errors (and optional drift) to a univariate time series.
}
\details{
The model assumes that

\deqn{Y_t = Y_{t-p} + c + \varepsilon_{t}}{Y[t] = Y[t-p] + epsilon[t]}

where \eqn{p} is the lag parameter,
\eqn{c} is the drift parameter, and
\eqn{\varepsilon_t\sim N(0,\sigma^2)}{Y[t] ~ N(0, sigma^2)} are iid.

The model without drift has \eqn{c=0}.
In the model with drift, \eqn{c} is estimated
by the sample mean of the differences \eqn{Y_t - Y_{t-p}}{Y[t] - Y[t-p]}.

If \eqn{p=1}, this is equivalent to an ARIMA(0,1,0) model with
an optional drift coefficient. For \eqn{p>1}, it is equivalent to an
ARIMA(0,0,0)(0,1,0)p model.

The forecasts are given by

\deqn{Y_{T+h|T}= Y_{T+h-p(k+1)} + ch}{Y[T+h|T] = Y[T+h-p(k+1)]+ch}

where \eqn{k} is the integer part of \eqn{(h-1)/p}.
For a regular random walk, \eqn{p=1} and \eqn{c=0}, so all forecasts are equal to the last observation.
Forecast standard errors allow for uncertainty in estimating the drift parameter
(unlike the corresponding forecasts obtained by fitting an ARIMA model
directly).

The generic accessor functions \code{\link[stats:fitted.values]{stats::fitted()}} and \code{\link[stats:residuals]{stats::residuals()}}
extract useful features of the object returned.
}
\examples{
model <- rw_model(gold)
forecast(model, h = 50) |> autoplot()
}
\seealso{
\code{\link[=forecast.rw_model]{forecast.rw_model()}}, \code{\link[=rwf]{rwf()}}, \code{\link[=naive]{naive()}}, \code{\link[=snaive]{snaive()}}
}
