% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credentials_external_account.R
\name{credentials_external_account}
\alias{credentials_external_account}
\title{Get a token for an external account}
\usage{
credentials_external_account(
  scopes = "https://www.googleapis.com/auth/cloud-platform",
  path = "",
  ...
)
}
\arguments{
\item{scopes}{A character vector of scopes to request. Pick from those listed
at \url{https://developers.google.com/identity/protocols/oauth2/scopes}.

For certain token flows, the
\code{"https://www.googleapis.com/auth/userinfo.email"} scope is unconditionally
included. This grants permission to retrieve the email address associated
with a token; gargle uses this to index cached OAuth tokens. This grants no
permission to view or send email and is generally considered a low-value
scope.}

\item{path}{JSON containing the workload identity configuration for the
external account, in one of the forms supported for the \code{txt} argument of
\code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} (probably, a file path, although it could be a JSON
string). The instructions for generating this configuration are given at
\href{https://cloud.google.com/iam/docs/access-resources-aws#generate}{Automatically generate credentials}.

Note that external account tokens are a natural fit for use as Application
Default Credentials, so consider storing the configuration file in one of
the standard locations consulted for ADC, instead of providing \code{path}
explicitly. See \code{\link[=credentials_app_default]{credentials_app_default()}} for more.}

\item{...}{Additional arguments passed to all credential functions.}
}
\value{
A \code{\link[=WifToken]{WifToken()}} or \code{NULL}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Workload identity federation is a new (as of April 2021) keyless
authentication mechanism that allows applications running on a non-Google
Cloud platform, such as AWS, to access Google Cloud resources without using a
conventional service account token. This eliminates the dilemma of how to
safely manage service account credential files.

Unlike service accounts, the configuration file for workload identity
federation contains no secrets. Instead, it holds non-sensitive metadata.
The external application obtains the needed sensitive data "on-the-fly" from
the running instance. The combined data is then used to obtain a so-called
subject token from the external identity provider, such as AWS. This is then
sent to Google's Security Token Service API, in exchange for a very
short-lived federated access token. Finally, the federated access token is
sent to Google's Service Account Credentials API, in exchange for a
short-lived GCP access token. This access token allows the external
application to impersonate a service account and inherit the permissions of
the service account to access GCP resources.

This feature is still experimental in gargle and \strong{currently only supports
AWS}. It also requires installation of the suggested packages
\pkg{aws.signature} and \pkg{aws.ec2metadata}. Workload identity federation
\strong{can} be used with other platforms, such as Microsoft Azure or any
identity provider that supports OpenID Connect. If you would like gargle to
support this token flow for additional platforms, please \href{https://github.com/r-lib/gargle/issues}{open an issue on GitHub} and describe your use case.
}
\examples{
\dontrun{
credentials_external_account()
}
}
\seealso{
There is substantial setup necessary, both on the GCP and AWS side,
to use this authentication method. These two links provide, respectively,
a high-level overview and step-by-step instructions.
\itemize{
\item \url{https://cloud.google.com/blog/products/identity-security/enable-keyless-access-to-gcp-with-workload-identity-federation/}
\item \url{https://cloud.google.com/iam/docs/access-resources-aws}
}

Other credential functions: 
\code{\link{credentials_app_default}()},
\code{\link{credentials_byo_oauth2}()},
\code{\link{credentials_gce}()},
\code{\link{credentials_service_account}()},
\code{\link{credentials_user_oauth2}()},
\code{\link{token_fetch}()}
}
\concept{credential functions}
