% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctl_new_pillar.R
\name{ctl_new_pillar}
\alias{ctl_new_pillar}
\alias{ctl_new_pillar_list}
\title{Customize your tibble subclass}
\usage{
ctl_new_pillar(controller, x, width, ..., title = NULL)

ctl_new_pillar_list(
  controller,
  x,
  width,
  ...,
  title = NULL,
  first_pillar = NULL
)
}
\arguments{
\item{controller}{The object of class \code{"tbl"} currently printed.}

\item{x}{A vector, can also be a data frame, array or matrix.
in \code{ctl_new_pillar_list()}.}

\item{width}{The available width, can be a vector for multiple tiers.
If \code{NULL}, compute only the first pillar.}

\item{...}{These dots are for future extensions and must be empty.}

\item{title}{The title, derived from the name of the column in the data.}

\item{first_pillar}{Can be passed to this method if the first pillar
for a compound pillar (or the pillar itself for a simple pillar)
has been computed already.}
}
\description{
Gain full control over the appearance of the pillars of your tibble subclass
in its body.
These methods are intended for implementers of subclasses of the \code{"tbl"}
class.
Users will rarely need them.
}
\details{
\code{ctl_new_pillar()} is called to construct pillars for regular (one-dimensional)
vectors.
The default implementation returns an object constructed with \code{\link[=pillar]{pillar()}}.
Extend this method to tweak pillar components returned from the default
implementation.
Override this method to completely change the appearance of the pillars.

\code{ctl_new_pillar_list()} is called to construct a list of pillars.
It also works for compound pillars: columns that are data frames, matrices or
arrays.
This method is also called to initiate the construction of all pillars
in the tibble to be printed.
If called for a regular one-dimensional vector, it returns a list of length
one.
In any case, all pillars in the returned list of pillars represent only the
first column in case of compound columns.
This ensures that only those pillars that are shown are constructed.
To print all columns of a packed data frame, \code{ctl_new_pillar_list()}
eventually calls itself recursively.
Users will only rarely need to override this method if ever.

All components must be of the same height.
This restriction may be levied in the future.

Implementations should return \code{NULL} if none of the data
fits the available width.
}
\examples{
\dontshow{if (rlang::is_installed("palmerpenguins") && requireNamespace("tibble")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Create pillar objects
ctl_new_pillar(
  palmerpenguins::penguins,
  palmerpenguins::penguins$species[1:3],
  width = 60
)
ctl_new_pillar(
  palmerpenguins::penguins,
  palmerpenguins::penguins$bill_length_mm[1:3],
  width = 60
)

# Packed data frame
ctl_new_pillar_list(
  tibble::tibble(),
  palmerpenguins::penguins,
  width = 60
)

# Packed matrix
ctl_new_pillar_list(tibble::tibble(), matrix(1:6, ncol = 2), width = 60)

# Packed array
ctl_new_pillar_list(tibble::tibble(), Titanic, width = 60)
\dontshow{\}) # examplesIf}

# Customize output
lines <- function(char = "-") {
  stopifnot(nchar(char) == 1)
  structure(char, class = "lines")
}

format.lines <- function(x, width, ...) {
  paste(rep(x, width), collapse = "")
}

ctl_new_pillar.line_tbl <- function(controller, x, width, ..., title = NULL) {
  out <- NextMethod()
  new_pillar(list(
    title = out$title,
    type = out$type,
    lines = new_pillar_component(list(lines("=")), width = 1),
    data = out$data
  ))
}

vctrs::new_data_frame(
  list(a = 1:3, b = letters[1:3]),
  class = c("line_tbl", "tbl")
)
}
