% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_split.R
\name{core_split}
\alias{core_split}
\title{Split a core}
\usage{
core_split(conn, name, path = NULL, targetCore = NULL, ranges = NULL,
  split.key = NULL, async = NULL, raw = FALSE, callopts = list())
}
\arguments{
\item{conn}{A solrium connection object, see \link{SolrClient}}

\item{name}{(character) The name of the core to be created. Required}

\item{path}{(character) Two or more target directory paths in which a piece of the
index will be written}

\item{targetCore}{(character) Two or more target Solr cores to which a piece
of the index will be merged}

\item{ranges}{(character) A list of number ranges, or hash ranges in hexadecimal format.
If numbers, they get converted to hexidecimal format before being passed to
your Solr server.}

\item{split.key}{(character) The key to be used for splitting the index}

\item{async}{(character) Request ID to track this action which will be processed
asynchronously}

\item{raw}{(logical) If \code{TRUE}, returns raw data}

\item{callopts}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
SPLIT splits an index into two or more indexes. The index being
split can continue to handle requests. The split pieces can be placed into
a specified directory on the server's filesystem or it can be merged into
running Solr cores.
}
\details{
The core index will be split into as many pieces as the number of \code{path}
or \code{targetCore} parameters.

Either \code{path} or \code{targetCore} parameter must be specified but not
both. The \code{ranges} and \code{split.key} parameters are optional and only one of
the two should be specified, if at all required.
}
\examples{
\dontrun{
# start Solr with Schemaless mode via the schemaless eg: bin/solr start -e schemaless
# you can create a new core like: bin/solr create -c corename
# where <corename> is the name for your core - or creaate as below

# connect
(conn <- SolrClient$new())

# Swap a core
## First, create two cores
# conn$core_split("splitcoretest0") # or create in the CLI: bin/solr create -c splitcoretest0
# conn$core_split("splitcoretest1") # or create in the CLI: bin/solr create -c splitcoretest1
# conn$core_split("splitcoretest2") # or create in the CLI: bin/solr create -c splitcoretest2

## check status
conn$core_status("splitcoretest0", FALSE)
conn$core_status("splitcoretest1", FALSE)
conn$core_status("splitcoretest2", FALSE)

## split core using targetCore parameter
conn$core_split("splitcoretest0", targetCore = c("splitcoretest1", "splitcoretest2"))

## split core using split.key parameter
### Here all documents having the same route key as the split.key i.e. 'A!'
### will be split from the core index and written to the targetCore
conn$core_split("splitcoretest0", targetCore = "splitcoretest1", split.key = "A!")

## split core using ranges parameter
### Solr expects hash ranges in hexidecimal, but since we're in R,
### let's not make our lives any harder, so you can pass in numbers
### but you can still pass in hexidecimal if you want.
rgs <- c('0-1f4', '1f5-3e8')
conn$core_split("splitcoretest0", targetCore = c("splitcoretest1", "splitcoretest2"), ranges = rgs)
rgs <- list(c(0, 500), c(501, 1000))
conn$core_split("splitcoretest0", targetCore = c("splitcoretest1", "splitcoretest2"), ranges = rgs)
}
}
