---
title: pwtool
section: 1
header: User Manual
footer: pwtool 0.9.3
author: Ed Neville (ed-pwtool@s5h.net)
date: 15 August 2025
---

# NAME

pwtool - a convenience tool to make sane passwords and account creations

# SYNOPSIS

**pwtool**

**pwtool --number N**

**pwtool --length N**

**pwtool --[only]alpha**

**pwtool --[only]numeric**

**pwtool --[only]extended**

**pwtool --[only]lowercase**

**pwtool --[only]uppercase**

**pwtool --md5**

**pwtool --des**

**pwtool --bcrypt**

**pwtool --sha[1,256,512]**

**pwtool --username [name]**

**pwtool --database [name]**

**pwtool --createdatabase**

**pwtool --password STRING**

**pwtool --totp STRING**

**pwtool --totpstep NUMBER**

# DESCRIPTION

**pwtool** is a utility to add generate account passwords in a variety of formats with helper output on **stdout**. By default the password strings are made of of letters and numbers for easy mouse selection.

As well as flexible password generation options a main goal is to output user creation strings to copy and paste/execute as stdin so that operators don't have to re-type passwords.

Crypts can be based on user supplied strings via the **--password** option or **PASSWORD** environment variable.

The **--format** string can expand values:

    pwtool --database billing --username wonkeydonkey --password hunter2 --servername webby --number 1 --format 'DB: %{database}\\nUSR: %{username}\\nPASSWORD: %{password}\\nSERVER: %{servername}\\n'

Other strings, such as **--mysqlfmt**, **--pgfmt**, **--mysqluserfmt**, **--userfmt**, can generate copy/paste shell commands:

    pwtool --username wonkeydonkey --number 1 --userfmt

    useradd -m -s /bin/bash -p '$5$hYhnxam4j/chBu3V$BsZsRl4nj6DTpEdFMfLuerPFR0xvCJmeGQCUjuG9qM1' wonkeydonkey # Y9YgmSyv1A

    pwtool --username wonkeydonkey --database circus --createdatabase --number 1 --mysqlfmt

    create database circus; grant all privileges on circus.* to wonkeydonkey@'%' identified with mysql_native_password as '*21c0a42c1bb43ff6b56226a6a65a8859dd077497'; -- # VfKptnR2ft


# TOTP

**pwtool** can work as a TOTP CLI and display TOTP authentication strings.

If you want to leave a TOTP authentication display in your terminal, it can run like this:

    TOTP=metalisbest pwtool --totpfmt --loopdelay 1

It will then run and leave a display like this:

    202924 [#########################     ]

If you have multiple accounts, they can be displayed like this:

  TOTP="metalisbest;grungeisbest" pwtool --totpfmt --loopdelay 1

    617989 [##################            ]
    826783 [##################            ]

That doesn't show you the names, so you can include that with key=value strings:

    TOTP="key=metalisbest,name=metal;key=grungeisbest,name=grunge" pwtool --format "%{totpfmt} %{username}\n" --loopdelay 1

    488833 [#################             ] metal
    967495 [#################             ] grunge

The following key=value pairs are supported:

| key | definition |
|----------|--------|
| key / totp | the totp string | 
| name / username | a meaningful name for this key | 
| step | number of step seconds | 
| digits | the length of the output | 
| algo | which hmac to use (sha1, sha256, sha512) | 
| seconds | a user-defined time | 

