libstb-secvar
==============

Linux on Power LPAR Secure Boot Authenticated Variable Processing Library

What is libstb-secvar
---------------------

This library makes it easier to process data from variable authentication files and to
update variables' data in the platform keystore with a timestamp. It is supporting the following
9 predefined secure boot variables and an arbitrary variables.

Secure Boot Variables:

1. PK
2. KEK
3. db
4. dbx
5. grubdb
6. grubdbx
7. sbat
8. moduledb
9. trustedcadb

Moreover, it makes it easier to update and append variables, delete variables using PK,
and delete keys using KEK.

Metadata for Auth file
-----------------------

Variables auth file is generated by secvarct tool, which will be pushed by user to platform
keystore. Also, providing that a variable update with no data (with the append Header zero)
represents deletion of the variable.

The auth file data format is:

                |-----------------------------------|
                |                                   |
                |          Append Header            |
                |           (8 bytes)               |
                |-----------------------------------|
                |                                   |
                |          Auth Info                |
                |                                   |
                |   |-------------------------------|
                |   |      Auth Header              |
                |   |       (40 byte)               |
                |   |-------------------------------|
                |   |      PKCS7 data               |
                |---|-------------------------------|
                |                                   |
                |          Variable Info            |
                |                                   |
                |   |-------------------------------|
                |   |     ESL Header                |
                |   |      (44 byte)                |
                |   |-------------------------------|
                |   |      ESL Data                 |
                |-----------------------------------|


Metadata for signed variables at Platform Keystore
--------------------------------------------------

Variables have replay/rollback protection via a timestamp which is stored with
the variable. It will be used by firmware and grub to verify the signed grub and
kernel respectively.

The signed variable format is:

                |-----------------------------------|
                |                                   |
                |            timesatamp             |
                |            (8 bytes)              |
                |-----------------------------------|
                |                                   |
                |            Variable Data          |
                |   |-------------------------------|
                |   |      ESL Datas                |
                |-----------------------------------|

Quick Start
-----------

```
Build:
    cd libstb-secvar
    make

UnitTest:
    make test
    make check

Note:-
   after building libstb-secvar, the library file is placed in the lib directory.

   libstb-secvar/lib
```

Copyright
---------

All code in this repository is Copyright IBM, and provided under the BSD 2-Clause license, with the exception of code included in the `external/` directory.
Externally sourced source files have their respective licenses provided in the containing directory.
