/* Public domain */

#ifndef SOCKET_H
#define SOCKET_H

#include "gccattributes.h"
#include "uint16.h"
#include "tai.h"

extern int socket_tcp (void) ;
extern int socket_udp (void) ;

extern int socket_deadlineconn (int, char const *, uint16, struct taia const *) ;
extern int socket_timeoutconn (int, char const *, uint16, unsigned int) ;
extern int socket_connect4 (int, char const *, uint16) ;
extern int socket_connected (int) gccattr_const ;
extern int socket_bind4 (int, char const *, uint16) ;
extern int socket_bind4_reuse (int, char const *, uint16) ;
extern int socket_listen (int, int) ;
extern int socket_accept4 (int, char *, uint16 *) ;
extern int socket_recv4 (int, char *, int, char *, uint16 *) ;
extern int socket_send4 (int, char const *, int, char const *, uint16) ;
extern int socket_local4 (int, char *, uint16 *) ;
extern int socket_remote4 (int, char *, uint16 *) ;

extern int socket_ipoptionskill (int) ;
extern int socket_tcpnodelay (int) ;
extern void socket_tryreservein (int, unsigned int) ;

#endif
