// Copyright (C) 2019 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by gen-grammar.go --template=../schema/schema.go.tmpl --out=../schema/schema.go
// Do not modify this file directly.

package schema

// Opcode holds information about a specific SPIR-V opcode.
type Opcode struct {
	Opname   string
	Class    string
	Opcode   int
	Operands []Operand
}

// Operand contains information about a logical operand for an instruction.
type Operand struct {
	Kind       *OperandKind
	Name       string
	Quantifier Quantifier
}

// OperandKind contains information about a specific operand kind.
type OperandKind struct {
	Category   OperandCategory
	Kind       string
	Enumerants []Enumerant
	Bases      []*OperandKind
}

// Enumerant contains information about an enumerant in an enum.
type Enumerant struct {
	Enumerant    string
	Value        interface{}
	Capabilities []string
	Parameters   []Parameter
	Version      string
}

// Parameter contains information about a logical parameter for an enumerant.
type Parameter struct {
	Kind *OperandKind
	Name string
}

// Quantifier indicates the number of times the quantified term may appear.
type Quantifier string

const (
	// Once indicates the quantified term may appear exactly once.
	Once Quantifier = ""

	// ZeroOrOnce indicates the quantified term may appear zero or one
	// time; an optional term.
	ZeroOrOnce Quantifier = "?"

	// ZeroOrMany indicates the quantified term may appear any number of
	// times.
	ZeroOrMany Quantifier = "*"
)

// OperandCategory is an enumerator that groups operand kinds.
type OperandCategory string

const (
	// OperandCategoryBitEnum describes an operand kind where its value is a
	// mask, which is formed by combining the bits specified as enumerants in an
	// enum.
	OperandCategoryBitEnum = "BitEnum"

	// OperandCategoryValueEnum describes an operand kind where its value is an
	// enumerant from an enum.
	OperandCategoryValueEnum = "ValueEnum"

	// OperandCategoryID describes and operand kind where its value is an <id>
	// definition or reference.
	OperandCategoryID = "Id"

	// OperandCategoryLiteral describes and operand kind where its value is an
	// literal number or string.
	OperandCategoryLiteral = "Literal"

	// OperandCategoryComposite describes and operand kind where its value is
	// composed from operand values from the above categories.
	OperandCategoryComposite = "Composite"
)

var (
	// Opcodes is a map of opcode name to Opcode description.
	Opcodes = map[string]*Opcode {
		"OpNop": OpNop,
		"OpUndef": OpUndef,
		"OpSourceContinued": OpSourceContinued,
		"OpSource": OpSource,
		"OpSourceExtension": OpSourceExtension,
		"OpName": OpName,
		"OpMemberName": OpMemberName,
		"OpString": OpString,
		"OpLine": OpLine,
		"OpExtension": OpExtension,
		"OpExtInstImport": OpExtInstImport,
		"OpExtInst": OpExtInst,
		"OpMemoryModel": OpMemoryModel,
		"OpEntryPoint": OpEntryPoint,
		"OpExecutionMode": OpExecutionMode,
		"OpCapability": OpCapability,
		"OpTypeVoid": OpTypeVoid,
		"OpTypeBool": OpTypeBool,
		"OpTypeInt": OpTypeInt,
		"OpTypeFloat": OpTypeFloat,
		"OpTypeVector": OpTypeVector,
		"OpTypeMatrix": OpTypeMatrix,
		"OpTypeImage": OpTypeImage,
		"OpTypeSampler": OpTypeSampler,
		"OpTypeSampledImage": OpTypeSampledImage,
		"OpTypeArray": OpTypeArray,
		"OpTypeRuntimeArray": OpTypeRuntimeArray,
		"OpTypeStruct": OpTypeStruct,
		"OpTypeOpaque": OpTypeOpaque,
		"OpTypePointer": OpTypePointer,
		"OpTypeFunction": OpTypeFunction,
		"OpTypeEvent": OpTypeEvent,
		"OpTypeDeviceEvent": OpTypeDeviceEvent,
		"OpTypeReserveId": OpTypeReserveId,
		"OpTypeQueue": OpTypeQueue,
		"OpTypePipe": OpTypePipe,
		"OpTypeForwardPointer": OpTypeForwardPointer,
		"OpConstantTrue": OpConstantTrue,
		"OpConstantFalse": OpConstantFalse,
		"OpConstant": OpConstant,
		"OpConstantComposite": OpConstantComposite,
		"OpConstantSampler": OpConstantSampler,
		"OpConstantNull": OpConstantNull,
		"OpSpecConstantTrue": OpSpecConstantTrue,
		"OpSpecConstantFalse": OpSpecConstantFalse,
		"OpSpecConstant": OpSpecConstant,
		"OpSpecConstantComposite": OpSpecConstantComposite,
		"OpSpecConstantOp": OpSpecConstantOp,
		"OpFunction": OpFunction,
		"OpFunctionParameter": OpFunctionParameter,
		"OpFunctionEnd": OpFunctionEnd,
		"OpFunctionCall": OpFunctionCall,
		"OpVariable": OpVariable,
		"OpImageTexelPointer": OpImageTexelPointer,
		"OpLoad": OpLoad,
		"OpStore": OpStore,
		"OpCopyMemory": OpCopyMemory,
		"OpCopyMemorySized": OpCopyMemorySized,
		"OpAccessChain": OpAccessChain,
		"OpInBoundsAccessChain": OpInBoundsAccessChain,
		"OpPtrAccessChain": OpPtrAccessChain,
		"OpArrayLength": OpArrayLength,
		"OpGenericPtrMemSemantics": OpGenericPtrMemSemantics,
		"OpInBoundsPtrAccessChain": OpInBoundsPtrAccessChain,
		"OpDecorate": OpDecorate,
		"OpMemberDecorate": OpMemberDecorate,
		"OpDecorationGroup": OpDecorationGroup,
		"OpGroupDecorate": OpGroupDecorate,
		"OpGroupMemberDecorate": OpGroupMemberDecorate,
		"OpVectorExtractDynamic": OpVectorExtractDynamic,
		"OpVectorInsertDynamic": OpVectorInsertDynamic,
		"OpVectorShuffle": OpVectorShuffle,
		"OpCompositeConstruct": OpCompositeConstruct,
		"OpCompositeExtract": OpCompositeExtract,
		"OpCompositeInsert": OpCompositeInsert,
		"OpCopyObject": OpCopyObject,
		"OpTranspose": OpTranspose,
		"OpSampledImage": OpSampledImage,
		"OpImageSampleImplicitLod": OpImageSampleImplicitLod,
		"OpImageSampleExplicitLod": OpImageSampleExplicitLod,
		"OpImageSampleDrefImplicitLod": OpImageSampleDrefImplicitLod,
		"OpImageSampleDrefExplicitLod": OpImageSampleDrefExplicitLod,
		"OpImageSampleProjImplicitLod": OpImageSampleProjImplicitLod,
		"OpImageSampleProjExplicitLod": OpImageSampleProjExplicitLod,
		"OpImageSampleProjDrefImplicitLod": OpImageSampleProjDrefImplicitLod,
		"OpImageSampleProjDrefExplicitLod": OpImageSampleProjDrefExplicitLod,
		"OpImageFetch": OpImageFetch,
		"OpImageGather": OpImageGather,
		"OpImageDrefGather": OpImageDrefGather,
		"OpImageRead": OpImageRead,
		"OpImageWrite": OpImageWrite,
		"OpImage": OpImage,
		"OpImageQueryFormat": OpImageQueryFormat,
		"OpImageQueryOrder": OpImageQueryOrder,
		"OpImageQuerySizeLod": OpImageQuerySizeLod,
		"OpImageQuerySize": OpImageQuerySize,
		"OpImageQueryLod": OpImageQueryLod,
		"OpImageQueryLevels": OpImageQueryLevels,
		"OpImageQuerySamples": OpImageQuerySamples,
		"OpConvertFToU": OpConvertFToU,
		"OpConvertFToS": OpConvertFToS,
		"OpConvertSToF": OpConvertSToF,
		"OpConvertUToF": OpConvertUToF,
		"OpUConvert": OpUConvert,
		"OpSConvert": OpSConvert,
		"OpFConvert": OpFConvert,
		"OpQuantizeToF16": OpQuantizeToF16,
		"OpConvertPtrToU": OpConvertPtrToU,
		"OpSatConvertSToU": OpSatConvertSToU,
		"OpSatConvertUToS": OpSatConvertUToS,
		"OpConvertUToPtr": OpConvertUToPtr,
		"OpPtrCastToGeneric": OpPtrCastToGeneric,
		"OpGenericCastToPtr": OpGenericCastToPtr,
		"OpGenericCastToPtrExplicit": OpGenericCastToPtrExplicit,
		"OpBitcast": OpBitcast,
		"OpSNegate": OpSNegate,
		"OpFNegate": OpFNegate,
		"OpIAdd": OpIAdd,
		"OpFAdd": OpFAdd,
		"OpISub": OpISub,
		"OpFSub": OpFSub,
		"OpIMul": OpIMul,
		"OpFMul": OpFMul,
		"OpUDiv": OpUDiv,
		"OpSDiv": OpSDiv,
		"OpFDiv": OpFDiv,
		"OpUMod": OpUMod,
		"OpSRem": OpSRem,
		"OpSMod": OpSMod,
		"OpFRem": OpFRem,
		"OpFMod": OpFMod,
		"OpVectorTimesScalar": OpVectorTimesScalar,
		"OpMatrixTimesScalar": OpMatrixTimesScalar,
		"OpVectorTimesMatrix": OpVectorTimesMatrix,
		"OpMatrixTimesVector": OpMatrixTimesVector,
		"OpMatrixTimesMatrix": OpMatrixTimesMatrix,
		"OpOuterProduct": OpOuterProduct,
		"OpDot": OpDot,
		"OpIAddCarry": OpIAddCarry,
		"OpISubBorrow": OpISubBorrow,
		"OpUMulExtended": OpUMulExtended,
		"OpSMulExtended": OpSMulExtended,
		"OpAny": OpAny,
		"OpAll": OpAll,
		"OpIsNan": OpIsNan,
		"OpIsInf": OpIsInf,
		"OpIsFinite": OpIsFinite,
		"OpIsNormal": OpIsNormal,
		"OpSignBitSet": OpSignBitSet,
		"OpLessOrGreater": OpLessOrGreater,
		"OpOrdered": OpOrdered,
		"OpUnordered": OpUnordered,
		"OpLogicalEqual": OpLogicalEqual,
		"OpLogicalNotEqual": OpLogicalNotEqual,
		"OpLogicalOr": OpLogicalOr,
		"OpLogicalAnd": OpLogicalAnd,
		"OpLogicalNot": OpLogicalNot,
		"OpSelect": OpSelect,
		"OpIEqual": OpIEqual,
		"OpINotEqual": OpINotEqual,
		"OpUGreaterThan": OpUGreaterThan,
		"OpSGreaterThan": OpSGreaterThan,
		"OpUGreaterThanEqual": OpUGreaterThanEqual,
		"OpSGreaterThanEqual": OpSGreaterThanEqual,
		"OpULessThan": OpULessThan,
		"OpSLessThan": OpSLessThan,
		"OpULessThanEqual": OpULessThanEqual,
		"OpSLessThanEqual": OpSLessThanEqual,
		"OpFOrdEqual": OpFOrdEqual,
		"OpFUnordEqual": OpFUnordEqual,
		"OpFOrdNotEqual": OpFOrdNotEqual,
		"OpFUnordNotEqual": OpFUnordNotEqual,
		"OpFOrdLessThan": OpFOrdLessThan,
		"OpFUnordLessThan": OpFUnordLessThan,
		"OpFOrdGreaterThan": OpFOrdGreaterThan,
		"OpFUnordGreaterThan": OpFUnordGreaterThan,
		"OpFOrdLessThanEqual": OpFOrdLessThanEqual,
		"OpFUnordLessThanEqual": OpFUnordLessThanEqual,
		"OpFOrdGreaterThanEqual": OpFOrdGreaterThanEqual,
		"OpFUnordGreaterThanEqual": OpFUnordGreaterThanEqual,
		"OpShiftRightLogical": OpShiftRightLogical,
		"OpShiftRightArithmetic": OpShiftRightArithmetic,
		"OpShiftLeftLogical": OpShiftLeftLogical,
		"OpBitwiseOr": OpBitwiseOr,
		"OpBitwiseXor": OpBitwiseXor,
		"OpBitwiseAnd": OpBitwiseAnd,
		"OpNot": OpNot,
		"OpBitFieldInsert": OpBitFieldInsert,
		"OpBitFieldSExtract": OpBitFieldSExtract,
		"OpBitFieldUExtract": OpBitFieldUExtract,
		"OpBitReverse": OpBitReverse,
		"OpBitCount": OpBitCount,
		"OpDPdx": OpDPdx,
		"OpDPdy": OpDPdy,
		"OpFwidth": OpFwidth,
		"OpDPdxFine": OpDPdxFine,
		"OpDPdyFine": OpDPdyFine,
		"OpFwidthFine": OpFwidthFine,
		"OpDPdxCoarse": OpDPdxCoarse,
		"OpDPdyCoarse": OpDPdyCoarse,
		"OpFwidthCoarse": OpFwidthCoarse,
		"OpEmitVertex": OpEmitVertex,
		"OpEndPrimitive": OpEndPrimitive,
		"OpEmitStreamVertex": OpEmitStreamVertex,
		"OpEndStreamPrimitive": OpEndStreamPrimitive,
		"OpControlBarrier": OpControlBarrier,
		"OpMemoryBarrier": OpMemoryBarrier,
		"OpAtomicLoad": OpAtomicLoad,
		"OpAtomicStore": OpAtomicStore,
		"OpAtomicExchange": OpAtomicExchange,
		"OpAtomicCompareExchange": OpAtomicCompareExchange,
		"OpAtomicCompareExchangeWeak": OpAtomicCompareExchangeWeak,
		"OpAtomicIIncrement": OpAtomicIIncrement,
		"OpAtomicIDecrement": OpAtomicIDecrement,
		"OpAtomicIAdd": OpAtomicIAdd,
		"OpAtomicISub": OpAtomicISub,
		"OpAtomicSMin": OpAtomicSMin,
		"OpAtomicUMin": OpAtomicUMin,
		"OpAtomicSMax": OpAtomicSMax,
		"OpAtomicUMax": OpAtomicUMax,
		"OpAtomicAnd": OpAtomicAnd,
		"OpAtomicOr": OpAtomicOr,
		"OpAtomicXor": OpAtomicXor,
		"OpPhi": OpPhi,
		"OpLoopMerge": OpLoopMerge,
		"OpSelectionMerge": OpSelectionMerge,
		"OpLabel": OpLabel,
		"OpBranch": OpBranch,
		"OpBranchConditional": OpBranchConditional,
		"OpSwitch": OpSwitch,
		"OpKill": OpKill,
		"OpReturn": OpReturn,
		"OpReturnValue": OpReturnValue,
		"OpUnreachable": OpUnreachable,
		"OpLifetimeStart": OpLifetimeStart,
		"OpLifetimeStop": OpLifetimeStop,
		"OpGroupAsyncCopy": OpGroupAsyncCopy,
		"OpGroupWaitEvents": OpGroupWaitEvents,
		"OpGroupAll": OpGroupAll,
		"OpGroupAny": OpGroupAny,
		"OpGroupBroadcast": OpGroupBroadcast,
		"OpGroupIAdd": OpGroupIAdd,
		"OpGroupFAdd": OpGroupFAdd,
		"OpGroupFMin": OpGroupFMin,
		"OpGroupUMin": OpGroupUMin,
		"OpGroupSMin": OpGroupSMin,
		"OpGroupFMax": OpGroupFMax,
		"OpGroupUMax": OpGroupUMax,
		"OpGroupSMax": OpGroupSMax,
		"OpReadPipe": OpReadPipe,
		"OpWritePipe": OpWritePipe,
		"OpReservedReadPipe": OpReservedReadPipe,
		"OpReservedWritePipe": OpReservedWritePipe,
		"OpReserveReadPipePackets": OpReserveReadPipePackets,
		"OpReserveWritePipePackets": OpReserveWritePipePackets,
		"OpCommitReadPipe": OpCommitReadPipe,
		"OpCommitWritePipe": OpCommitWritePipe,
		"OpIsValidReserveId": OpIsValidReserveId,
		"OpGetNumPipePackets": OpGetNumPipePackets,
		"OpGetMaxPipePackets": OpGetMaxPipePackets,
		"OpGroupReserveReadPipePackets": OpGroupReserveReadPipePackets,
		"OpGroupReserveWritePipePackets": OpGroupReserveWritePipePackets,
		"OpGroupCommitReadPipe": OpGroupCommitReadPipe,
		"OpGroupCommitWritePipe": OpGroupCommitWritePipe,
		"OpEnqueueMarker": OpEnqueueMarker,
		"OpEnqueueKernel": OpEnqueueKernel,
		"OpGetKernelNDrangeSubGroupCount": OpGetKernelNDrangeSubGroupCount,
		"OpGetKernelNDrangeMaxSubGroupSize": OpGetKernelNDrangeMaxSubGroupSize,
		"OpGetKernelWorkGroupSize": OpGetKernelWorkGroupSize,
		"OpGetKernelPreferredWorkGroupSizeMultiple": OpGetKernelPreferredWorkGroupSizeMultiple,
		"OpRetainEvent": OpRetainEvent,
		"OpReleaseEvent": OpReleaseEvent,
		"OpCreateUserEvent": OpCreateUserEvent,
		"OpIsValidEvent": OpIsValidEvent,
		"OpSetUserEventStatus": OpSetUserEventStatus,
		"OpCaptureEventProfilingInfo": OpCaptureEventProfilingInfo,
		"OpGetDefaultQueue": OpGetDefaultQueue,
		"OpBuildNDRange": OpBuildNDRange,
		"OpImageSparseSampleImplicitLod": OpImageSparseSampleImplicitLod,
		"OpImageSparseSampleExplicitLod": OpImageSparseSampleExplicitLod,
		"OpImageSparseSampleDrefImplicitLod": OpImageSparseSampleDrefImplicitLod,
		"OpImageSparseSampleDrefExplicitLod": OpImageSparseSampleDrefExplicitLod,
		"OpImageSparseSampleProjImplicitLod": OpImageSparseSampleProjImplicitLod,
		"OpImageSparseSampleProjExplicitLod": OpImageSparseSampleProjExplicitLod,
		"OpImageSparseSampleProjDrefImplicitLod": OpImageSparseSampleProjDrefImplicitLod,
		"OpImageSparseSampleProjDrefExplicitLod": OpImageSparseSampleProjDrefExplicitLod,
		"OpImageSparseFetch": OpImageSparseFetch,
		"OpImageSparseGather": OpImageSparseGather,
		"OpImageSparseDrefGather": OpImageSparseDrefGather,
		"OpImageSparseTexelsResident": OpImageSparseTexelsResident,
		"OpNoLine": OpNoLine,
		"OpAtomicFlagTestAndSet": OpAtomicFlagTestAndSet,
		"OpAtomicFlagClear": OpAtomicFlagClear,
		"OpImageSparseRead": OpImageSparseRead,
		"OpSizeOf": OpSizeOf,
		"OpTypePipeStorage": OpTypePipeStorage,
		"OpConstantPipeStorage": OpConstantPipeStorage,
		"OpCreatePipeFromPipeStorage": OpCreatePipeFromPipeStorage,
		"OpGetKernelLocalSizeForSubgroupCount": OpGetKernelLocalSizeForSubgroupCount,
		"OpGetKernelMaxNumSubgroups": OpGetKernelMaxNumSubgroups,
		"OpTypeNamedBarrier": OpTypeNamedBarrier,
		"OpNamedBarrierInitialize": OpNamedBarrierInitialize,
		"OpMemoryNamedBarrier": OpMemoryNamedBarrier,
		"OpModuleProcessed": OpModuleProcessed,
		"OpExecutionModeId": OpExecutionModeId,
		"OpDecorateId": OpDecorateId,
		"OpGroupNonUniformElect": OpGroupNonUniformElect,
		"OpGroupNonUniformAll": OpGroupNonUniformAll,
		"OpGroupNonUniformAny": OpGroupNonUniformAny,
		"OpGroupNonUniformAllEqual": OpGroupNonUniformAllEqual,
		"OpGroupNonUniformBroadcast": OpGroupNonUniformBroadcast,
		"OpGroupNonUniformBroadcastFirst": OpGroupNonUniformBroadcastFirst,
		"OpGroupNonUniformBallot": OpGroupNonUniformBallot,
		"OpGroupNonUniformInverseBallot": OpGroupNonUniformInverseBallot,
		"OpGroupNonUniformBallotBitExtract": OpGroupNonUniformBallotBitExtract,
		"OpGroupNonUniformBallotBitCount": OpGroupNonUniformBallotBitCount,
		"OpGroupNonUniformBallotFindLSB": OpGroupNonUniformBallotFindLSB,
		"OpGroupNonUniformBallotFindMSB": OpGroupNonUniformBallotFindMSB,
		"OpGroupNonUniformShuffle": OpGroupNonUniformShuffle,
		"OpGroupNonUniformShuffleXor": OpGroupNonUniformShuffleXor,
		"OpGroupNonUniformShuffleUp": OpGroupNonUniformShuffleUp,
		"OpGroupNonUniformShuffleDown": OpGroupNonUniformShuffleDown,
		"OpGroupNonUniformIAdd": OpGroupNonUniformIAdd,
		"OpGroupNonUniformFAdd": OpGroupNonUniformFAdd,
		"OpGroupNonUniformIMul": OpGroupNonUniformIMul,
		"OpGroupNonUniformFMul": OpGroupNonUniformFMul,
		"OpGroupNonUniformSMin": OpGroupNonUniformSMin,
		"OpGroupNonUniformUMin": OpGroupNonUniformUMin,
		"OpGroupNonUniformFMin": OpGroupNonUniformFMin,
		"OpGroupNonUniformSMax": OpGroupNonUniformSMax,
		"OpGroupNonUniformUMax": OpGroupNonUniformUMax,
		"OpGroupNonUniformFMax": OpGroupNonUniformFMax,
		"OpGroupNonUniformBitwiseAnd": OpGroupNonUniformBitwiseAnd,
		"OpGroupNonUniformBitwiseOr": OpGroupNonUniformBitwiseOr,
		"OpGroupNonUniformBitwiseXor": OpGroupNonUniformBitwiseXor,
		"OpGroupNonUniformLogicalAnd": OpGroupNonUniformLogicalAnd,
		"OpGroupNonUniformLogicalOr": OpGroupNonUniformLogicalOr,
		"OpGroupNonUniformLogicalXor": OpGroupNonUniformLogicalXor,
		"OpGroupNonUniformQuadBroadcast": OpGroupNonUniformQuadBroadcast,
		"OpGroupNonUniformQuadSwap": OpGroupNonUniformQuadSwap,
		"OpCopyLogical": OpCopyLogical,
		"OpPtrEqual": OpPtrEqual,
		"OpPtrNotEqual": OpPtrNotEqual,
		"OpPtrDiff": OpPtrDiff,
		"OpSubgroupBallotKHR": OpSubgroupBallotKHR,
		"OpSubgroupFirstInvocationKHR": OpSubgroupFirstInvocationKHR,
		"OpSubgroupAllKHR": OpSubgroupAllKHR,
		"OpSubgroupAnyKHR": OpSubgroupAnyKHR,
		"OpSubgroupAllEqualKHR": OpSubgroupAllEqualKHR,
		"OpSubgroupReadInvocationKHR": OpSubgroupReadInvocationKHR,
		"OpGroupIAddNonUniformAMD": OpGroupIAddNonUniformAMD,
		"OpGroupFAddNonUniformAMD": OpGroupFAddNonUniformAMD,
		"OpGroupFMinNonUniformAMD": OpGroupFMinNonUniformAMD,
		"OpGroupUMinNonUniformAMD": OpGroupUMinNonUniformAMD,
		"OpGroupSMinNonUniformAMD": OpGroupSMinNonUniformAMD,
		"OpGroupFMaxNonUniformAMD": OpGroupFMaxNonUniformAMD,
		"OpGroupUMaxNonUniformAMD": OpGroupUMaxNonUniformAMD,
		"OpGroupSMaxNonUniformAMD": OpGroupSMaxNonUniformAMD,
		"OpFragmentMaskFetchAMD": OpFragmentMaskFetchAMD,
		"OpFragmentFetchAMD": OpFragmentFetchAMD,
		"OpReadClockKHR": OpReadClockKHR,
		"OpImageSampleFootprintNV": OpImageSampleFootprintNV,
		"OpGroupNonUniformPartitionNV": OpGroupNonUniformPartitionNV,
		"OpWritePackedPrimitiveIndices4x8NV": OpWritePackedPrimitiveIndices4x8NV,
		"OpReportIntersectionNV": OpReportIntersectionNV,
		"OpIgnoreIntersectionNV": OpIgnoreIntersectionNV,
		"OpTerminateRayNV": OpTerminateRayNV,
		"OpTraceNV": OpTraceNV,
		"OpTypeAccelerationStructureNV": OpTypeAccelerationStructureNV,
		"OpExecuteCallableNV": OpExecuteCallableNV,
		"OpTypeCooperativeMatrixNV": OpTypeCooperativeMatrixNV,
		"OpCooperativeMatrixLoadNV": OpCooperativeMatrixLoadNV,
		"OpCooperativeMatrixStoreNV": OpCooperativeMatrixStoreNV,
		"OpCooperativeMatrixMulAddNV": OpCooperativeMatrixMulAddNV,
		"OpCooperativeMatrixLengthNV": OpCooperativeMatrixLengthNV,
		"OpBeginInvocationInterlockEXT": OpBeginInvocationInterlockEXT,
		"OpEndInvocationInterlockEXT": OpEndInvocationInterlockEXT,
		"OpDemoteToHelperInvocationEXT": OpDemoteToHelperInvocationEXT,
		"OpIsHelperInvocationEXT": OpIsHelperInvocationEXT,
		"OpSubgroupShuffleINTEL": OpSubgroupShuffleINTEL,
		"OpSubgroupShuffleDownINTEL": OpSubgroupShuffleDownINTEL,
		"OpSubgroupShuffleUpINTEL": OpSubgroupShuffleUpINTEL,
		"OpSubgroupShuffleXorINTEL": OpSubgroupShuffleXorINTEL,
		"OpSubgroupBlockReadINTEL": OpSubgroupBlockReadINTEL,
		"OpSubgroupBlockWriteINTEL": OpSubgroupBlockWriteINTEL,
		"OpSubgroupImageBlockReadINTEL": OpSubgroupImageBlockReadINTEL,
		"OpSubgroupImageBlockWriteINTEL": OpSubgroupImageBlockWriteINTEL,
		"OpSubgroupImageMediaBlockReadINTEL": OpSubgroupImageMediaBlockReadINTEL,
		"OpSubgroupImageMediaBlockWriteINTEL": OpSubgroupImageMediaBlockWriteINTEL,
		"OpUCountLeadingZerosINTEL": OpUCountLeadingZerosINTEL,
		"OpUCountTrailingZerosINTEL": OpUCountTrailingZerosINTEL,
		"OpAbsISubINTEL": OpAbsISubINTEL,
		"OpAbsUSubINTEL": OpAbsUSubINTEL,
		"OpIAddSatINTEL": OpIAddSatINTEL,
		"OpUAddSatINTEL": OpUAddSatINTEL,
		"OpIAverageINTEL": OpIAverageINTEL,
		"OpUAverageINTEL": OpUAverageINTEL,
		"OpIAverageRoundedINTEL": OpIAverageRoundedINTEL,
		"OpUAverageRoundedINTEL": OpUAverageRoundedINTEL,
		"OpISubSatINTEL": OpISubSatINTEL,
		"OpUSubSatINTEL": OpUSubSatINTEL,
		"OpIMul32x16INTEL": OpIMul32x16INTEL,
		"OpUMul32x16INTEL": OpUMul32x16INTEL,
		"OpDecorateString": OpDecorateString,
		"OpDecorateStringGOOGLE": OpDecorateStringGOOGLE,
		"OpMemberDecorateString": OpMemberDecorateString,
		"OpMemberDecorateStringGOOGLE": OpMemberDecorateStringGOOGLE,
		"OpVmeImageINTEL": OpVmeImageINTEL,
		"OpTypeVmeImageINTEL": OpTypeVmeImageINTEL,
		"OpTypeAvcImePayloadINTEL": OpTypeAvcImePayloadINTEL,
		"OpTypeAvcRefPayloadINTEL": OpTypeAvcRefPayloadINTEL,
		"OpTypeAvcSicPayloadINTEL": OpTypeAvcSicPayloadINTEL,
		"OpTypeAvcMcePayloadINTEL": OpTypeAvcMcePayloadINTEL,
		"OpTypeAvcMceResultINTEL": OpTypeAvcMceResultINTEL,
		"OpTypeAvcImeResultINTEL": OpTypeAvcImeResultINTEL,
		"OpTypeAvcImeResultSingleReferenceStreamoutINTEL": OpTypeAvcImeResultSingleReferenceStreamoutINTEL,
		"OpTypeAvcImeResultDualReferenceStreamoutINTEL": OpTypeAvcImeResultDualReferenceStreamoutINTEL,
		"OpTypeAvcImeSingleReferenceStreaminINTEL": OpTypeAvcImeSingleReferenceStreaminINTEL,
		"OpTypeAvcImeDualReferenceStreaminINTEL": OpTypeAvcImeDualReferenceStreaminINTEL,
		"OpTypeAvcRefResultINTEL": OpTypeAvcRefResultINTEL,
		"OpTypeAvcSicResultINTEL": OpTypeAvcSicResultINTEL,
		"OpSubgroupAvcMceGetDefaultInterBaseMultiReferencePenaltyINTEL": OpSubgroupAvcMceGetDefaultInterBaseMultiReferencePenaltyINTEL,
		"OpSubgroupAvcMceSetInterBaseMultiReferencePenaltyINTEL": OpSubgroupAvcMceSetInterBaseMultiReferencePenaltyINTEL,
		"OpSubgroupAvcMceGetDefaultInterShapePenaltyINTEL": OpSubgroupAvcMceGetDefaultInterShapePenaltyINTEL,
		"OpSubgroupAvcMceSetInterShapePenaltyINTEL": OpSubgroupAvcMceSetInterShapePenaltyINTEL,
		"OpSubgroupAvcMceGetDefaultInterDirectionPenaltyINTEL": OpSubgroupAvcMceGetDefaultInterDirectionPenaltyINTEL,
		"OpSubgroupAvcMceSetInterDirectionPenaltyINTEL": OpSubgroupAvcMceSetInterDirectionPenaltyINTEL,
		"OpSubgroupAvcMceGetDefaultIntraLumaShapePenaltyINTEL": OpSubgroupAvcMceGetDefaultIntraLumaShapePenaltyINTEL,
		"OpSubgroupAvcMceGetDefaultInterMotionVectorCostTableINTEL": OpSubgroupAvcMceGetDefaultInterMotionVectorCostTableINTEL,
		"OpSubgroupAvcMceGetDefaultHighPenaltyCostTableINTEL": OpSubgroupAvcMceGetDefaultHighPenaltyCostTableINTEL,
		"OpSubgroupAvcMceGetDefaultMediumPenaltyCostTableINTEL": OpSubgroupAvcMceGetDefaultMediumPenaltyCostTableINTEL,
		"OpSubgroupAvcMceGetDefaultLowPenaltyCostTableINTEL": OpSubgroupAvcMceGetDefaultLowPenaltyCostTableINTEL,
		"OpSubgroupAvcMceSetMotionVectorCostFunctionINTEL": OpSubgroupAvcMceSetMotionVectorCostFunctionINTEL,
		"OpSubgroupAvcMceGetDefaultIntraLumaModePenaltyINTEL": OpSubgroupAvcMceGetDefaultIntraLumaModePenaltyINTEL,
		"OpSubgroupAvcMceGetDefaultNonDcLumaIntraPenaltyINTEL": OpSubgroupAvcMceGetDefaultNonDcLumaIntraPenaltyINTEL,
		"OpSubgroupAvcMceGetDefaultIntraChromaModeBasePenaltyINTEL": OpSubgroupAvcMceGetDefaultIntraChromaModeBasePenaltyINTEL,
		"OpSubgroupAvcMceSetAcOnlyHaarINTEL": OpSubgroupAvcMceSetAcOnlyHaarINTEL,
		"OpSubgroupAvcMceSetSourceInterlacedFieldPolarityINTEL": OpSubgroupAvcMceSetSourceInterlacedFieldPolarityINTEL,
		"OpSubgroupAvcMceSetSingleReferenceInterlacedFieldPolarityINTEL": OpSubgroupAvcMceSetSingleReferenceInterlacedFieldPolarityINTEL,
		"OpSubgroupAvcMceSetDualReferenceInterlacedFieldPolaritiesINTEL": OpSubgroupAvcMceSetDualReferenceInterlacedFieldPolaritiesINTEL,
		"OpSubgroupAvcMceConvertToImePayloadINTEL": OpSubgroupAvcMceConvertToImePayloadINTEL,
		"OpSubgroupAvcMceConvertToImeResultINTEL": OpSubgroupAvcMceConvertToImeResultINTEL,
		"OpSubgroupAvcMceConvertToRefPayloadINTEL": OpSubgroupAvcMceConvertToRefPayloadINTEL,
		"OpSubgroupAvcMceConvertToRefResultINTEL": OpSubgroupAvcMceConvertToRefResultINTEL,
		"OpSubgroupAvcMceConvertToSicPayloadINTEL": OpSubgroupAvcMceConvertToSicPayloadINTEL,
		"OpSubgroupAvcMceConvertToSicResultINTEL": OpSubgroupAvcMceConvertToSicResultINTEL,
		"OpSubgroupAvcMceGetMotionVectorsINTEL": OpSubgroupAvcMceGetMotionVectorsINTEL,
		"OpSubgroupAvcMceGetInterDistortionsINTEL": OpSubgroupAvcMceGetInterDistortionsINTEL,
		"OpSubgroupAvcMceGetBestInterDistortionsINTEL": OpSubgroupAvcMceGetBestInterDistortionsINTEL,
		"OpSubgroupAvcMceGetInterMajorShapeINTEL": OpSubgroupAvcMceGetInterMajorShapeINTEL,
		"OpSubgroupAvcMceGetInterMinorShapeINTEL": OpSubgroupAvcMceGetInterMinorShapeINTEL,
		"OpSubgroupAvcMceGetInterDirectionsINTEL": OpSubgroupAvcMceGetInterDirectionsINTEL,
		"OpSubgroupAvcMceGetInterMotionVectorCountINTEL": OpSubgroupAvcMceGetInterMotionVectorCountINTEL,
		"OpSubgroupAvcMceGetInterReferenceIdsINTEL": OpSubgroupAvcMceGetInterReferenceIdsINTEL,
		"OpSubgroupAvcMceGetInterReferenceInterlacedFieldPolaritiesINTEL": OpSubgroupAvcMceGetInterReferenceInterlacedFieldPolaritiesINTEL,
		"OpSubgroupAvcImeInitializeINTEL": OpSubgroupAvcImeInitializeINTEL,
		"OpSubgroupAvcImeSetSingleReferenceINTEL": OpSubgroupAvcImeSetSingleReferenceINTEL,
		"OpSubgroupAvcImeSetDualReferenceINTEL": OpSubgroupAvcImeSetDualReferenceINTEL,
		"OpSubgroupAvcImeRefWindowSizeINTEL": OpSubgroupAvcImeRefWindowSizeINTEL,
		"OpSubgroupAvcImeAdjustRefOffsetINTEL": OpSubgroupAvcImeAdjustRefOffsetINTEL,
		"OpSubgroupAvcImeConvertToMcePayloadINTEL": OpSubgroupAvcImeConvertToMcePayloadINTEL,
		"OpSubgroupAvcImeSetMaxMotionVectorCountINTEL": OpSubgroupAvcImeSetMaxMotionVectorCountINTEL,
		"OpSubgroupAvcImeSetUnidirectionalMixDisableINTEL": OpSubgroupAvcImeSetUnidirectionalMixDisableINTEL,
		"OpSubgroupAvcImeSetEarlySearchTerminationThresholdINTEL": OpSubgroupAvcImeSetEarlySearchTerminationThresholdINTEL,
		"OpSubgroupAvcImeSetWeightedSadINTEL": OpSubgroupAvcImeSetWeightedSadINTEL,
		"OpSubgroupAvcImeEvaluateWithSingleReferenceINTEL": OpSubgroupAvcImeEvaluateWithSingleReferenceINTEL,
		"OpSubgroupAvcImeEvaluateWithDualReferenceINTEL": OpSubgroupAvcImeEvaluateWithDualReferenceINTEL,
		"OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminINTEL": OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminINTEL,
		"OpSubgroupAvcImeEvaluateWithDualReferenceStreaminINTEL": OpSubgroupAvcImeEvaluateWithDualReferenceStreaminINTEL,
		"OpSubgroupAvcImeEvaluateWithSingleReferenceStreamoutINTEL": OpSubgroupAvcImeEvaluateWithSingleReferenceStreamoutINTEL,
		"OpSubgroupAvcImeEvaluateWithDualReferenceStreamoutINTEL": OpSubgroupAvcImeEvaluateWithDualReferenceStreamoutINTEL,
		"OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminoutINTEL": OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminoutINTEL,
		"OpSubgroupAvcImeEvaluateWithDualReferenceStreaminoutINTEL": OpSubgroupAvcImeEvaluateWithDualReferenceStreaminoutINTEL,
		"OpSubgroupAvcImeConvertToMceResultINTEL": OpSubgroupAvcImeConvertToMceResultINTEL,
		"OpSubgroupAvcImeGetSingleReferenceStreaminINTEL": OpSubgroupAvcImeGetSingleReferenceStreaminINTEL,
		"OpSubgroupAvcImeGetDualReferenceStreaminINTEL": OpSubgroupAvcImeGetDualReferenceStreaminINTEL,
		"OpSubgroupAvcImeStripSingleReferenceStreamoutINTEL": OpSubgroupAvcImeStripSingleReferenceStreamoutINTEL,
		"OpSubgroupAvcImeStripDualReferenceStreamoutINTEL": OpSubgroupAvcImeStripDualReferenceStreamoutINTEL,
		"OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeMotionVectorsINTEL": OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeMotionVectorsINTEL,
		"OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeDistortionsINTEL": OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeDistortionsINTEL,
		"OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeReferenceIdsINTEL": OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeReferenceIdsINTEL,
		"OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeMotionVectorsINTEL": OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeMotionVectorsINTEL,
		"OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeDistortionsINTEL": OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeDistortionsINTEL,
		"OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeReferenceIdsINTEL": OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeReferenceIdsINTEL,
		"OpSubgroupAvcImeGetBorderReachedINTEL": OpSubgroupAvcImeGetBorderReachedINTEL,
		"OpSubgroupAvcImeGetTruncatedSearchIndicationINTEL": OpSubgroupAvcImeGetTruncatedSearchIndicationINTEL,
		"OpSubgroupAvcImeGetUnidirectionalEarlySearchTerminationINTEL": OpSubgroupAvcImeGetUnidirectionalEarlySearchTerminationINTEL,
		"OpSubgroupAvcImeGetWeightingPatternMinimumMotionVectorINTEL": OpSubgroupAvcImeGetWeightingPatternMinimumMotionVectorINTEL,
		"OpSubgroupAvcImeGetWeightingPatternMinimumDistortionINTEL": OpSubgroupAvcImeGetWeightingPatternMinimumDistortionINTEL,
		"OpSubgroupAvcFmeInitializeINTEL": OpSubgroupAvcFmeInitializeINTEL,
		"OpSubgroupAvcBmeInitializeINTEL": OpSubgroupAvcBmeInitializeINTEL,
		"OpSubgroupAvcRefConvertToMcePayloadINTEL": OpSubgroupAvcRefConvertToMcePayloadINTEL,
		"OpSubgroupAvcRefSetBidirectionalMixDisableINTEL": OpSubgroupAvcRefSetBidirectionalMixDisableINTEL,
		"OpSubgroupAvcRefSetBilinearFilterEnableINTEL": OpSubgroupAvcRefSetBilinearFilterEnableINTEL,
		"OpSubgroupAvcRefEvaluateWithSingleReferenceINTEL": OpSubgroupAvcRefEvaluateWithSingleReferenceINTEL,
		"OpSubgroupAvcRefEvaluateWithDualReferenceINTEL": OpSubgroupAvcRefEvaluateWithDualReferenceINTEL,
		"OpSubgroupAvcRefEvaluateWithMultiReferenceINTEL": OpSubgroupAvcRefEvaluateWithMultiReferenceINTEL,
		"OpSubgroupAvcRefEvaluateWithMultiReferenceInterlacedINTEL": OpSubgroupAvcRefEvaluateWithMultiReferenceInterlacedINTEL,
		"OpSubgroupAvcRefConvertToMceResultINTEL": OpSubgroupAvcRefConvertToMceResultINTEL,
		"OpSubgroupAvcSicInitializeINTEL": OpSubgroupAvcSicInitializeINTEL,
		"OpSubgroupAvcSicConfigureSkcINTEL": OpSubgroupAvcSicConfigureSkcINTEL,
		"OpSubgroupAvcSicConfigureIpeLumaINTEL": OpSubgroupAvcSicConfigureIpeLumaINTEL,
		"OpSubgroupAvcSicConfigureIpeLumaChromaINTEL": OpSubgroupAvcSicConfigureIpeLumaChromaINTEL,
		"OpSubgroupAvcSicGetMotionVectorMaskINTEL": OpSubgroupAvcSicGetMotionVectorMaskINTEL,
		"OpSubgroupAvcSicConvertToMcePayloadINTEL": OpSubgroupAvcSicConvertToMcePayloadINTEL,
		"OpSubgroupAvcSicSetIntraLumaShapePenaltyINTEL": OpSubgroupAvcSicSetIntraLumaShapePenaltyINTEL,
		"OpSubgroupAvcSicSetIntraLumaModeCostFunctionINTEL": OpSubgroupAvcSicSetIntraLumaModeCostFunctionINTEL,
		"OpSubgroupAvcSicSetIntraChromaModeCostFunctionINTEL": OpSubgroupAvcSicSetIntraChromaModeCostFunctionINTEL,
		"OpSubgroupAvcSicSetBilinearFilterEnableINTEL": OpSubgroupAvcSicSetBilinearFilterEnableINTEL,
		"OpSubgroupAvcSicSetSkcForwardTransformEnableINTEL": OpSubgroupAvcSicSetSkcForwardTransformEnableINTEL,
		"OpSubgroupAvcSicSetBlockBasedRawSkipSadINTEL": OpSubgroupAvcSicSetBlockBasedRawSkipSadINTEL,
		"OpSubgroupAvcSicEvaluateIpeINTEL": OpSubgroupAvcSicEvaluateIpeINTEL,
		"OpSubgroupAvcSicEvaluateWithSingleReferenceINTEL": OpSubgroupAvcSicEvaluateWithSingleReferenceINTEL,
		"OpSubgroupAvcSicEvaluateWithDualReferenceINTEL": OpSubgroupAvcSicEvaluateWithDualReferenceINTEL,
		"OpSubgroupAvcSicEvaluateWithMultiReferenceINTEL": OpSubgroupAvcSicEvaluateWithMultiReferenceINTEL,
		"OpSubgroupAvcSicEvaluateWithMultiReferenceInterlacedINTEL": OpSubgroupAvcSicEvaluateWithMultiReferenceInterlacedINTEL,
		"OpSubgroupAvcSicConvertToMceResultINTEL": OpSubgroupAvcSicConvertToMceResultINTEL,
		"OpSubgroupAvcSicGetIpeLumaShapeINTEL": OpSubgroupAvcSicGetIpeLumaShapeINTEL,
		"OpSubgroupAvcSicGetBestIpeLumaDistortionINTEL": OpSubgroupAvcSicGetBestIpeLumaDistortionINTEL,
		"OpSubgroupAvcSicGetBestIpeChromaDistortionINTEL": OpSubgroupAvcSicGetBestIpeChromaDistortionINTEL,
		"OpSubgroupAvcSicGetPackedIpeLumaModesINTEL": OpSubgroupAvcSicGetPackedIpeLumaModesINTEL,
		"OpSubgroupAvcSicGetIpeChromaModeINTEL": OpSubgroupAvcSicGetIpeChromaModeINTEL,
		"OpSubgroupAvcSicGetPackedSkcLumaCountThresholdINTEL": OpSubgroupAvcSicGetPackedSkcLumaCountThresholdINTEL,
		"OpSubgroupAvcSicGetPackedSkcLumaSumThresholdINTEL": OpSubgroupAvcSicGetPackedSkcLumaSumThresholdINTEL,
		"OpSubgroupAvcSicGetInterRawSadsINTEL": OpSubgroupAvcSicGetInterRawSadsINTEL,
	}

	OpNop = &Opcode {
		Opname:   "OpNop",
		Operands: []Operand {
		},
	}
	OpUndef = &Opcode {
		Opname:   "OpUndef",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSourceContinued = &Opcode {
		Opname:   "OpSourceContinued",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindLiteralString,
				Name:       "'Continued Source'",
				Quantifier: "",
			}, 
		},
	}
	OpSource = &Opcode {
		Opname:   "OpSource",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindSourceLanguage,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Version'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'File'",
				Quantifier: "?",
			}, 
			Operand {
				Kind:       OperandKindLiteralString,
				Name:       "'Source'",
				Quantifier: "?",
			}, 
		},
	}
	OpSourceExtension = &Opcode {
		Opname:   "OpSourceExtension",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindLiteralString,
				Name:       "'Extension'",
				Quantifier: "",
			}, 
		},
	}
	OpName = &Opcode {
		Opname:   "OpName",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Target'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralString,
				Name:       "'Name'",
				Quantifier: "",
			}, 
		},
	}
	OpMemberName = &Opcode {
		Opname:   "OpMemberName",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Member'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralString,
				Name:       "'Name'",
				Quantifier: "",
			}, 
		},
	}
	OpString = &Opcode {
		Opname:   "OpString",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralString,
				Name:       "'String'",
				Quantifier: "",
			}, 
		},
	}
	OpLine = &Opcode {
		Opname:   "OpLine",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'File'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Line'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Column'",
				Quantifier: "",
			}, 
		},
	}
	OpExtension = &Opcode {
		Opname:   "OpExtension",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindLiteralString,
				Name:       "'Name'",
				Quantifier: "",
			}, 
		},
	}
	OpExtInstImport = &Opcode {
		Opname:   "OpExtInstImport",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralString,
				Name:       "'Name'",
				Quantifier: "",
			}, 
		},
	}
	OpExtInst = &Opcode {
		Opname:   "OpExtInst",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Set'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralExtInstInteger,
				Name:       "'Instruction'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1', + 'Operand 2', + ...",
				Quantifier: "*",
			}, 
		},
	}
	OpMemoryModel = &Opcode {
		Opname:   "OpMemoryModel",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindAddressingModel,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindMemoryModel,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpEntryPoint = &Opcode {
		Opname:   "OpEntryPoint",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindExecutionModel,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Entry Point'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralString,
				Name:       "'Name'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Interface'",
				Quantifier: "*",
			}, 
		},
	}
	OpExecutionMode = &Opcode {
		Opname:   "OpExecutionMode",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Entry Point'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindExecutionMode,
				Name:       "'Mode'",
				Quantifier: "",
			}, 
		},
	}
	OpCapability = &Opcode {
		Opname:   "OpCapability",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindCapability,
				Name:       "'Capability'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeVoid = &Opcode {
		Opname:   "OpTypeVoid",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeBool = &Opcode {
		Opname:   "OpTypeBool",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeInt = &Opcode {
		Opname:   "OpTypeInt",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Width'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Signedness'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeFloat = &Opcode {
		Opname:   "OpTypeFloat",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Width'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeVector = &Opcode {
		Opname:   "OpTypeVector",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Component Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Component Count'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeMatrix = &Opcode {
		Opname:   "OpTypeMatrix",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Column Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Column Count'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeImage = &Opcode {
		Opname:   "OpTypeImage",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDim,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Depth'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Arrayed'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'MS'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Sampled'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageFormat,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindAccessQualifier,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpTypeSampler = &Opcode {
		Opname:   "OpTypeSampler",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeSampledImage = &Opcode {
		Opname:   "OpTypeSampledImage",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image Type'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeArray = &Opcode {
		Opname:   "OpTypeArray",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Element Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Length'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeRuntimeArray = &Opcode {
		Opname:   "OpTypeRuntimeArray",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Element Type'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeStruct = &Opcode {
		Opname:   "OpTypeStruct",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Member 0 type', + 'member 1 type', + ...",
				Quantifier: "*",
			}, 
		},
	}
	OpTypeOpaque = &Opcode {
		Opname:   "OpTypeOpaque",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralString,
				Name:       "The name of the opaque type.",
				Quantifier: "",
			}, 
		},
	}
	OpTypePointer = &Opcode {
		Opname:   "OpTypePointer",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindStorageClass,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Type'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeFunction = &Opcode {
		Opname:   "OpTypeFunction",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Return Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Parameter 0 Type', + 'Parameter 1 Type', + ...",
				Quantifier: "*",
			}, 
		},
	}
	OpTypeEvent = &Opcode {
		Opname:   "OpTypeEvent",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeDeviceEvent = &Opcode {
		Opname:   "OpTypeDeviceEvent",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeReserveId = &Opcode {
		Opname:   "OpTypeReserveId",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeQueue = &Opcode {
		Opname:   "OpTypeQueue",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypePipe = &Opcode {
		Opname:   "OpTypePipe",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindAccessQualifier,
				Name:       "'Qualifier'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeForwardPointer = &Opcode {
		Opname:   "OpTypeForwardPointer",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindStorageClass,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpConstantTrue = &Opcode {
		Opname:   "OpConstantTrue",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpConstantFalse = &Opcode {
		Opname:   "OpConstantFalse",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpConstant = &Opcode {
		Opname:   "OpConstant",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralContextDependentNumber,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpConstantComposite = &Opcode {
		Opname:   "OpConstantComposite",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Constituents'",
				Quantifier: "*",
			}, 
		},
	}
	OpConstantSampler = &Opcode {
		Opname:   "OpConstantSampler",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindSamplerAddressingMode,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Param'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindSamplerFilterMode,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpConstantNull = &Opcode {
		Opname:   "OpConstantNull",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSpecConstantTrue = &Opcode {
		Opname:   "OpSpecConstantTrue",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSpecConstantFalse = &Opcode {
		Opname:   "OpSpecConstantFalse",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSpecConstant = &Opcode {
		Opname:   "OpSpecConstant",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralContextDependentNumber,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpSpecConstantComposite = &Opcode {
		Opname:   "OpSpecConstantComposite",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Constituents'",
				Quantifier: "*",
			}, 
		},
	}
	OpSpecConstantOp = &Opcode {
		Opname:   "OpSpecConstantOp",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralSpecConstantOpInteger,
				Name:       "'Opcode'",
				Quantifier: "",
			}, 
		},
	}
	OpFunction = &Opcode {
		Opname:   "OpFunction",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindFunctionControl,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Function Type'",
				Quantifier: "",
			}, 
		},
	}
	OpFunctionParameter = &Opcode {
		Opname:   "OpFunctionParameter",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpFunctionEnd = &Opcode {
		Opname:   "OpFunctionEnd",
		Operands: []Operand {
		},
	}
	OpFunctionCall = &Opcode {
		Opname:   "OpFunctionCall",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Function'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Argument 0', + 'Argument 1', + ...",
				Quantifier: "*",
			}, 
		},
	}
	OpVariable = &Opcode {
		Opname:   "OpVariable",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindStorageClass,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Initializer'",
				Quantifier: "?",
			}, 
		},
	}
	OpImageTexelPointer = &Opcode {
		Opname:   "OpImageTexelPointer",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sample'",
				Quantifier: "",
			}, 
		},
	}
	OpLoad = &Opcode {
		Opname:   "OpLoad",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindMemoryAccess,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpStore = &Opcode {
		Opname:   "OpStore",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Object'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindMemoryAccess,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpCopyMemory = &Opcode {
		Opname:   "OpCopyMemory",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Target'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindMemoryAccess,
				Name:       "",
				Quantifier: "?",
			}, 
			Operand {
				Kind:       OperandKindMemoryAccess,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpCopyMemorySized = &Opcode {
		Opname:   "OpCopyMemorySized",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Target'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindMemoryAccess,
				Name:       "",
				Quantifier: "?",
			}, 
			Operand {
				Kind:       OperandKindMemoryAccess,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpAccessChain = &Opcode {
		Opname:   "OpAccessChain",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Indexes'",
				Quantifier: "*",
			}, 
		},
	}
	OpInBoundsAccessChain = &Opcode {
		Opname:   "OpInBoundsAccessChain",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Indexes'",
				Quantifier: "*",
			}, 
		},
	}
	OpPtrAccessChain = &Opcode {
		Opname:   "OpPtrAccessChain",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Element'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Indexes'",
				Quantifier: "*",
			}, 
		},
	}
	OpArrayLength = &Opcode {
		Opname:   "OpArrayLength",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Structure'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Array member'",
				Quantifier: "",
			}, 
		},
	}
	OpGenericPtrMemSemantics = &Opcode {
		Opname:   "OpGenericPtrMemSemantics",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
		},
	}
	OpInBoundsPtrAccessChain = &Opcode {
		Opname:   "OpInBoundsPtrAccessChain",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Element'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Indexes'",
				Quantifier: "*",
			}, 
		},
	}
	OpDecorate = &Opcode {
		Opname:   "OpDecorate",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Target'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDecoration,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpMemberDecorate = &Opcode {
		Opname:   "OpMemberDecorate",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Structure Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Member'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDecoration,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpDecorationGroup = &Opcode {
		Opname:   "OpDecorationGroup",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpGroupDecorate = &Opcode {
		Opname:   "OpGroupDecorate",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Decoration Group'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Targets'",
				Quantifier: "*",
			}, 
		},
	}
	OpGroupMemberDecorate = &Opcode {
		Opname:   "OpGroupMemberDecorate",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Decoration Group'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindPairIdRefLiteralInteger,
				Name:       "'Targets'",
				Quantifier: "*",
			}, 
		},
	}
	OpVectorExtractDynamic = &Opcode {
		Opname:   "OpVectorExtractDynamic",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Index'",
				Quantifier: "",
			}, 
		},
	}
	OpVectorInsertDynamic = &Opcode {
		Opname:   "OpVectorInsertDynamic",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Component'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Index'",
				Quantifier: "",
			}, 
		},
	}
	OpVectorShuffle = &Opcode {
		Opname:   "OpVectorShuffle",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector 2'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Components'",
				Quantifier: "*",
			}, 
		},
	}
	OpCompositeConstruct = &Opcode {
		Opname:   "OpCompositeConstruct",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Constituents'",
				Quantifier: "*",
			}, 
		},
	}
	OpCompositeExtract = &Opcode {
		Opname:   "OpCompositeExtract",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Composite'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Indexes'",
				Quantifier: "*",
			}, 
		},
	}
	OpCompositeInsert = &Opcode {
		Opname:   "OpCompositeInsert",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Object'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Composite'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Indexes'",
				Quantifier: "*",
			}, 
		},
	}
	OpCopyObject = &Opcode {
		Opname:   "OpCopyObject",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand'",
				Quantifier: "",
			}, 
		},
	}
	OpTranspose = &Opcode {
		Opname:   "OpTranspose",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Matrix'",
				Quantifier: "",
			}, 
		},
	}
	OpSampledImage = &Opcode {
		Opname:   "OpSampledImage",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampler'",
				Quantifier: "",
			}, 
		},
	}
	OpImageSampleImplicitLod = &Opcode {
		Opname:   "OpImageSampleImplicitLod",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageSampleExplicitLod = &Opcode {
		Opname:   "OpImageSampleExplicitLod",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpImageSampleDrefImplicitLod = &Opcode {
		Opname:   "OpImageSampleDrefImplicitLod",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'D~ref~'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageSampleDrefExplicitLod = &Opcode {
		Opname:   "OpImageSampleDrefExplicitLod",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'D~ref~'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpImageSampleProjImplicitLod = &Opcode {
		Opname:   "OpImageSampleProjImplicitLod",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageSampleProjExplicitLod = &Opcode {
		Opname:   "OpImageSampleProjExplicitLod",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpImageSampleProjDrefImplicitLod = &Opcode {
		Opname:   "OpImageSampleProjDrefImplicitLod",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'D~ref~'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageSampleProjDrefExplicitLod = &Opcode {
		Opname:   "OpImageSampleProjDrefExplicitLod",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'D~ref~'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpImageFetch = &Opcode {
		Opname:   "OpImageFetch",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageGather = &Opcode {
		Opname:   "OpImageGather",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Component'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageDrefGather = &Opcode {
		Opname:   "OpImageDrefGather",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'D~ref~'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageRead = &Opcode {
		Opname:   "OpImageRead",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageWrite = &Opcode {
		Opname:   "OpImageWrite",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Texel'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImage = &Opcode {
		Opname:   "OpImage",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
		},
	}
	OpImageQueryFormat = &Opcode {
		Opname:   "OpImageQueryFormat",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
		},
	}
	OpImageQueryOrder = &Opcode {
		Opname:   "OpImageQueryOrder",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
		},
	}
	OpImageQuerySizeLod = &Opcode {
		Opname:   "OpImageQuerySizeLod",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Level of Detail'",
				Quantifier: "",
			}, 
		},
	}
	OpImageQuerySize = &Opcode {
		Opname:   "OpImageQuerySize",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
		},
	}
	OpImageQueryLod = &Opcode {
		Opname:   "OpImageQueryLod",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
		},
	}
	OpImageQueryLevels = &Opcode {
		Opname:   "OpImageQueryLevels",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
		},
	}
	OpImageQuerySamples = &Opcode {
		Opname:   "OpImageQuerySamples",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
		},
	}
	OpConvertFToU = &Opcode {
		Opname:   "OpConvertFToU",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Float Value'",
				Quantifier: "",
			}, 
		},
	}
	OpConvertFToS = &Opcode {
		Opname:   "OpConvertFToS",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Float Value'",
				Quantifier: "",
			}, 
		},
	}
	OpConvertSToF = &Opcode {
		Opname:   "OpConvertSToF",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Signed Value'",
				Quantifier: "",
			}, 
		},
	}
	OpConvertUToF = &Opcode {
		Opname:   "OpConvertUToF",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Unsigned Value'",
				Quantifier: "",
			}, 
		},
	}
	OpUConvert = &Opcode {
		Opname:   "OpUConvert",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Unsigned Value'",
				Quantifier: "",
			}, 
		},
	}
	OpSConvert = &Opcode {
		Opname:   "OpSConvert",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Signed Value'",
				Quantifier: "",
			}, 
		},
	}
	OpFConvert = &Opcode {
		Opname:   "OpFConvert",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Float Value'",
				Quantifier: "",
			}, 
		},
	}
	OpQuantizeToF16 = &Opcode {
		Opname:   "OpQuantizeToF16",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpConvertPtrToU = &Opcode {
		Opname:   "OpConvertPtrToU",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
		},
	}
	OpSatConvertSToU = &Opcode {
		Opname:   "OpSatConvertSToU",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Signed Value'",
				Quantifier: "",
			}, 
		},
	}
	OpSatConvertUToS = &Opcode {
		Opname:   "OpSatConvertUToS",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Unsigned Value'",
				Quantifier: "",
			}, 
		},
	}
	OpConvertUToPtr = &Opcode {
		Opname:   "OpConvertUToPtr",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Integer Value'",
				Quantifier: "",
			}, 
		},
	}
	OpPtrCastToGeneric = &Opcode {
		Opname:   "OpPtrCastToGeneric",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
		},
	}
	OpGenericCastToPtr = &Opcode {
		Opname:   "OpGenericCastToPtr",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
		},
	}
	OpGenericCastToPtrExplicit = &Opcode {
		Opname:   "OpGenericCastToPtrExplicit",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindStorageClass,
				Name:       "'Storage'",
				Quantifier: "",
			}, 
		},
	}
	OpBitcast = &Opcode {
		Opname:   "OpBitcast",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand'",
				Quantifier: "",
			}, 
		},
	}
	OpSNegate = &Opcode {
		Opname:   "OpSNegate",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand'",
				Quantifier: "",
			}, 
		},
	}
	OpFNegate = &Opcode {
		Opname:   "OpFNegate",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand'",
				Quantifier: "",
			}, 
		},
	}
	OpIAdd = &Opcode {
		Opname:   "OpIAdd",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFAdd = &Opcode {
		Opname:   "OpFAdd",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpISub = &Opcode {
		Opname:   "OpISub",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFSub = &Opcode {
		Opname:   "OpFSub",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpIMul = &Opcode {
		Opname:   "OpIMul",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFMul = &Opcode {
		Opname:   "OpFMul",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpUDiv = &Opcode {
		Opname:   "OpUDiv",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpSDiv = &Opcode {
		Opname:   "OpSDiv",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFDiv = &Opcode {
		Opname:   "OpFDiv",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpUMod = &Opcode {
		Opname:   "OpUMod",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpSRem = &Opcode {
		Opname:   "OpSRem",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpSMod = &Opcode {
		Opname:   "OpSMod",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFRem = &Opcode {
		Opname:   "OpFRem",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFMod = &Opcode {
		Opname:   "OpFMod",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpVectorTimesScalar = &Opcode {
		Opname:   "OpVectorTimesScalar",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Scalar'",
				Quantifier: "",
			}, 
		},
	}
	OpMatrixTimesScalar = &Opcode {
		Opname:   "OpMatrixTimesScalar",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Matrix'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Scalar'",
				Quantifier: "",
			}, 
		},
	}
	OpVectorTimesMatrix = &Opcode {
		Opname:   "OpVectorTimesMatrix",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Matrix'",
				Quantifier: "",
			}, 
		},
	}
	OpMatrixTimesVector = &Opcode {
		Opname:   "OpMatrixTimesVector",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Matrix'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector'",
				Quantifier: "",
			}, 
		},
	}
	OpMatrixTimesMatrix = &Opcode {
		Opname:   "OpMatrixTimesMatrix",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'LeftMatrix'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RightMatrix'",
				Quantifier: "",
			}, 
		},
	}
	OpOuterProduct = &Opcode {
		Opname:   "OpOuterProduct",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector 2'",
				Quantifier: "",
			}, 
		},
	}
	OpDot = &Opcode {
		Opname:   "OpDot",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector 2'",
				Quantifier: "",
			}, 
		},
	}
	OpIAddCarry = &Opcode {
		Opname:   "OpIAddCarry",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpISubBorrow = &Opcode {
		Opname:   "OpISubBorrow",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpUMulExtended = &Opcode {
		Opname:   "OpUMulExtended",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpSMulExtended = &Opcode {
		Opname:   "OpSMulExtended",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpAny = &Opcode {
		Opname:   "OpAny",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector'",
				Quantifier: "",
			}, 
		},
	}
	OpAll = &Opcode {
		Opname:   "OpAll",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector'",
				Quantifier: "",
			}, 
		},
	}
	OpIsNan = &Opcode {
		Opname:   "OpIsNan",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpIsInf = &Opcode {
		Opname:   "OpIsInf",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpIsFinite = &Opcode {
		Opname:   "OpIsFinite",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpIsNormal = &Opcode {
		Opname:   "OpIsNormal",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpSignBitSet = &Opcode {
		Opname:   "OpSignBitSet",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpLessOrGreater = &Opcode {
		Opname:   "OpLessOrGreater",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpOrdered = &Opcode {
		Opname:   "OpOrdered",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpUnordered = &Opcode {
		Opname:   "OpUnordered",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpLogicalEqual = &Opcode {
		Opname:   "OpLogicalEqual",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpLogicalNotEqual = &Opcode {
		Opname:   "OpLogicalNotEqual",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpLogicalOr = &Opcode {
		Opname:   "OpLogicalOr",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpLogicalAnd = &Opcode {
		Opname:   "OpLogicalAnd",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpLogicalNot = &Opcode {
		Opname:   "OpLogicalNot",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand'",
				Quantifier: "",
			}, 
		},
	}
	OpSelect = &Opcode {
		Opname:   "OpSelect",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Condition'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Object 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Object 2'",
				Quantifier: "",
			}, 
		},
	}
	OpIEqual = &Opcode {
		Opname:   "OpIEqual",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpINotEqual = &Opcode {
		Opname:   "OpINotEqual",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpUGreaterThan = &Opcode {
		Opname:   "OpUGreaterThan",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpSGreaterThan = &Opcode {
		Opname:   "OpSGreaterThan",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpUGreaterThanEqual = &Opcode {
		Opname:   "OpUGreaterThanEqual",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpSGreaterThanEqual = &Opcode {
		Opname:   "OpSGreaterThanEqual",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpULessThan = &Opcode {
		Opname:   "OpULessThan",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpSLessThan = &Opcode {
		Opname:   "OpSLessThan",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpULessThanEqual = &Opcode {
		Opname:   "OpULessThanEqual",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpSLessThanEqual = &Opcode {
		Opname:   "OpSLessThanEqual",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFOrdEqual = &Opcode {
		Opname:   "OpFOrdEqual",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFUnordEqual = &Opcode {
		Opname:   "OpFUnordEqual",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFOrdNotEqual = &Opcode {
		Opname:   "OpFOrdNotEqual",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFUnordNotEqual = &Opcode {
		Opname:   "OpFUnordNotEqual",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFOrdLessThan = &Opcode {
		Opname:   "OpFOrdLessThan",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFUnordLessThan = &Opcode {
		Opname:   "OpFUnordLessThan",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFOrdGreaterThan = &Opcode {
		Opname:   "OpFOrdGreaterThan",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFUnordGreaterThan = &Opcode {
		Opname:   "OpFUnordGreaterThan",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFOrdLessThanEqual = &Opcode {
		Opname:   "OpFOrdLessThanEqual",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFUnordLessThanEqual = &Opcode {
		Opname:   "OpFUnordLessThanEqual",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFOrdGreaterThanEqual = &Opcode {
		Opname:   "OpFOrdGreaterThanEqual",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFUnordGreaterThanEqual = &Opcode {
		Opname:   "OpFUnordGreaterThanEqual",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpShiftRightLogical = &Opcode {
		Opname:   "OpShiftRightLogical",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Shift'",
				Quantifier: "",
			}, 
		},
	}
	OpShiftRightArithmetic = &Opcode {
		Opname:   "OpShiftRightArithmetic",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Shift'",
				Quantifier: "",
			}, 
		},
	}
	OpShiftLeftLogical = &Opcode {
		Opname:   "OpShiftLeftLogical",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Shift'",
				Quantifier: "",
			}, 
		},
	}
	OpBitwiseOr = &Opcode {
		Opname:   "OpBitwiseOr",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpBitwiseXor = &Opcode {
		Opname:   "OpBitwiseXor",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpBitwiseAnd = &Opcode {
		Opname:   "OpBitwiseAnd",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpNot = &Opcode {
		Opname:   "OpNot",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand'",
				Quantifier: "",
			}, 
		},
	}
	OpBitFieldInsert = &Opcode {
		Opname:   "OpBitFieldInsert",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Insert'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Count'",
				Quantifier: "",
			}, 
		},
	}
	OpBitFieldSExtract = &Opcode {
		Opname:   "OpBitFieldSExtract",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Count'",
				Quantifier: "",
			}, 
		},
	}
	OpBitFieldUExtract = &Opcode {
		Opname:   "OpBitFieldUExtract",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Count'",
				Quantifier: "",
			}, 
		},
	}
	OpBitReverse = &Opcode {
		Opname:   "OpBitReverse",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
		},
	}
	OpBitCount = &Opcode {
		Opname:   "OpBitCount",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
		},
	}
	OpDPdx = &Opcode {
		Opname:   "OpDPdx",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'P'",
				Quantifier: "",
			}, 
		},
	}
	OpDPdy = &Opcode {
		Opname:   "OpDPdy",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'P'",
				Quantifier: "",
			}, 
		},
	}
	OpFwidth = &Opcode {
		Opname:   "OpFwidth",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'P'",
				Quantifier: "",
			}, 
		},
	}
	OpDPdxFine = &Opcode {
		Opname:   "OpDPdxFine",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'P'",
				Quantifier: "",
			}, 
		},
	}
	OpDPdyFine = &Opcode {
		Opname:   "OpDPdyFine",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'P'",
				Quantifier: "",
			}, 
		},
	}
	OpFwidthFine = &Opcode {
		Opname:   "OpFwidthFine",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'P'",
				Quantifier: "",
			}, 
		},
	}
	OpDPdxCoarse = &Opcode {
		Opname:   "OpDPdxCoarse",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'P'",
				Quantifier: "",
			}, 
		},
	}
	OpDPdyCoarse = &Opcode {
		Opname:   "OpDPdyCoarse",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'P'",
				Quantifier: "",
			}, 
		},
	}
	OpFwidthCoarse = &Opcode {
		Opname:   "OpFwidthCoarse",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'P'",
				Quantifier: "",
			}, 
		},
	}
	OpEmitVertex = &Opcode {
		Opname:   "OpEmitVertex",
		Operands: []Operand {
		},
	}
	OpEndPrimitive = &Opcode {
		Opname:   "OpEndPrimitive",
		Operands: []Operand {
		},
	}
	OpEmitStreamVertex = &Opcode {
		Opname:   "OpEmitStreamVertex",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Stream'",
				Quantifier: "",
			}, 
		},
	}
	OpEndStreamPrimitive = &Opcode {
		Opname:   "OpEndStreamPrimitive",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Stream'",
				Quantifier: "",
			}, 
		},
	}
	OpControlBarrier = &Opcode {
		Opname:   "OpControlBarrier",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
		},
	}
	OpMemoryBarrier = &Opcode {
		Opname:   "OpMemoryBarrier",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicLoad = &Opcode {
		Opname:   "OpAtomicLoad",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicStore = &Opcode {
		Opname:   "OpAtomicStore",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicExchange = &Opcode {
		Opname:   "OpAtomicExchange",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicCompareExchange = &Opcode {
		Opname:   "OpAtomicCompareExchange",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Equal'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Unequal'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Comparator'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicCompareExchangeWeak = &Opcode {
		Opname:   "OpAtomicCompareExchangeWeak",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Equal'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Unequal'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Comparator'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicIIncrement = &Opcode {
		Opname:   "OpAtomicIIncrement",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicIDecrement = &Opcode {
		Opname:   "OpAtomicIDecrement",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicIAdd = &Opcode {
		Opname:   "OpAtomicIAdd",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicISub = &Opcode {
		Opname:   "OpAtomicISub",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicSMin = &Opcode {
		Opname:   "OpAtomicSMin",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicUMin = &Opcode {
		Opname:   "OpAtomicUMin",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicSMax = &Opcode {
		Opname:   "OpAtomicSMax",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicUMax = &Opcode {
		Opname:   "OpAtomicUMax",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicAnd = &Opcode {
		Opname:   "OpAtomicAnd",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicOr = &Opcode {
		Opname:   "OpAtomicOr",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicXor = &Opcode {
		Opname:   "OpAtomicXor",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpPhi = &Opcode {
		Opname:   "OpPhi",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindPairIdRefIdRef,
				Name:       "'Variable, Parent, ...'",
				Quantifier: "*",
			}, 
		},
	}
	OpLoopMerge = &Opcode {
		Opname:   "OpLoopMerge",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Merge Block'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Continue Target'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLoopControl,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSelectionMerge = &Opcode {
		Opname:   "OpSelectionMerge",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Merge Block'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindSelectionControl,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpLabel = &Opcode {
		Opname:   "OpLabel",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpBranch = &Opcode {
		Opname:   "OpBranch",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Target Label'",
				Quantifier: "",
			}, 
		},
	}
	OpBranchConditional = &Opcode {
		Opname:   "OpBranchConditional",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Condition'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'True Label'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'False Label'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Branch weights'",
				Quantifier: "*",
			}, 
		},
	}
	OpSwitch = &Opcode {
		Opname:   "OpSwitch",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Selector'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Default'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindPairLiteralIntegerIdRef,
				Name:       "'Target'",
				Quantifier: "*",
			}, 
		},
	}
	OpKill = &Opcode {
		Opname:   "OpKill",
		Operands: []Operand {
		},
	}
	OpReturn = &Opcode {
		Opname:   "OpReturn",
		Operands: []Operand {
		},
	}
	OpReturnValue = &Opcode {
		Opname:   "OpReturnValue",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpUnreachable = &Opcode {
		Opname:   "OpUnreachable",
		Operands: []Operand {
		},
	}
	OpLifetimeStart = &Opcode {
		Opname:   "OpLifetimeStart",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Size'",
				Quantifier: "",
			}, 
		},
	}
	OpLifetimeStop = &Opcode {
		Opname:   "OpLifetimeStop",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Size'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupAsyncCopy = &Opcode {
		Opname:   "OpGroupAsyncCopy",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Destination'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Num Elements'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Stride'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Event'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupWaitEvents = &Opcode {
		Opname:   "OpGroupWaitEvents",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Num Events'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Events List'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupAll = &Opcode {
		Opname:   "OpGroupAll",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Predicate'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupAny = &Opcode {
		Opname:   "OpGroupAny",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Predicate'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupBroadcast = &Opcode {
		Opname:   "OpGroupBroadcast",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'LocalId'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupIAdd = &Opcode {
		Opname:   "OpGroupIAdd",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupFAdd = &Opcode {
		Opname:   "OpGroupFAdd",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupFMin = &Opcode {
		Opname:   "OpGroupFMin",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupUMin = &Opcode {
		Opname:   "OpGroupUMin",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupSMin = &Opcode {
		Opname:   "OpGroupSMin",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupFMax = &Opcode {
		Opname:   "OpGroupFMax",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupUMax = &Opcode {
		Opname:   "OpGroupUMax",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupSMax = &Opcode {
		Opname:   "OpGroupSMax",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpReadPipe = &Opcode {
		Opname:   "OpReadPipe",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpWritePipe = &Opcode {
		Opname:   "OpWritePipe",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpReservedReadPipe = &Opcode {
		Opname:   "OpReservedReadPipe",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Reserve Id'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Index'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpReservedWritePipe = &Opcode {
		Opname:   "OpReservedWritePipe",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Reserve Id'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Index'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpReserveReadPipePackets = &Opcode {
		Opname:   "OpReserveReadPipePackets",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Num Packets'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpReserveWritePipePackets = &Opcode {
		Opname:   "OpReserveWritePipePackets",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Num Packets'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpCommitReadPipe = &Opcode {
		Opname:   "OpCommitReadPipe",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Reserve Id'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpCommitWritePipe = &Opcode {
		Opname:   "OpCommitWritePipe",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Reserve Id'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpIsValidReserveId = &Opcode {
		Opname:   "OpIsValidReserveId",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Reserve Id'",
				Quantifier: "",
			}, 
		},
	}
	OpGetNumPipePackets = &Opcode {
		Opname:   "OpGetNumPipePackets",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpGetMaxPipePackets = &Opcode {
		Opname:   "OpGetMaxPipePackets",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupReserveReadPipePackets = &Opcode {
		Opname:   "OpGroupReserveReadPipePackets",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Num Packets'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupReserveWritePipePackets = &Opcode {
		Opname:   "OpGroupReserveWritePipePackets",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Num Packets'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupCommitReadPipe = &Opcode {
		Opname:   "OpGroupCommitReadPipe",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Reserve Id'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupCommitWritePipe = &Opcode {
		Opname:   "OpGroupCommitWritePipe",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Reserve Id'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpEnqueueMarker = &Opcode {
		Opname:   "OpEnqueueMarker",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Queue'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Num Events'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Wait Events'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ret Event'",
				Quantifier: "",
			}, 
		},
	}
	OpEnqueueKernel = &Opcode {
		Opname:   "OpEnqueueKernel",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Queue'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Flags'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ND Range'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Num Events'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Wait Events'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ret Event'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Invoke'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Align'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Local Size'",
				Quantifier: "*",
			}, 
		},
	}
	OpGetKernelNDrangeSubGroupCount = &Opcode {
		Opname:   "OpGetKernelNDrangeSubGroupCount",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ND Range'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Invoke'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Align'",
				Quantifier: "",
			}, 
		},
	}
	OpGetKernelNDrangeMaxSubGroupSize = &Opcode {
		Opname:   "OpGetKernelNDrangeMaxSubGroupSize",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ND Range'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Invoke'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Align'",
				Quantifier: "",
			}, 
		},
	}
	OpGetKernelWorkGroupSize = &Opcode {
		Opname:   "OpGetKernelWorkGroupSize",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Invoke'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Align'",
				Quantifier: "",
			}, 
		},
	}
	OpGetKernelPreferredWorkGroupSizeMultiple = &Opcode {
		Opname:   "OpGetKernelPreferredWorkGroupSizeMultiple",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Invoke'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Align'",
				Quantifier: "",
			}, 
		},
	}
	OpRetainEvent = &Opcode {
		Opname:   "OpRetainEvent",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Event'",
				Quantifier: "",
			}, 
		},
	}
	OpReleaseEvent = &Opcode {
		Opname:   "OpReleaseEvent",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Event'",
				Quantifier: "",
			}, 
		},
	}
	OpCreateUserEvent = &Opcode {
		Opname:   "OpCreateUserEvent",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpIsValidEvent = &Opcode {
		Opname:   "OpIsValidEvent",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Event'",
				Quantifier: "",
			}, 
		},
	}
	OpSetUserEventStatus = &Opcode {
		Opname:   "OpSetUserEventStatus",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Event'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Status'",
				Quantifier: "",
			}, 
		},
	}
	OpCaptureEventProfilingInfo = &Opcode {
		Opname:   "OpCaptureEventProfilingInfo",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Event'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Profiling Info'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpGetDefaultQueue = &Opcode {
		Opname:   "OpGetDefaultQueue",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpBuildNDRange = &Opcode {
		Opname:   "OpBuildNDRange",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'GlobalWorkSize'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'LocalWorkSize'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'GlobalWorkOffset'",
				Quantifier: "",
			}, 
		},
	}
	OpImageSparseSampleImplicitLod = &Opcode {
		Opname:   "OpImageSparseSampleImplicitLod",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageSparseSampleExplicitLod = &Opcode {
		Opname:   "OpImageSparseSampleExplicitLod",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpImageSparseSampleDrefImplicitLod = &Opcode {
		Opname:   "OpImageSparseSampleDrefImplicitLod",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'D~ref~'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageSparseSampleDrefExplicitLod = &Opcode {
		Opname:   "OpImageSparseSampleDrefExplicitLod",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'D~ref~'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpImageSparseSampleProjImplicitLod = &Opcode {
		Opname:   "OpImageSparseSampleProjImplicitLod",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageSparseSampleProjExplicitLod = &Opcode {
		Opname:   "OpImageSparseSampleProjExplicitLod",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpImageSparseSampleProjDrefImplicitLod = &Opcode {
		Opname:   "OpImageSparseSampleProjDrefImplicitLod",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'D~ref~'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageSparseSampleProjDrefExplicitLod = &Opcode {
		Opname:   "OpImageSparseSampleProjDrefExplicitLod",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'D~ref~'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpImageSparseFetch = &Opcode {
		Opname:   "OpImageSparseFetch",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageSparseGather = &Opcode {
		Opname:   "OpImageSparseGather",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Component'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageSparseDrefGather = &Opcode {
		Opname:   "OpImageSparseDrefGather",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'D~ref~'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageSparseTexelsResident = &Opcode {
		Opname:   "OpImageSparseTexelsResident",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Resident Code'",
				Quantifier: "",
			}, 
		},
	}
	OpNoLine = &Opcode {
		Opname:   "OpNoLine",
		Operands: []Operand {
		},
	}
	OpAtomicFlagTestAndSet = &Opcode {
		Opname:   "OpAtomicFlagTestAndSet",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicFlagClear = &Opcode {
		Opname:   "OpAtomicFlagClear",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
		},
	}
	OpImageSparseRead = &Opcode {
		Opname:   "OpImageSparseRead",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpSizeOf = &Opcode {
		Opname:   "OpSizeOf",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
		},
	}
	OpTypePipeStorage = &Opcode {
		Opname:   "OpTypePipeStorage",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpConstantPipeStorage = &Opcode {
		Opname:   "OpConstantPipeStorage",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Capacity'",
				Quantifier: "",
			}, 
		},
	}
	OpCreatePipeFromPipeStorage = &Opcode {
		Opname:   "OpCreatePipeFromPipeStorage",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe Storage'",
				Quantifier: "",
			}, 
		},
	}
	OpGetKernelLocalSizeForSubgroupCount = &Opcode {
		Opname:   "OpGetKernelLocalSizeForSubgroupCount",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Subgroup Count'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Invoke'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Align'",
				Quantifier: "",
			}, 
		},
	}
	OpGetKernelMaxNumSubgroups = &Opcode {
		Opname:   "OpGetKernelMaxNumSubgroups",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Invoke'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Align'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeNamedBarrier = &Opcode {
		Opname:   "OpTypeNamedBarrier",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpNamedBarrierInitialize = &Opcode {
		Opname:   "OpNamedBarrierInitialize",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Subgroup Count'",
				Quantifier: "",
			}, 
		},
	}
	OpMemoryNamedBarrier = &Opcode {
		Opname:   "OpMemoryNamedBarrier",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Named Barrier'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
		},
	}
	OpModuleProcessed = &Opcode {
		Opname:   "OpModuleProcessed",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindLiteralString,
				Name:       "'Process'",
				Quantifier: "",
			}, 
		},
	}
	OpExecutionModeId = &Opcode {
		Opname:   "OpExecutionModeId",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Entry Point'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindExecutionMode,
				Name:       "'Mode'",
				Quantifier: "",
			}, 
		},
	}
	OpDecorateId = &Opcode {
		Opname:   "OpDecorateId",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Target'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDecoration,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformElect = &Opcode {
		Opname:   "OpGroupNonUniformElect",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformAll = &Opcode {
		Opname:   "OpGroupNonUniformAll",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Predicate'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformAny = &Opcode {
		Opname:   "OpGroupNonUniformAny",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Predicate'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformAllEqual = &Opcode {
		Opname:   "OpGroupNonUniformAllEqual",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformBroadcast = &Opcode {
		Opname:   "OpGroupNonUniformBroadcast",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Id'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformBroadcastFirst = &Opcode {
		Opname:   "OpGroupNonUniformBroadcastFirst",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformBallot = &Opcode {
		Opname:   "OpGroupNonUniformBallot",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Predicate'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformInverseBallot = &Opcode {
		Opname:   "OpGroupNonUniformInverseBallot",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformBallotBitExtract = &Opcode {
		Opname:   "OpGroupNonUniformBallotBitExtract",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Index'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformBallotBitCount = &Opcode {
		Opname:   "OpGroupNonUniformBallotBitCount",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformBallotFindLSB = &Opcode {
		Opname:   "OpGroupNonUniformBallotFindLSB",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformBallotFindMSB = &Opcode {
		Opname:   "OpGroupNonUniformBallotFindMSB",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformShuffle = &Opcode {
		Opname:   "OpGroupNonUniformShuffle",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Id'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformShuffleXor = &Opcode {
		Opname:   "OpGroupNonUniformShuffleXor",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Mask'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformShuffleUp = &Opcode {
		Opname:   "OpGroupNonUniformShuffleUp",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Delta'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformShuffleDown = &Opcode {
		Opname:   "OpGroupNonUniformShuffleDown",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Delta'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformIAdd = &Opcode {
		Opname:   "OpGroupNonUniformIAdd",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformFAdd = &Opcode {
		Opname:   "OpGroupNonUniformFAdd",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformIMul = &Opcode {
		Opname:   "OpGroupNonUniformIMul",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformFMul = &Opcode {
		Opname:   "OpGroupNonUniformFMul",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformSMin = &Opcode {
		Opname:   "OpGroupNonUniformSMin",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformUMin = &Opcode {
		Opname:   "OpGroupNonUniformUMin",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformFMin = &Opcode {
		Opname:   "OpGroupNonUniformFMin",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformSMax = &Opcode {
		Opname:   "OpGroupNonUniformSMax",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformUMax = &Opcode {
		Opname:   "OpGroupNonUniformUMax",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformFMax = &Opcode {
		Opname:   "OpGroupNonUniformFMax",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformBitwiseAnd = &Opcode {
		Opname:   "OpGroupNonUniformBitwiseAnd",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformBitwiseOr = &Opcode {
		Opname:   "OpGroupNonUniformBitwiseOr",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformBitwiseXor = &Opcode {
		Opname:   "OpGroupNonUniformBitwiseXor",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformLogicalAnd = &Opcode {
		Opname:   "OpGroupNonUniformLogicalAnd",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformLogicalOr = &Opcode {
		Opname:   "OpGroupNonUniformLogicalOr",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformLogicalXor = &Opcode {
		Opname:   "OpGroupNonUniformLogicalXor",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformQuadBroadcast = &Opcode {
		Opname:   "OpGroupNonUniformQuadBroadcast",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Index'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformQuadSwap = &Opcode {
		Opname:   "OpGroupNonUniformQuadSwap",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Direction'",
				Quantifier: "",
			}, 
		},
	}
	OpCopyLogical = &Opcode {
		Opname:   "OpCopyLogical",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand'",
				Quantifier: "",
			}, 
		},
	}
	OpPtrEqual = &Opcode {
		Opname:   "OpPtrEqual",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpPtrNotEqual = &Opcode {
		Opname:   "OpPtrNotEqual",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpPtrDiff = &Opcode {
		Opname:   "OpPtrDiff",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupBallotKHR = &Opcode {
		Opname:   "OpSubgroupBallotKHR",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Predicate'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupFirstInvocationKHR = &Opcode {
		Opname:   "OpSubgroupFirstInvocationKHR",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAllKHR = &Opcode {
		Opname:   "OpSubgroupAllKHR",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Predicate'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAnyKHR = &Opcode {
		Opname:   "OpSubgroupAnyKHR",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Predicate'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAllEqualKHR = &Opcode {
		Opname:   "OpSubgroupAllEqualKHR",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Predicate'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupReadInvocationKHR = &Opcode {
		Opname:   "OpSubgroupReadInvocationKHR",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Index'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupIAddNonUniformAMD = &Opcode {
		Opname:   "OpGroupIAddNonUniformAMD",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupFAddNonUniformAMD = &Opcode {
		Opname:   "OpGroupFAddNonUniformAMD",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupFMinNonUniformAMD = &Opcode {
		Opname:   "OpGroupFMinNonUniformAMD",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupUMinNonUniformAMD = &Opcode {
		Opname:   "OpGroupUMinNonUniformAMD",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupSMinNonUniformAMD = &Opcode {
		Opname:   "OpGroupSMinNonUniformAMD",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupFMaxNonUniformAMD = &Opcode {
		Opname:   "OpGroupFMaxNonUniformAMD",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupUMaxNonUniformAMD = &Opcode {
		Opname:   "OpGroupUMaxNonUniformAMD",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupSMaxNonUniformAMD = &Opcode {
		Opname:   "OpGroupSMaxNonUniformAMD",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpFragmentMaskFetchAMD = &Opcode {
		Opname:   "OpFragmentMaskFetchAMD",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
		},
	}
	OpFragmentFetchAMD = &Opcode {
		Opname:   "OpFragmentFetchAMD",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Fragment Index'",
				Quantifier: "",
			}, 
		},
	}
	OpReadClockKHR = &Opcode {
		Opname:   "OpReadClockKHR",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
		},
	}
	OpImageSampleFootprintNV = &Opcode {
		Opname:   "OpImageSampleFootprintNV",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Granularity'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coarse'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformPartitionNV = &Opcode {
		Opname:   "OpGroupNonUniformPartitionNV",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpWritePackedPrimitiveIndices4x8NV = &Opcode {
		Opname:   "OpWritePackedPrimitiveIndices4x8NV",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Index Offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Indices'",
				Quantifier: "",
			}, 
		},
	}
	OpReportIntersectionNV = &Opcode {
		Opname:   "OpReportIntersectionNV",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Hit'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'HitKind'",
				Quantifier: "",
			}, 
		},
	}
	OpIgnoreIntersectionNV = &Opcode {
		Opname:   "OpIgnoreIntersectionNV",
		Operands: []Operand {
		},
	}
	OpTerminateRayNV = &Opcode {
		Opname:   "OpTerminateRayNV",
		Operands: []Operand {
		},
	}
	OpTraceNV = &Opcode {
		Opname:   "OpTraceNV",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Accel'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ray Flags'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Cull Mask'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'SBT Offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'SBT Stride'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Miss Index'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ray Origin'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ray Tmin'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ray Direction'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ray Tmax'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'PayloadId'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAccelerationStructureNV = &Opcode {
		Opname:   "OpTypeAccelerationStructureNV",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpExecuteCallableNV = &Opcode {
		Opname:   "OpExecuteCallableNV",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'SBT Index'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Callable DataId'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeCooperativeMatrixNV = &Opcode {
		Opname:   "OpTypeCooperativeMatrixNV",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Component Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Rows'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Columns'",
				Quantifier: "",
			}, 
		},
	}
	OpCooperativeMatrixLoadNV = &Opcode {
		Opname:   "OpCooperativeMatrixLoadNV",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Stride'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Column Major'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindMemoryAccess,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpCooperativeMatrixStoreNV = &Opcode {
		Opname:   "OpCooperativeMatrixStoreNV",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Object'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Stride'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Column Major'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindMemoryAccess,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpCooperativeMatrixMulAddNV = &Opcode {
		Opname:   "OpCooperativeMatrixMulAddNV",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'A'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'B'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'C'",
				Quantifier: "",
			}, 
		},
	}
	OpCooperativeMatrixLengthNV = &Opcode {
		Opname:   "OpCooperativeMatrixLengthNV",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Type'",
				Quantifier: "",
			}, 
		},
	}
	OpBeginInvocationInterlockEXT = &Opcode {
		Opname:   "OpBeginInvocationInterlockEXT",
		Operands: []Operand {
		},
	}
	OpEndInvocationInterlockEXT = &Opcode {
		Opname:   "OpEndInvocationInterlockEXT",
		Operands: []Operand {
		},
	}
	OpDemoteToHelperInvocationEXT = &Opcode {
		Opname:   "OpDemoteToHelperInvocationEXT",
		Operands: []Operand {
		},
	}
	OpIsHelperInvocationEXT = &Opcode {
		Opname:   "OpIsHelperInvocationEXT",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupShuffleINTEL = &Opcode {
		Opname:   "OpSubgroupShuffleINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Data'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'InvocationId'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupShuffleDownINTEL = &Opcode {
		Opname:   "OpSubgroupShuffleDownINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Current'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Next'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Delta'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupShuffleUpINTEL = &Opcode {
		Opname:   "OpSubgroupShuffleUpINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Previous'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Current'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Delta'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupShuffleXorINTEL = &Opcode {
		Opname:   "OpSubgroupShuffleXorINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Data'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupBlockReadINTEL = &Opcode {
		Opname:   "OpSubgroupBlockReadINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ptr'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupBlockWriteINTEL = &Opcode {
		Opname:   "OpSubgroupBlockWriteINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ptr'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Data'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupImageBlockReadINTEL = &Opcode {
		Opname:   "OpSubgroupImageBlockReadINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupImageBlockWriteINTEL = &Opcode {
		Opname:   "OpSubgroupImageBlockWriteINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Data'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupImageMediaBlockReadINTEL = &Opcode {
		Opname:   "OpSubgroupImageMediaBlockReadINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Width'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Height'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupImageMediaBlockWriteINTEL = &Opcode {
		Opname:   "OpSubgroupImageMediaBlockWriteINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Width'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Height'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Data'",
				Quantifier: "",
			}, 
		},
	}
	OpUCountLeadingZerosINTEL = &Opcode {
		Opname:   "OpUCountLeadingZerosINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand'",
				Quantifier: "",
			}, 
		},
	}
	OpUCountTrailingZerosINTEL = &Opcode {
		Opname:   "OpUCountTrailingZerosINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand'",
				Quantifier: "",
			}, 
		},
	}
	OpAbsISubINTEL = &Opcode {
		Opname:   "OpAbsISubINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpAbsUSubINTEL = &Opcode {
		Opname:   "OpAbsUSubINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpIAddSatINTEL = &Opcode {
		Opname:   "OpIAddSatINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpUAddSatINTEL = &Opcode {
		Opname:   "OpUAddSatINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpIAverageINTEL = &Opcode {
		Opname:   "OpIAverageINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpUAverageINTEL = &Opcode {
		Opname:   "OpUAverageINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpIAverageRoundedINTEL = &Opcode {
		Opname:   "OpIAverageRoundedINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpUAverageRoundedINTEL = &Opcode {
		Opname:   "OpUAverageRoundedINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpISubSatINTEL = &Opcode {
		Opname:   "OpISubSatINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpUSubSatINTEL = &Opcode {
		Opname:   "OpUSubSatINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpIMul32x16INTEL = &Opcode {
		Opname:   "OpIMul32x16INTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpUMul32x16INTEL = &Opcode {
		Opname:   "OpUMul32x16INTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpDecorateString = &Opcode {
		Opname:   "OpDecorateString",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Target'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDecoration,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpDecorateStringGOOGLE = &Opcode {
		Opname:   "OpDecorateStringGOOGLE",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Target'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDecoration,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpMemberDecorateString = &Opcode {
		Opname:   "OpMemberDecorateString",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Struct Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Member'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDecoration,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpMemberDecorateStringGOOGLE = &Opcode {
		Opname:   "OpMemberDecorateStringGOOGLE",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Struct Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Member'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDecoration,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpVmeImageINTEL = &Opcode {
		Opname:   "OpVmeImageINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampler'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeVmeImageINTEL = &Opcode {
		Opname:   "OpTypeVmeImageINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image Type'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcImePayloadINTEL = &Opcode {
		Opname:   "OpTypeAvcImePayloadINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcRefPayloadINTEL = &Opcode {
		Opname:   "OpTypeAvcRefPayloadINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcSicPayloadINTEL = &Opcode {
		Opname:   "OpTypeAvcSicPayloadINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcMcePayloadINTEL = &Opcode {
		Opname:   "OpTypeAvcMcePayloadINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcMceResultINTEL = &Opcode {
		Opname:   "OpTypeAvcMceResultINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcImeResultINTEL = &Opcode {
		Opname:   "OpTypeAvcImeResultINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcImeResultSingleReferenceStreamoutINTEL = &Opcode {
		Opname:   "OpTypeAvcImeResultSingleReferenceStreamoutINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcImeResultDualReferenceStreamoutINTEL = &Opcode {
		Opname:   "OpTypeAvcImeResultDualReferenceStreamoutINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcImeSingleReferenceStreaminINTEL = &Opcode {
		Opname:   "OpTypeAvcImeSingleReferenceStreaminINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcImeDualReferenceStreaminINTEL = &Opcode {
		Opname:   "OpTypeAvcImeDualReferenceStreaminINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcRefResultINTEL = &Opcode {
		Opname:   "OpTypeAvcRefResultINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcSicResultINTEL = &Opcode {
		Opname:   "OpTypeAvcSicResultINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetDefaultInterBaseMultiReferencePenaltyINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetDefaultInterBaseMultiReferencePenaltyINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Slice Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Qp'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceSetInterBaseMultiReferencePenaltyINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceSetInterBaseMultiReferencePenaltyINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Reference Base Penalty'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetDefaultInterShapePenaltyINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetDefaultInterShapePenaltyINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Slice Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Qp'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceSetInterShapePenaltyINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceSetInterShapePenaltyINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Shape Penalty'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetDefaultInterDirectionPenaltyINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetDefaultInterDirectionPenaltyINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Slice Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Qp'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceSetInterDirectionPenaltyINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceSetInterDirectionPenaltyINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Direction Cost'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetDefaultIntraLumaShapePenaltyINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetDefaultIntraLumaShapePenaltyINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Slice Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Qp'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetDefaultInterMotionVectorCostTableINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetDefaultInterMotionVectorCostTableINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Slice Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Qp'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetDefaultHighPenaltyCostTableINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetDefaultHighPenaltyCostTableINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetDefaultMediumPenaltyCostTableINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetDefaultMediumPenaltyCostTableINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetDefaultLowPenaltyCostTableINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetDefaultLowPenaltyCostTableINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceSetMotionVectorCostFunctionINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceSetMotionVectorCostFunctionINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Cost Center Delta'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Cost Table'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Cost Precision'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetDefaultIntraLumaModePenaltyINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetDefaultIntraLumaModePenaltyINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Slice Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Qp'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetDefaultNonDcLumaIntraPenaltyINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetDefaultNonDcLumaIntraPenaltyINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetDefaultIntraChromaModeBasePenaltyINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetDefaultIntraChromaModeBasePenaltyINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceSetAcOnlyHaarINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceSetAcOnlyHaarINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceSetSourceInterlacedFieldPolarityINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceSetSourceInterlacedFieldPolarityINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source Field Polarity'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceSetSingleReferenceInterlacedFieldPolarityINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceSetSingleReferenceInterlacedFieldPolarityINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Reference Field Polarity'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceSetDualReferenceInterlacedFieldPolaritiesINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceSetDualReferenceInterlacedFieldPolaritiesINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Forward Reference Field Polarity'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Backward Reference Field Polarity'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceConvertToImePayloadINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceConvertToImePayloadINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceConvertToImeResultINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceConvertToImeResultINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceConvertToRefPayloadINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceConvertToRefPayloadINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceConvertToRefResultINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceConvertToRefResultINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceConvertToSicPayloadINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceConvertToSicPayloadINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceConvertToSicResultINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceConvertToSicResultINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetMotionVectorsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetMotionVectorsINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetInterDistortionsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetInterDistortionsINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetBestInterDistortionsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetBestInterDistortionsINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetInterMajorShapeINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetInterMajorShapeINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetInterMinorShapeINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetInterMinorShapeINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetInterDirectionsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetInterDirectionsINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetInterMotionVectorCountINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetInterMotionVectorCountINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetInterReferenceIdsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetInterReferenceIdsINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetInterReferenceInterlacedFieldPolaritiesINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetInterReferenceInterlacedFieldPolaritiesINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Reference Ids'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Reference Parameter Field Polarities'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeInitializeINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeInitializeINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Coord'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Partition Mask'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'SAD Adjustment'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeSetSingleReferenceINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeSetSingleReferenceINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ref Offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Search Window Config'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeSetDualReferenceINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeSetDualReferenceINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Fwd Ref Offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Bwd Ref Offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'id> Search Window Config'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeRefWindowSizeINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeRefWindowSizeINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Search Window Config'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Dual Ref'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeAdjustRefOffsetINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeAdjustRefOffsetINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ref Offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Coord'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ref Window Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image Size'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeConvertToMcePayloadINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeConvertToMcePayloadINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeSetMaxMotionVectorCountINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeSetMaxMotionVectorCountINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Max Motion Vector Count'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeSetUnidirectionalMixDisableINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeSetUnidirectionalMixDisableINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeSetEarlySearchTerminationThresholdINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeSetEarlySearchTerminationThresholdINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Threshold'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeSetWeightedSadINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeSetWeightedSadINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Sad Weights'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeEvaluateWithSingleReferenceINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeEvaluateWithSingleReferenceINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeEvaluateWithDualReferenceINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeEvaluateWithDualReferenceINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Fwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Bwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Streamin Components'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeEvaluateWithDualReferenceStreaminINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeEvaluateWithDualReferenceStreaminINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Fwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Bwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Streamin Components'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeEvaluateWithSingleReferenceStreamoutINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeEvaluateWithSingleReferenceStreamoutINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeEvaluateWithDualReferenceStreamoutINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeEvaluateWithDualReferenceStreamoutINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Fwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Bwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminoutINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminoutINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Streamin Components'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeEvaluateWithDualReferenceStreaminoutINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeEvaluateWithDualReferenceStreaminoutINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Fwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Bwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Streamin Components'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeConvertToMceResultINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeConvertToMceResultINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetSingleReferenceStreaminINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetSingleReferenceStreaminINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetDualReferenceStreaminINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetDualReferenceStreaminINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeStripSingleReferenceStreamoutINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeStripSingleReferenceStreamoutINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeStripDualReferenceStreamoutINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeStripDualReferenceStreamoutINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeMotionVectorsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeMotionVectorsINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Major Shape'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeDistortionsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeDistortionsINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Major Shape'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeReferenceIdsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeReferenceIdsINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Major Shape'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeMotionVectorsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeMotionVectorsINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Major Shape'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Direction'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeDistortionsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeDistortionsINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Major Shape'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Direction'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeReferenceIdsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeReferenceIdsINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Major Shape'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Direction'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetBorderReachedINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetBorderReachedINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image Select'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetTruncatedSearchIndicationINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetTruncatedSearchIndicationINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetUnidirectionalEarlySearchTerminationINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetUnidirectionalEarlySearchTerminationINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetWeightingPatternMinimumMotionVectorINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetWeightingPatternMinimumMotionVectorINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetWeightingPatternMinimumDistortionINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetWeightingPatternMinimumDistortionINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcFmeInitializeINTEL = &Opcode {
		Opname:   "OpSubgroupAvcFmeInitializeINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Coord'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Motion Vectors'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Major Shapes'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Minor Shapes'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Direction'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pixel Resolution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sad Adjustment'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcBmeInitializeINTEL = &Opcode {
		Opname:   "OpSubgroupAvcBmeInitializeINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Coord'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Motion Vectors'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Major Shapes'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Minor Shapes'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Direction'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pixel Resolution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Bidirectional Weight'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sad Adjustment'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcRefConvertToMcePayloadINTEL = &Opcode {
		Opname:   "OpSubgroupAvcRefConvertToMcePayloadINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcRefSetBidirectionalMixDisableINTEL = &Opcode {
		Opname:   "OpSubgroupAvcRefSetBidirectionalMixDisableINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcRefSetBilinearFilterEnableINTEL = &Opcode {
		Opname:   "OpSubgroupAvcRefSetBilinearFilterEnableINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcRefEvaluateWithSingleReferenceINTEL = &Opcode {
		Opname:   "OpSubgroupAvcRefEvaluateWithSingleReferenceINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcRefEvaluateWithDualReferenceINTEL = &Opcode {
		Opname:   "OpSubgroupAvcRefEvaluateWithDualReferenceINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Fwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Bwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcRefEvaluateWithMultiReferenceINTEL = &Opcode {
		Opname:   "OpSubgroupAvcRefEvaluateWithMultiReferenceINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Reference Ids'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcRefEvaluateWithMultiReferenceInterlacedINTEL = &Opcode {
		Opname:   "OpSubgroupAvcRefEvaluateWithMultiReferenceInterlacedINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Reference Ids'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Reference Field Polarities'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcRefConvertToMceResultINTEL = &Opcode {
		Opname:   "OpSubgroupAvcRefConvertToMceResultINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicInitializeINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicInitializeINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Coord'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicConfigureSkcINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicConfigureSkcINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Skip Block Partition Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Skip Motion Vector Mask'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Motion Vectors'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Bidirectional Weight'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sad Adjustment'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicConfigureIpeLumaINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicConfigureIpeLumaINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Luma Intra Partition Mask'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Intra Neighbour Availabilty'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Left Edge Luma Pixels'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Upper Left Corner Luma Pixel'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Upper Edge Luma Pixels'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Upper Right Edge Luma Pixels'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sad Adjustment'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicConfigureIpeLumaChromaINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicConfigureIpeLumaChromaINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Luma Intra Partition Mask'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Intra Neighbour Availabilty'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Left Edge Luma Pixels'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Upper Left Corner Luma Pixel'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Upper Edge Luma Pixels'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Upper Right Edge Luma Pixels'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Left Edge Chroma Pixels'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Upper Left Corner Chroma Pixel'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Upper Edge Chroma Pixels'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sad Adjustment'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicGetMotionVectorMaskINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicGetMotionVectorMaskINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Skip Block Partition Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Direction'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicConvertToMcePayloadINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicConvertToMcePayloadINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicSetIntraLumaShapePenaltyINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicSetIntraLumaShapePenaltyINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Shape Penalty'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicSetIntraLumaModeCostFunctionINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicSetIntraLumaModeCostFunctionINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Luma Mode Penalty'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Luma Packed Neighbor Modes'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Luma Packed Non Dc Penalty'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicSetIntraChromaModeCostFunctionINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicSetIntraChromaModeCostFunctionINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Chroma Mode Base Penalty'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicSetBilinearFilterEnableINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicSetBilinearFilterEnableINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicSetSkcForwardTransformEnableINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicSetSkcForwardTransformEnableINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Sad Coefficients'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicSetBlockBasedRawSkipSadINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicSetBlockBasedRawSkipSadINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Block Based Skip Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicEvaluateIpeINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicEvaluateIpeINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicEvaluateWithSingleReferenceINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicEvaluateWithSingleReferenceINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicEvaluateWithDualReferenceINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicEvaluateWithDualReferenceINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Fwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Bwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicEvaluateWithMultiReferenceINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicEvaluateWithMultiReferenceINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Reference Ids'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicEvaluateWithMultiReferenceInterlacedINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicEvaluateWithMultiReferenceInterlacedINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Reference Ids'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Reference Field Polarities'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicConvertToMceResultINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicConvertToMceResultINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicGetIpeLumaShapeINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicGetIpeLumaShapeINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicGetBestIpeLumaDistortionINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicGetBestIpeLumaDistortionINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicGetBestIpeChromaDistortionINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicGetBestIpeChromaDistortionINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicGetPackedIpeLumaModesINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicGetPackedIpeLumaModesINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicGetIpeChromaModeINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicGetIpeChromaModeINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicGetPackedSkcLumaCountThresholdINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicGetPackedSkcLumaCountThresholdINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicGetPackedSkcLumaSumThresholdINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicGetPackedSkcLumaSumThresholdINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicGetInterRawSadsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicGetInterRawSadsINTEL",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}


	OperandKindImageOperands = &OperandKind {
		Kind:       "ImageOperands",
		Category:   "BitEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "None",
				Value:        0x0000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Bias",
				Value:        0x0001,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{{OperandKindIdRef, ""},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Lod",
				Value:        0x0002,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindIdRef, ""},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Grad",
				Value:        0x0004,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindIdRef, ""},{OperandKindIdRef, ""},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ConstOffset",
				Value:        0x0008,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindIdRef, ""},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Offset",
				Value:        0x0010,
				Capabilities: []string{"ImageGatherExtended",},
				Parameters:   []Parameter{{OperandKindIdRef, ""},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ConstOffsets",
				Value:        0x0020,
				Capabilities: []string{"ImageGatherExtended",},
				Parameters:   []Parameter{{OperandKindIdRef, ""},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Sample",
				Value:        0x0040,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindIdRef, ""},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "MinLod",
				Value:        0x0080,
				Capabilities: []string{"MinLod",},
				Parameters:   []Parameter{{OperandKindIdRef, ""},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "MakeTexelAvailable",
				Value:        0x0100,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{{OperandKindIdScope, ""},},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "MakeTexelAvailableKHR",
				Value:        0x0100,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{{OperandKindIdScope, ""},},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "MakeTexelVisible",
				Value:        0x0200,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{{OperandKindIdScope, ""},},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "MakeTexelVisibleKHR",
				Value:        0x0200,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{{OperandKindIdScope, ""},},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "NonPrivateTexel",
				Value:        0x0400,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "NonPrivateTexelKHR",
				Value:        0x0400,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "VolatileTexel",
				Value:        0x0800,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "VolatileTexelKHR",
				Value:        0x0800,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "SignExtend",
				Value:        0x1000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "ZeroExtend",
				Value:        0x2000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.4",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindFPFastMathMode = &OperandKind {
		Kind:       "FPFastMathMode",
		Category:   "BitEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "None",
				Value:        0x0000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NotNaN",
				Value:        0x0001,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NotInf",
				Value:        0x0002,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NSZ",
				Value:        0x0004,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "AllowRecip",
				Value:        0x0008,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Fast",
				Value:        0x0010,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindSelectionControl = &OperandKind {
		Kind:       "SelectionControl",
		Category:   "BitEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "None",
				Value:        0x0000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Flatten",
				Value:        0x0001,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DontFlatten",
				Value:        0x0002,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindLoopControl = &OperandKind {
		Kind:       "LoopControl",
		Category:   "BitEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "None",
				Value:        0x0000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Unroll",
				Value:        0x0001,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DontUnroll",
				Value:        0x0002,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DependencyInfinite",
				Value:        0x0004,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.1",
			},
			Enumerant{
				Enumerant:    "DependencyLength",
				Value:        0x0008,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralInteger, ""},},
				Version:      "1.1",
			},
			Enumerant{
				Enumerant:    "MinIterations",
				Value:        0x0010,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralInteger, ""},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "MaxIterations",
				Value:        0x0020,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralInteger, ""},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "IterationMultiple",
				Value:        0x0040,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralInteger, ""},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "PeelCount",
				Value:        0x0080,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralInteger, ""},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "PartialCount",
				Value:        0x0100,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralInteger, ""},},
				Version:      "1.4",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindFunctionControl = &OperandKind {
		Kind:       "FunctionControl",
		Category:   "BitEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "None",
				Value:        0x0000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Inline",
				Value:        0x0001,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DontInline",
				Value:        0x0002,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Pure",
				Value:        0x0004,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Const",
				Value:        0x0008,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindMemorySemantics = &OperandKind {
		Kind:       "MemorySemantics",
		Category:   "BitEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Relaxed",
				Value:        0x0000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "None",
				Value:        0x0000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Acquire",
				Value:        0x0002,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Release",
				Value:        0x0004,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "AcquireRelease",
				Value:        0x0008,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SequentiallyConsistent",
				Value:        0x0010,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UniformMemory",
				Value:        0x0040,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SubgroupMemory",
				Value:        0x0080,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "WorkgroupMemory",
				Value:        0x0100,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "CrossWorkgroupMemory",
				Value:        0x0200,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "AtomicCounterMemory",
				Value:        0x0400,
				Capabilities: []string{"AtomicStorage",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ImageMemory",
				Value:        0x0800,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "OutputMemory",
				Value:        0x1000,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "OutputMemoryKHR",
				Value:        0x1000,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "MakeAvailable",
				Value:        0x2000,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "MakeAvailableKHR",
				Value:        0x2000,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "MakeVisible",
				Value:        0x4000,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "MakeVisibleKHR",
				Value:        0x4000,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "Volatile",
				Value:        0x8000,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindMemoryAccess = &OperandKind {
		Kind:       "MemoryAccess",
		Category:   "BitEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "None",
				Value:        0x0000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Volatile",
				Value:        0x0001,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Aligned",
				Value:        0x0002,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralInteger, ""},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Nontemporal",
				Value:        0x0004,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "MakePointerAvailable",
				Value:        0x0008,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{{OperandKindIdScope, ""},},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "MakePointerAvailableKHR",
				Value:        0x0008,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{{OperandKindIdScope, ""},},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "MakePointerVisible",
				Value:        0x0010,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{{OperandKindIdScope, ""},},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "MakePointerVisibleKHR",
				Value:        0x0010,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{{OperandKindIdScope, ""},},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "NonPrivatePointer",
				Value:        0x0020,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "NonPrivatePointerKHR",
				Value:        0x0020,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindKernelProfilingInfo = &OperandKind {
		Kind:       "KernelProfilingInfo",
		Category:   "BitEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "None",
				Value:        0x0000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "CmdExecTime",
				Value:        0x0001,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindSourceLanguage = &OperandKind {
		Kind:       "SourceLanguage",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Unknown",
				Value:        0,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ESSL",
				Value:        1,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GLSL",
				Value:        2,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "OpenCL_C",
				Value:        3,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "OpenCL_CPP",
				Value:        4,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "HLSL",
				Value:        5,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindExecutionModel = &OperandKind {
		Kind:       "ExecutionModel",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Vertex",
				Value:        0,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "TessellationControl",
				Value:        1,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "TessellationEvaluation",
				Value:        2,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Geometry",
				Value:        3,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Fragment",
				Value:        4,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GLCompute",
				Value:        5,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Kernel",
				Value:        6,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "TaskNV",
				Value:        5267,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "MeshNV",
				Value:        5268,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "RayGenerationNV",
				Value:        5313,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "IntersectionNV",
				Value:        5314,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "AnyHitNV",
				Value:        5315,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ClosestHitNV",
				Value:        5316,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "MissNV",
				Value:        5317,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "CallableNV",
				Value:        5318,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindAddressingModel = &OperandKind {
		Kind:       "AddressingModel",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Logical",
				Value:        0,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Physical32",
				Value:        1,
				Capabilities: []string{"Addresses",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Physical64",
				Value:        2,
				Capabilities: []string{"Addresses",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "PhysicalStorageBuffer64",
				Value:        5348,
				Capabilities: []string{"PhysicalStorageBufferAddresses",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "PhysicalStorageBuffer64EXT",
				Value:        5348,
				Capabilities: []string{"PhysicalStorageBufferAddresses",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindMemoryModel = &OperandKind {
		Kind:       "MemoryModel",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Simple",
				Value:        0,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GLSL450",
				Value:        1,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "OpenCL",
				Value:        2,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Vulkan",
				Value:        3,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "VulkanKHR",
				Value:        3,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindExecutionMode = &OperandKind {
		Kind:       "ExecutionMode",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Invocations",
				Value:        0,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Number of <<Invocation,invocations>>'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SpacingEqual",
				Value:        1,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SpacingFractionalEven",
				Value:        2,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SpacingFractionalOdd",
				Value:        3,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "VertexOrderCw",
				Value:        4,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "VertexOrderCcw",
				Value:        5,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "PixelCenterInteger",
				Value:        6,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "OriginUpperLeft",
				Value:        7,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "OriginLowerLeft",
				Value:        8,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "EarlyFragmentTests",
				Value:        9,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "PointMode",
				Value:        10,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Xfb",
				Value:        11,
				Capabilities: []string{"TransformFeedback",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DepthReplacing",
				Value:        12,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DepthGreater",
				Value:        14,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DepthLess",
				Value:        15,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DepthUnchanged",
				Value:        16,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "LocalSize",
				Value:        17,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'x size'"},{OperandKindLiteralInteger, "'y size'"},{OperandKindLiteralInteger, "'z size'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "LocalSizeHint",
				Value:        18,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'x size'"},{OperandKindLiteralInteger, "'y size'"},{OperandKindLiteralInteger, "'z size'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "InputPoints",
				Value:        19,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "InputLines",
				Value:        20,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "InputLinesAdjacency",
				Value:        21,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Triangles",
				Value:        22,
				Capabilities: []string{"Geometry","Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "InputTrianglesAdjacency",
				Value:        23,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Quads",
				Value:        24,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Isolines",
				Value:        25,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "OutputVertices",
				Value:        26,
				Capabilities: []string{"Geometry","Tessellation","MeshShadingNV",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Vertex count'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "OutputPoints",
				Value:        27,
				Capabilities: []string{"Geometry","MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "OutputLineStrip",
				Value:        28,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "OutputTriangleStrip",
				Value:        29,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "VecTypeHint",
				Value:        30,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Vector type'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ContractionOff",
				Value:        31,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Initializer",
				Value:        33,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "1.1",
			},
			Enumerant{
				Enumerant:    "Finalizer",
				Value:        34,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "1.1",
			},
			Enumerant{
				Enumerant:    "SubgroupSize",
				Value:        35,
				Capabilities: []string{"SubgroupDispatch",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Subgroup Size'"},},
				Version:      "1.1",
			},
			Enumerant{
				Enumerant:    "SubgroupsPerWorkgroup",
				Value:        36,
				Capabilities: []string{"SubgroupDispatch",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Subgroups Per Workgroup'"},},
				Version:      "1.1",
			},
			Enumerant{
				Enumerant:    "SubgroupsPerWorkgroupId",
				Value:        37,
				Capabilities: []string{"SubgroupDispatch",},
				Parameters:   []Parameter{{OperandKindIdRef, "'Subgroups Per Workgroup'"},},
				Version:      "1.2",
			},
			Enumerant{
				Enumerant:    "LocalSizeId",
				Value:        38,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindIdRef, "'x size'"},{OperandKindIdRef, "'y size'"},{OperandKindIdRef, "'z size'"},},
				Version:      "1.2",
			},
			Enumerant{
				Enumerant:    "LocalSizeHintId",
				Value:        39,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{{OperandKindIdRef, "'Local Size Hint'"},},
				Version:      "1.2",
			},
			Enumerant{
				Enumerant:    "PostDepthCoverage",
				Value:        4446,
				Capabilities: []string{"SampleMaskPostDepthCoverage",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "DenormPreserve",
				Value:        4459,
				Capabilities: []string{"DenormPreserve",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Target Width'"},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "DenormFlushToZero",
				Value:        4460,
				Capabilities: []string{"DenormFlushToZero",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Target Width'"},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "SignedZeroInfNanPreserve",
				Value:        4461,
				Capabilities: []string{"SignedZeroInfNanPreserve",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Target Width'"},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "RoundingModeRTE",
				Value:        4462,
				Capabilities: []string{"RoundingModeRTE",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Target Width'"},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "RoundingModeRTZ",
				Value:        4463,
				Capabilities: []string{"RoundingModeRTZ",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Target Width'"},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "StencilRefReplacingEXT",
				Value:        5027,
				Capabilities: []string{"StencilExportEXT",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "OutputLinesNV",
				Value:        5269,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "OutputPrimitivesNV",
				Value:        5270,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Primitive count'"},},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "DerivativeGroupQuadsNV",
				Value:        5289,
				Capabilities: []string{"ComputeDerivativeGroupQuadsNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "DerivativeGroupLinearNV",
				Value:        5290,
				Capabilities: []string{"ComputeDerivativeGroupLinearNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "OutputTrianglesNV",
				Value:        5298,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PixelInterlockOrderedEXT",
				Value:        5366,
				Capabilities: []string{"FragmentShaderPixelInterlockEXT",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PixelInterlockUnorderedEXT",
				Value:        5367,
				Capabilities: []string{"FragmentShaderPixelInterlockEXT",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SampleInterlockOrderedEXT",
				Value:        5368,
				Capabilities: []string{"FragmentShaderSampleInterlockEXT",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SampleInterlockUnorderedEXT",
				Value:        5369,
				Capabilities: []string{"FragmentShaderSampleInterlockEXT",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ShadingRateInterlockOrderedEXT",
				Value:        5370,
				Capabilities: []string{"FragmentShaderShadingRateInterlockEXT",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ShadingRateInterlockUnorderedEXT",
				Value:        5371,
				Capabilities: []string{"FragmentShaderShadingRateInterlockEXT",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindStorageClass = &OperandKind {
		Kind:       "StorageClass",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "UniformConstant",
				Value:        0,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Input",
				Value:        1,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Uniform",
				Value:        2,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Output",
				Value:        3,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Workgroup",
				Value:        4,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "CrossWorkgroup",
				Value:        5,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Private",
				Value:        6,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Function",
				Value:        7,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Generic",
				Value:        8,
				Capabilities: []string{"GenericPointer",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "PushConstant",
				Value:        9,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "AtomicCounter",
				Value:        10,
				Capabilities: []string{"AtomicStorage",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Image",
				Value:        11,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "StorageBuffer",
				Value:        12,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "CallableDataNV",
				Value:        5328,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "IncomingCallableDataNV",
				Value:        5329,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "RayPayloadNV",
				Value:        5338,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "HitAttributeNV",
				Value:        5339,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "IncomingRayPayloadNV",
				Value:        5342,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ShaderRecordBufferNV",
				Value:        5343,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PhysicalStorageBuffer",
				Value:        5349,
				Capabilities: []string{"PhysicalStorageBufferAddresses",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "PhysicalStorageBufferEXT",
				Value:        5349,
				Capabilities: []string{"PhysicalStorageBufferAddresses",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindDim = &OperandKind {
		Kind:       "Dim",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "1D",
				Value:        0,
				Capabilities: []string{"Sampled1D","Image1D",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "2D",
				Value:        1,
				Capabilities: []string{"Shader","Kernel","ImageMSArray",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "3D",
				Value:        2,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Cube",
				Value:        3,
				Capabilities: []string{"Shader","ImageCubeArray",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rect",
				Value:        4,
				Capabilities: []string{"SampledRect","ImageRect",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Buffer",
				Value:        5,
				Capabilities: []string{"SampledBuffer","ImageBuffer",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SubpassData",
				Value:        6,
				Capabilities: []string{"InputAttachment",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindSamplerAddressingMode = &OperandKind {
		Kind:       "SamplerAddressingMode",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "None",
				Value:        0,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ClampToEdge",
				Value:        1,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Clamp",
				Value:        2,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Repeat",
				Value:        3,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RepeatMirrored",
				Value:        4,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindSamplerFilterMode = &OperandKind {
		Kind:       "SamplerFilterMode",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Nearest",
				Value:        0,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Linear",
				Value:        1,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindImageFormat = &OperandKind {
		Kind:       "ImageFormat",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Unknown",
				Value:        0,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba32f",
				Value:        1,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba16f",
				Value:        2,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R32f",
				Value:        3,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba8",
				Value:        4,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba8Snorm",
				Value:        5,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg32f",
				Value:        6,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg16f",
				Value:        7,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R11fG11fB10f",
				Value:        8,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R16f",
				Value:        9,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba16",
				Value:        10,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgb10A2",
				Value:        11,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg16",
				Value:        12,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg8",
				Value:        13,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R16",
				Value:        14,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R8",
				Value:        15,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba16Snorm",
				Value:        16,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg16Snorm",
				Value:        17,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg8Snorm",
				Value:        18,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R16Snorm",
				Value:        19,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R8Snorm",
				Value:        20,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba32i",
				Value:        21,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba16i",
				Value:        22,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba8i",
				Value:        23,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R32i",
				Value:        24,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg32i",
				Value:        25,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg16i",
				Value:        26,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg8i",
				Value:        27,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R16i",
				Value:        28,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R8i",
				Value:        29,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba32ui",
				Value:        30,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba16ui",
				Value:        31,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba8ui",
				Value:        32,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R32ui",
				Value:        33,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgb10a2ui",
				Value:        34,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg32ui",
				Value:        35,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg16ui",
				Value:        36,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg8ui",
				Value:        37,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R16ui",
				Value:        38,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R8ui",
				Value:        39,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindImageChannelOrder = &OperandKind {
		Kind:       "ImageChannelOrder",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "R",
				Value:        0,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "A",
				Value:        1,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RG",
				Value:        2,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RA",
				Value:        3,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RGB",
				Value:        4,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RGBA",
				Value:        5,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "BGRA",
				Value:        6,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ARGB",
				Value:        7,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Intensity",
				Value:        8,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Luminance",
				Value:        9,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rx",
				Value:        10,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RGx",
				Value:        11,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RGBx",
				Value:        12,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Depth",
				Value:        13,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DepthStencil",
				Value:        14,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "sRGB",
				Value:        15,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "sRGBx",
				Value:        16,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "sRGBA",
				Value:        17,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "sBGRA",
				Value:        18,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ABGR",
				Value:        19,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindImageChannelDataType = &OperandKind {
		Kind:       "ImageChannelDataType",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "SnormInt8",
				Value:        0,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SnormInt16",
				Value:        1,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UnormInt8",
				Value:        2,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UnormInt16",
				Value:        3,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UnormShort565",
				Value:        4,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UnormShort555",
				Value:        5,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UnormInt101010",
				Value:        6,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SignedInt8",
				Value:        7,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SignedInt16",
				Value:        8,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SignedInt32",
				Value:        9,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UnsignedInt8",
				Value:        10,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UnsignedInt16",
				Value:        11,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UnsignedInt32",
				Value:        12,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "HalfFloat",
				Value:        13,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Float",
				Value:        14,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UnormInt24",
				Value:        15,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UnormInt101010_2",
				Value:        16,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindFPRoundingMode = &OperandKind {
		Kind:       "FPRoundingMode",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "RTE",
				Value:        0,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RTZ",
				Value:        1,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RTP",
				Value:        2,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RTN",
				Value:        3,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindLinkageType = &OperandKind {
		Kind:       "LinkageType",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Export",
				Value:        0,
				Capabilities: []string{"Linkage",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Import",
				Value:        1,
				Capabilities: []string{"Linkage",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindAccessQualifier = &OperandKind {
		Kind:       "AccessQualifier",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "ReadOnly",
				Value:        0,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "WriteOnly",
				Value:        1,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ReadWrite",
				Value:        2,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindFunctionParameterAttribute = &OperandKind {
		Kind:       "FunctionParameterAttribute",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Zext",
				Value:        0,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Sext",
				Value:        1,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ByVal",
				Value:        2,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Sret",
				Value:        3,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NoAlias",
				Value:        4,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NoCapture",
				Value:        5,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NoWrite",
				Value:        6,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NoReadWrite",
				Value:        7,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindDecoration = &OperandKind {
		Kind:       "Decoration",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "RelaxedPrecision",
				Value:        0,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SpecId",
				Value:        1,
				Capabilities: []string{"Shader","Kernel",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Specialization Constant ID'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Block",
				Value:        2,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "BufferBlock",
				Value:        3,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RowMajor",
				Value:        4,
				Capabilities: []string{"Matrix",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ColMajor",
				Value:        5,
				Capabilities: []string{"Matrix",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ArrayStride",
				Value:        6,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Array Stride'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "MatrixStride",
				Value:        7,
				Capabilities: []string{"Matrix",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Matrix Stride'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GLSLShared",
				Value:        8,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GLSLPacked",
				Value:        9,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "CPacked",
				Value:        10,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "BuiltIn",
				Value:        11,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindBuiltIn, ""},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NoPerspective",
				Value:        13,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Flat",
				Value:        14,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Patch",
				Value:        15,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Centroid",
				Value:        16,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Sample",
				Value:        17,
				Capabilities: []string{"SampleRateShading",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Invariant",
				Value:        18,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Restrict",
				Value:        19,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Aliased",
				Value:        20,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Volatile",
				Value:        21,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Constant",
				Value:        22,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Coherent",
				Value:        23,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NonWritable",
				Value:        24,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NonReadable",
				Value:        25,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Uniform",
				Value:        26,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UniformId",
				Value:        27,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{{OperandKindIdScope, "'Execution'"},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "SaturatedConversion",
				Value:        28,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Stream",
				Value:        29,
				Capabilities: []string{"GeometryStreams",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Stream Number'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Location",
				Value:        30,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Location'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Component",
				Value:        31,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Component'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Index",
				Value:        32,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Index'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Binding",
				Value:        33,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Binding Point'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DescriptorSet",
				Value:        34,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Descriptor Set'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Offset",
				Value:        35,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Byte Offset'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "XfbBuffer",
				Value:        36,
				Capabilities: []string{"TransformFeedback",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'XFB Buffer Number'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "XfbStride",
				Value:        37,
				Capabilities: []string{"TransformFeedback",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'XFB Stride'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FuncParamAttr",
				Value:        38,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{{OperandKindFunctionParameterAttribute, "'Function Parameter Attribute'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FPRoundingMode",
				Value:        39,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindFPRoundingMode, "'Floating-Point Rounding Mode'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FPFastMathMode",
				Value:        40,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{{OperandKindFPFastMathMode, "'Fast-Math Mode'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "LinkageAttributes",
				Value:        41,
				Capabilities: []string{"Linkage",},
				Parameters:   []Parameter{{OperandKindLiteralString, "'Name'"},{OperandKindLinkageType, "'Linkage Type'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NoContraction",
				Value:        42,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "InputAttachmentIndex",
				Value:        43,
				Capabilities: []string{"InputAttachment",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Attachment Index'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Alignment",
				Value:        44,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Alignment'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "MaxByteOffset",
				Value:        45,
				Capabilities: []string{"Addresses",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Max Byte Offset'"},},
				Version:      "1.1",
			},
			Enumerant{
				Enumerant:    "AlignmentId",
				Value:        46,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{{OperandKindIdRef, "'Alignment'"},},
				Version:      "1.2",
			},
			Enumerant{
				Enumerant:    "MaxByteOffsetId",
				Value:        47,
				Capabilities: []string{"Addresses",},
				Parameters:   []Parameter{{OperandKindIdRef, "'Max Byte Offset'"},},
				Version:      "1.2",
			},
			Enumerant{
				Enumerant:    "NoSignedWrap",
				Value:        4469,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "NoUnsignedWrap",
				Value:        4470,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "ExplicitInterpAMD",
				Value:        4999,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "OverrideCoverageNV",
				Value:        5248,
				Capabilities: []string{"SampleMaskOverrideCoverageNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PassthroughNV",
				Value:        5250,
				Capabilities: []string{"GeometryShaderPassthroughNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ViewportRelativeNV",
				Value:        5252,
				Capabilities: []string{"ShaderViewportMaskNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SecondaryViewportRelativeNV",
				Value:        5256,
				Capabilities: []string{"ShaderStereoViewNV",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Offset'"},},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PerPrimitiveNV",
				Value:        5271,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PerViewNV",
				Value:        5272,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PerTaskNV",
				Value:        5273,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PerVertexNV",
				Value:        5285,
				Capabilities: []string{"FragmentBarycentricNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "NonUniform",
				Value:        5300,
				Capabilities: []string{"ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "NonUniformEXT",
				Value:        5300,
				Capabilities: []string{"ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "RestrictPointer",
				Value:        5355,
				Capabilities: []string{"PhysicalStorageBufferAddresses",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "RestrictPointerEXT",
				Value:        5355,
				Capabilities: []string{"PhysicalStorageBufferAddresses",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "AliasedPointer",
				Value:        5356,
				Capabilities: []string{"PhysicalStorageBufferAddresses",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "AliasedPointerEXT",
				Value:        5356,
				Capabilities: []string{"PhysicalStorageBufferAddresses",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "CounterBuffer",
				Value:        5634,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindIdRef, "'Counter Buffer'"},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "HlslCounterBufferGOOGLE",
				Value:        5634,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindIdRef, "'Counter Buffer'"},},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "UserSemantic",
				Value:        5635,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralString, "'Semantic'"},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "HlslSemanticGOOGLE",
				Value:        5635,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralString, "'Semantic'"},},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "UserTypeGOOGLE",
				Value:        5636,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralString, "'User Type'"},},
				Version:      "None",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindBuiltIn = &OperandKind {
		Kind:       "BuiltIn",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Position",
				Value:        0,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "PointSize",
				Value:        1,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ClipDistance",
				Value:        3,
				Capabilities: []string{"ClipDistance",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "CullDistance",
				Value:        4,
				Capabilities: []string{"CullDistance",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "VertexId",
				Value:        5,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "InstanceId",
				Value:        6,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "PrimitiveId",
				Value:        7,
				Capabilities: []string{"Geometry","Tessellation","RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "InvocationId",
				Value:        8,
				Capabilities: []string{"Geometry","Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Layer",
				Value:        9,
				Capabilities: []string{"Geometry","ShaderLayer","ShaderViewportIndexLayerEXT",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ViewportIndex",
				Value:        10,
				Capabilities: []string{"MultiViewport","ShaderViewportIndex","ShaderViewportIndexLayerEXT",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "TessLevelOuter",
				Value:        11,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "TessLevelInner",
				Value:        12,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "TessCoord",
				Value:        13,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "PatchVertices",
				Value:        14,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FragCoord",
				Value:        15,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "PointCoord",
				Value:        16,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FrontFacing",
				Value:        17,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SampleId",
				Value:        18,
				Capabilities: []string{"SampleRateShading",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SamplePosition",
				Value:        19,
				Capabilities: []string{"SampleRateShading",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SampleMask",
				Value:        20,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FragDepth",
				Value:        22,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "HelperInvocation",
				Value:        23,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NumWorkgroups",
				Value:        24,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "WorkgroupSize",
				Value:        25,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "WorkgroupId",
				Value:        26,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "LocalInvocationId",
				Value:        27,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GlobalInvocationId",
				Value:        28,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "LocalInvocationIndex",
				Value:        29,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "WorkDim",
				Value:        30,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GlobalSize",
				Value:        31,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "EnqueuedWorkgroupSize",
				Value:        32,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GlobalOffset",
				Value:        33,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GlobalLinearId",
				Value:        34,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SubgroupSize",
				Value:        36,
				Capabilities: []string{"Kernel","GroupNonUniform","SubgroupBallotKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SubgroupMaxSize",
				Value:        37,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NumSubgroups",
				Value:        38,
				Capabilities: []string{"Kernel","GroupNonUniform",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NumEnqueuedSubgroups",
				Value:        39,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SubgroupId",
				Value:        40,
				Capabilities: []string{"Kernel","GroupNonUniform",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SubgroupLocalInvocationId",
				Value:        41,
				Capabilities: []string{"Kernel","GroupNonUniform","SubgroupBallotKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "VertexIndex",
				Value:        42,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "InstanceIndex",
				Value:        43,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SubgroupEqMask",
				Value:        4416,
				Capabilities: []string{"SubgroupBallotKHR","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "SubgroupGeMask",
				Value:        4417,
				Capabilities: []string{"SubgroupBallotKHR","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "SubgroupGtMask",
				Value:        4418,
				Capabilities: []string{"SubgroupBallotKHR","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "SubgroupLeMask",
				Value:        4419,
				Capabilities: []string{"SubgroupBallotKHR","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "SubgroupLtMask",
				Value:        4420,
				Capabilities: []string{"SubgroupBallotKHR","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "SubgroupEqMaskKHR",
				Value:        4416,
				Capabilities: []string{"SubgroupBallotKHR","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "SubgroupGeMaskKHR",
				Value:        4417,
				Capabilities: []string{"SubgroupBallotKHR","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "SubgroupGtMaskKHR",
				Value:        4418,
				Capabilities: []string{"SubgroupBallotKHR","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "SubgroupLeMaskKHR",
				Value:        4419,
				Capabilities: []string{"SubgroupBallotKHR","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "SubgroupLtMaskKHR",
				Value:        4420,
				Capabilities: []string{"SubgroupBallotKHR","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "BaseVertex",
				Value:        4424,
				Capabilities: []string{"DrawParameters",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "BaseInstance",
				Value:        4425,
				Capabilities: []string{"DrawParameters",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "DrawIndex",
				Value:        4426,
				Capabilities: []string{"DrawParameters","MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "DeviceIndex",
				Value:        4438,
				Capabilities: []string{"DeviceGroup",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "ViewIndex",
				Value:        4440,
				Capabilities: []string{"MultiView",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "BaryCoordNoPerspAMD",
				Value:        4992,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "BaryCoordNoPerspCentroidAMD",
				Value:        4993,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "BaryCoordNoPerspSampleAMD",
				Value:        4994,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "BaryCoordSmoothAMD",
				Value:        4995,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "BaryCoordSmoothCentroidAMD",
				Value:        4996,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "BaryCoordSmoothSampleAMD",
				Value:        4997,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "BaryCoordPullModelAMD",
				Value:        4998,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FragStencilRefEXT",
				Value:        5014,
				Capabilities: []string{"StencilExportEXT",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ViewportMaskNV",
				Value:        5253,
				Capabilities: []string{"ShaderViewportMaskNV","MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SecondaryPositionNV",
				Value:        5257,
				Capabilities: []string{"ShaderStereoViewNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SecondaryViewportMaskNV",
				Value:        5258,
				Capabilities: []string{"ShaderStereoViewNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PositionPerViewNV",
				Value:        5261,
				Capabilities: []string{"PerViewAttributesNV","MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ViewportMaskPerViewNV",
				Value:        5262,
				Capabilities: []string{"PerViewAttributesNV","MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FullyCoveredEXT",
				Value:        5264,
				Capabilities: []string{"FragmentFullyCoveredEXT",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "TaskCountNV",
				Value:        5274,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PrimitiveCountNV",
				Value:        5275,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PrimitiveIndicesNV",
				Value:        5276,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ClipDistancePerViewNV",
				Value:        5277,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "CullDistancePerViewNV",
				Value:        5278,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "LayerPerViewNV",
				Value:        5279,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "MeshViewCountNV",
				Value:        5280,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "MeshViewIndicesNV",
				Value:        5281,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "BaryCoordNV",
				Value:        5286,
				Capabilities: []string{"FragmentBarycentricNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "BaryCoordNoPerspNV",
				Value:        5287,
				Capabilities: []string{"FragmentBarycentricNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FragSizeEXT",
				Value:        5292,
				Capabilities: []string{"FragmentDensityEXT","ShadingRateNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FragmentSizeNV",
				Value:        5292,
				Capabilities: []string{"ShadingRateNV","FragmentDensityEXT",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FragInvocationCountEXT",
				Value:        5293,
				Capabilities: []string{"FragmentDensityEXT","ShadingRateNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "InvocationsPerPixelNV",
				Value:        5293,
				Capabilities: []string{"ShadingRateNV","FragmentDensityEXT",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "LaunchIdNV",
				Value:        5319,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "LaunchSizeNV",
				Value:        5320,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "WorldRayOriginNV",
				Value:        5321,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "WorldRayDirectionNV",
				Value:        5322,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ObjectRayOriginNV",
				Value:        5323,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ObjectRayDirectionNV",
				Value:        5324,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "RayTminNV",
				Value:        5325,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "RayTmaxNV",
				Value:        5326,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "InstanceCustomIndexNV",
				Value:        5327,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ObjectToWorldNV",
				Value:        5330,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "WorldToObjectNV",
				Value:        5331,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "HitTNV",
				Value:        5332,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "HitKindNV",
				Value:        5333,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "IncomingRayFlagsNV",
				Value:        5351,
				Capabilities: []string{"RayTracingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "WarpsPerSMNV",
				Value:        5374,
				Capabilities: []string{"ShaderSMBuiltinsNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SMCountNV",
				Value:        5375,
				Capabilities: []string{"ShaderSMBuiltinsNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "WarpIDNV",
				Value:        5376,
				Capabilities: []string{"ShaderSMBuiltinsNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SMIDNV",
				Value:        5377,
				Capabilities: []string{"ShaderSMBuiltinsNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindScope = &OperandKind {
		Kind:       "Scope",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "CrossDevice",
				Value:        0,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Device",
				Value:        1,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Workgroup",
				Value:        2,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Subgroup",
				Value:        3,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Invocation",
				Value:        4,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "QueueFamily",
				Value:        5,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "QueueFamilyKHR",
				Value:        5,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindGroupOperation = &OperandKind {
		Kind:       "GroupOperation",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Reduce",
				Value:        0,
				Capabilities: []string{"Kernel","GroupNonUniformArithmetic","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "InclusiveScan",
				Value:        1,
				Capabilities: []string{"Kernel","GroupNonUniformArithmetic","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ExclusiveScan",
				Value:        2,
				Capabilities: []string{"Kernel","GroupNonUniformArithmetic","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ClusteredReduce",
				Value:        3,
				Capabilities: []string{"GroupNonUniformClustered",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "PartitionedReduceNV",
				Value:        6,
				Capabilities: []string{"GroupNonUniformPartitionedNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PartitionedInclusiveScanNV",
				Value:        7,
				Capabilities: []string{"GroupNonUniformPartitionedNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PartitionedExclusiveScanNV",
				Value:        8,
				Capabilities: []string{"GroupNonUniformPartitionedNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindKernelEnqueueFlags = &OperandKind {
		Kind:       "KernelEnqueueFlags",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "NoWait",
				Value:        0,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "WaitKernel",
				Value:        1,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "WaitWorkGroup",
				Value:        2,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindCapability = &OperandKind {
		Kind:       "Capability",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Matrix",
				Value:        0,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Shader",
				Value:        1,
				Capabilities: []string{"Matrix",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Geometry",
				Value:        2,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Tessellation",
				Value:        3,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Addresses",
				Value:        4,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Linkage",
				Value:        5,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Kernel",
				Value:        6,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Vector16",
				Value:        7,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Float16Buffer",
				Value:        8,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Float16",
				Value:        9,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Float64",
				Value:        10,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Int64",
				Value:        11,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Int64Atomics",
				Value:        12,
				Capabilities: []string{"Int64",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ImageBasic",
				Value:        13,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ImageReadWrite",
				Value:        14,
				Capabilities: []string{"ImageBasic",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ImageMipmap",
				Value:        15,
				Capabilities: []string{"ImageBasic",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Pipes",
				Value:        17,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Groups",
				Value:        18,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DeviceEnqueue",
				Value:        19,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "LiteralSampler",
				Value:        20,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "AtomicStorage",
				Value:        21,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Int16",
				Value:        22,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "TessellationPointSize",
				Value:        23,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GeometryPointSize",
				Value:        24,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ImageGatherExtended",
				Value:        25,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "StorageImageMultisample",
				Value:        27,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UniformBufferArrayDynamicIndexing",
				Value:        28,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SampledImageArrayDynamicIndexing",
				Value:        29,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "StorageBufferArrayDynamicIndexing",
				Value:        30,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "StorageImageArrayDynamicIndexing",
				Value:        31,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ClipDistance",
				Value:        32,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "CullDistance",
				Value:        33,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ImageCubeArray",
				Value:        34,
				Capabilities: []string{"SampledCubeArray",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SampleRateShading",
				Value:        35,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ImageRect",
				Value:        36,
				Capabilities: []string{"SampledRect",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SampledRect",
				Value:        37,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GenericPointer",
				Value:        38,
				Capabilities: []string{"Addresses",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Int8",
				Value:        39,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "InputAttachment",
				Value:        40,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SparseResidency",
				Value:        41,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "MinLod",
				Value:        42,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Sampled1D",
				Value:        43,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Image1D",
				Value:        44,
				Capabilities: []string{"Sampled1D",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SampledCubeArray",
				Value:        45,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SampledBuffer",
				Value:        46,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ImageBuffer",
				Value:        47,
				Capabilities: []string{"SampledBuffer",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ImageMSArray",
				Value:        48,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "StorageImageExtendedFormats",
				Value:        49,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ImageQuery",
				Value:        50,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DerivativeControl",
				Value:        51,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "InterpolationFunction",
				Value:        52,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "TransformFeedback",
				Value:        53,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GeometryStreams",
				Value:        54,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "StorageImageReadWithoutFormat",
				Value:        55,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "StorageImageWriteWithoutFormat",
				Value:        56,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "MultiViewport",
				Value:        57,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SubgroupDispatch",
				Value:        58,
				Capabilities: []string{"DeviceEnqueue",},
				Parameters:   []Parameter{},
				Version:      "1.1",
			},
			Enumerant{
				Enumerant:    "NamedBarrier",
				Value:        59,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "1.1",
			},
			Enumerant{
				Enumerant:    "PipeStorage",
				Value:        60,
				Capabilities: []string{"Pipes",},
				Parameters:   []Parameter{},
				Version:      "1.1",
			},
			Enumerant{
				Enumerant:    "GroupNonUniform",
				Value:        61,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "GroupNonUniformVote",
				Value:        62,
				Capabilities: []string{"GroupNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "GroupNonUniformArithmetic",
				Value:        63,
				Capabilities: []string{"GroupNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "GroupNonUniformBallot",
				Value:        64,
				Capabilities: []string{"GroupNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "GroupNonUniformShuffle",
				Value:        65,
				Capabilities: []string{"GroupNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "GroupNonUniformShuffleRelative",
				Value:        66,
				Capabilities: []string{"GroupNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "GroupNonUniformClustered",
				Value:        67,
				Capabilities: []string{"GroupNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "GroupNonUniformQuad",
				Value:        68,
				Capabilities: []string{"GroupNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "ShaderLayer",
				Value:        69,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "ShaderViewportIndex",
				Value:        70,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "SubgroupBallotKHR",
				Value:        4423,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "DrawParameters",
				Value:        4427,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "SubgroupVoteKHR",
				Value:        4431,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "StorageBuffer16BitAccess",
				Value:        4433,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "StorageUniformBufferBlock16",
				Value:        4433,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "UniformAndStorageBuffer16BitAccess",
				Value:        4434,
				Capabilities: []string{"StorageBuffer16BitAccess","StorageUniformBufferBlock16",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "StorageUniform16",
				Value:        4434,
				Capabilities: []string{"StorageBuffer16BitAccess","StorageUniformBufferBlock16",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "StoragePushConstant16",
				Value:        4435,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "StorageInputOutput16",
				Value:        4436,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "DeviceGroup",
				Value:        4437,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "MultiView",
				Value:        4439,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "VariablePointersStorageBuffer",
				Value:        4441,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "VariablePointers",
				Value:        4442,
				Capabilities: []string{"VariablePointersStorageBuffer",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "AtomicStorageOps",
				Value:        4445,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SampleMaskPostDepthCoverage",
				Value:        4447,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "StorageBuffer8BitAccess",
				Value:        4448,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "UniformAndStorageBuffer8BitAccess",
				Value:        4449,
				Capabilities: []string{"StorageBuffer8BitAccess",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "StoragePushConstant8",
				Value:        4450,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "DenormPreserve",
				Value:        4464,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "DenormFlushToZero",
				Value:        4465,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "SignedZeroInfNanPreserve",
				Value:        4466,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "RoundingModeRTE",
				Value:        4467,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "RoundingModeRTZ",
				Value:        4468,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "Float16ImageAMD",
				Value:        5008,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ImageGatherBiasLodAMD",
				Value:        5009,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FragmentMaskAMD",
				Value:        5010,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "StencilExportEXT",
				Value:        5013,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ImageReadWriteLodAMD",
				Value:        5015,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ShaderClockKHR",
				Value:        5055,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SampleMaskOverrideCoverageNV",
				Value:        5249,
				Capabilities: []string{"SampleRateShading",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "GeometryShaderPassthroughNV",
				Value:        5251,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ShaderViewportIndexLayerEXT",
				Value:        5254,
				Capabilities: []string{"MultiViewport",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ShaderViewportIndexLayerNV",
				Value:        5254,
				Capabilities: []string{"MultiViewport",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ShaderViewportMaskNV",
				Value:        5255,
				Capabilities: []string{"ShaderViewportIndexLayerNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ShaderStereoViewNV",
				Value:        5259,
				Capabilities: []string{"ShaderViewportMaskNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PerViewAttributesNV",
				Value:        5260,
				Capabilities: []string{"MultiView",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FragmentFullyCoveredEXT",
				Value:        5265,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "MeshShadingNV",
				Value:        5266,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ImageFootprintNV",
				Value:        5282,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FragmentBarycentricNV",
				Value:        5284,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ComputeDerivativeGroupQuadsNV",
				Value:        5288,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FragmentDensityEXT",
				Value:        5291,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ShadingRateNV",
				Value:        5291,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "GroupNonUniformPartitionedNV",
				Value:        5297,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ShaderNonUniform",
				Value:        5301,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "ShaderNonUniformEXT",
				Value:        5301,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "RuntimeDescriptorArray",
				Value:        5302,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "RuntimeDescriptorArrayEXT",
				Value:        5302,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "InputAttachmentArrayDynamicIndexing",
				Value:        5303,
				Capabilities: []string{"InputAttachment",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "InputAttachmentArrayDynamicIndexingEXT",
				Value:        5303,
				Capabilities: []string{"InputAttachment",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "UniformTexelBufferArrayDynamicIndexing",
				Value:        5304,
				Capabilities: []string{"SampledBuffer",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "UniformTexelBufferArrayDynamicIndexingEXT",
				Value:        5304,
				Capabilities: []string{"SampledBuffer",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "StorageTexelBufferArrayDynamicIndexing",
				Value:        5305,
				Capabilities: []string{"ImageBuffer",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "StorageTexelBufferArrayDynamicIndexingEXT",
				Value:        5305,
				Capabilities: []string{"ImageBuffer",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "UniformBufferArrayNonUniformIndexing",
				Value:        5306,
				Capabilities: []string{"ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "UniformBufferArrayNonUniformIndexingEXT",
				Value:        5306,
				Capabilities: []string{"ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "SampledImageArrayNonUniformIndexing",
				Value:        5307,
				Capabilities: []string{"ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "SampledImageArrayNonUniformIndexingEXT",
				Value:        5307,
				Capabilities: []string{"ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "StorageBufferArrayNonUniformIndexing",
				Value:        5308,
				Capabilities: []string{"ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "StorageBufferArrayNonUniformIndexingEXT",
				Value:        5308,
				Capabilities: []string{"ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "StorageImageArrayNonUniformIndexing",
				Value:        5309,
				Capabilities: []string{"ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "StorageImageArrayNonUniformIndexingEXT",
				Value:        5309,
				Capabilities: []string{"ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "InputAttachmentArrayNonUniformIndexing",
				Value:        5310,
				Capabilities: []string{"InputAttachment","ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "InputAttachmentArrayNonUniformIndexingEXT",
				Value:        5310,
				Capabilities: []string{"InputAttachment","ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "UniformTexelBufferArrayNonUniformIndexing",
				Value:        5311,
				Capabilities: []string{"SampledBuffer","ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "UniformTexelBufferArrayNonUniformIndexingEXT",
				Value:        5311,
				Capabilities: []string{"SampledBuffer","ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "StorageTexelBufferArrayNonUniformIndexing",
				Value:        5312,
				Capabilities: []string{"ImageBuffer","ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "StorageTexelBufferArrayNonUniformIndexingEXT",
				Value:        5312,
				Capabilities: []string{"ImageBuffer","ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "RayTracingNV",
				Value:        5340,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "VulkanMemoryModel",
				Value:        5345,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "VulkanMemoryModelKHR",
				Value:        5345,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "VulkanMemoryModelDeviceScope",
				Value:        5346,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "VulkanMemoryModelDeviceScopeKHR",
				Value:        5346,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "PhysicalStorageBufferAddresses",
				Value:        5347,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "PhysicalStorageBufferAddressesEXT",
				Value:        5347,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "ComputeDerivativeGroupLinearNV",
				Value:        5350,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "CooperativeMatrixNV",
				Value:        5357,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FragmentShaderSampleInterlockEXT",
				Value:        5363,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FragmentShaderShadingRateInterlockEXT",
				Value:        5372,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ShaderSMBuiltinsNV",
				Value:        5373,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FragmentShaderPixelInterlockEXT",
				Value:        5378,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "DemoteToHelperInvocationEXT",
				Value:        5379,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SubgroupShuffleINTEL",
				Value:        5568,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SubgroupBufferBlockIOINTEL",
				Value:        5569,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SubgroupImageBlockIOINTEL",
				Value:        5570,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SubgroupImageMediaBlockIOINTEL",
				Value:        5579,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "IntegerFunctions2INTEL",
				Value:        5584,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SubgroupAvcMotionEstimationINTEL",
				Value:        5696,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SubgroupAvcMotionEstimationIntraINTEL",
				Value:        5697,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SubgroupAvcMotionEstimationChromaINTEL",
				Value:        5698,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindIdResultType = &OperandKind {
		Kind:       "IdResultType",
		Category:   "Id",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {},
	}
	OperandKindIdResult = &OperandKind {
		Kind:       "IdResult",
		Category:   "Id",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {},
	}
	OperandKindIdMemorySemantics = &OperandKind {
		Kind:       "IdMemorySemantics",
		Category:   "Id",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {},
	}
	OperandKindIdScope = &OperandKind {
		Kind:       "IdScope",
		Category:   "Id",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {},
	}
	OperandKindIdRef = &OperandKind {
		Kind:       "IdRef",
		Category:   "Id",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {},
	}
	OperandKindLiteralInteger = &OperandKind {
		Kind:       "LiteralInteger",
		Category:   "Literal",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {},
	}
	OperandKindLiteralString = &OperandKind {
		Kind:       "LiteralString",
		Category:   "Literal",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {},
	}
	OperandKindLiteralContextDependentNumber = &OperandKind {
		Kind:       "LiteralContextDependentNumber",
		Category:   "Literal",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {},
	}
	OperandKindLiteralExtInstInteger = &OperandKind {
		Kind:       "LiteralExtInstInteger",
		Category:   "Literal",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {},
	}
	OperandKindLiteralSpecConstantOpInteger = &OperandKind {
		Kind:       "LiteralSpecConstantOpInteger",
		Category:   "Literal",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {},
	}
	OperandKindPairLiteralIntegerIdRef = &OperandKind {
		Kind:       "PairLiteralIntegerIdRef",
		Category:   "Composite",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {OperandKindLiteralInteger,OperandKindIdRef,},
	}
	OperandKindPairIdRefLiteralInteger = &OperandKind {
		Kind:       "PairIdRefLiteralInteger",
		Category:   "Composite",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {OperandKindIdRef,OperandKindLiteralInteger,},
	}
	OperandKindPairIdRefIdRef = &OperandKind {
		Kind:       "PairIdRefIdRef",
		Category:   "Composite",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {OperandKindIdRef,OperandKindIdRef,},
	}

)
