/*
 * Copyright 2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.spockframework.smoke.mock

import spock.lang.Specification

class TargetMatching extends Specification {
  Runnable runner1 = Mock()
  Runnable runner2 = Mock()

  def "match equally named collaborator" () {
    when:
      runner1.run()
    then:
      1 * runner1.run()
  }

  def "match any collaborator"() {
    when:
      runner1.run()
      runner2.run()
    then: 2 * _.run()
  }
}

