/* sqlheavy-queryable.c generated by valac 0.16.0, the Vala compiler
 * generated from sqlheavy-queryable.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include "SQLHeavy.h"
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <stdio.h>

#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))



static SQLHeavyTransaction* sql_heavy_queryable_real_begin_transaction (SQLHeavyQueryable* self, GError** error);
static GHashTable* sql_heavy_queryable_va_list_to_hash_table (va_list args, GError** error);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static GValue* _g_value_dup (GValue* self);
void sql_heavy_query_set_list (SQLHeavyQuery* self, gboolean has_first_parameter, const gchar* first_parameter, va_list args, GError** error);
static void sql_heavy_queryable_run_internal (SQLHeavyQueryable* self, const gchar* sql, gssize max_len, GError** error);
static SQLHeavyQuery* sql_heavy_queryable_real_prepare (SQLHeavyQueryable* self, const gchar* sql, GError** error);
static void sql_heavy_queryable_real_run_script (SQLHeavyQueryable* self, const gchar* filename, GError** error);
static void sql_heavy_queryable_real_print_table (SQLHeavyQueryable* self, const gchar* sql, FILE* fd, GError** error);


/**
     * Lock the queryable and refuse to run any queries against it.
     *
     * @see unlock
     */
void sql_heavy_queryable_lock (SQLHeavyQueryable* self) {
	g_return_if_fail (self != NULL);
	SQL_HEAVY_QUERYABLE_GET_INTERFACE (self)->lock (self);
}


/**
     * Unlock the queryable and allow queries to be run against it.
     *
     * @see lock
     */
void sql_heavy_queryable_unlock (SQLHeavyQueryable* self) {
	g_return_if_fail (self != NULL);
	SQL_HEAVY_QUERYABLE_GET_INTERFACE (self)->unlock (self);
}


/**
     * Queue a query to be executed when the queryable is unlocked
     *
     * @param query the query to queue
     */
void sql_heavy_queryable_queue (SQLHeavyQueryable* self, SQLHeavyQuery* query, GError** error) {
	g_return_if_fail (self != NULL);
	SQL_HEAVY_QUERYABLE_GET_INTERFACE (self)->queue (self, query, error);
}


/**
     * Begin a transaction. Will lock the queryable until the transaction is resolved.
     *
     * @return a new transaction
     */
static SQLHeavyTransaction* sql_heavy_queryable_real_begin_transaction (SQLHeavyQueryable* self, GError** error) {
	SQLHeavyTransaction* result = NULL;
	SQLHeavyTransaction* _tmp0_;
	SQLHeavyTransaction* _tmp1_;
	GError * _inner_error_ = NULL;
	_tmp0_ = sql_heavy_transaction_new (self, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp1_;
	return result;
}


SQLHeavyTransaction* sql_heavy_queryable_begin_transaction (SQLHeavyQueryable* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return SQL_HEAVY_QUERYABLE_GET_INTERFACE (self)->begin_transaction (self, error);
}


/**
     * Parse variadic arguments into a hash table
     *
     * @param args the list of arguments to parse
     */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static GHashTable* sql_heavy_queryable_va_list_to_hash_table (va_list args, GError** error) {
	GHashTable* result = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* parameters;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, __vala_GValue_free0_);
	parameters = _tmp2_;
	{
		const gchar* _tmp3_ = NULL;
		const gchar* current_parameter;
		_tmp3_ = va_arg (args, gchar*);
		current_parameter = _tmp3_;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				const gchar* _tmp7_;
				GType _tmp8_ = 0UL;
				GType gtype;
				GType _tmp9_;
				GValue _tmp10_ = {0};
				GValue gval;
				gboolean _tmp11_ = FALSE;
				GType _tmp12_;
				gboolean _tmp14_;
				GHashTable* _tmp26_;
				const gchar* _tmp27_;
				gchar* _tmp28_;
				GValue _tmp29_;
				GValue _tmp30_;
				GValue* _tmp31_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					const gchar* _tmp6_ = NULL;
					_tmp6_ = va_arg (args, gchar*);
					current_parameter = _tmp6_;
				}
				_tmp4_ = FALSE;
				_tmp7_ = current_parameter;
				if (!(_tmp7_ != NULL)) {
					break;
				}
				_tmp8_ = va_arg (args, GType);
				gtype = _tmp8_;
				_tmp9_ = gtype;
				g_value_init (&_tmp10_, _tmp9_);
				gval = _tmp10_;
				_tmp12_ = gtype;
				if (_tmp12_ == G_TYPE_INT64) {
					_tmp11_ = TRUE;
				} else {
					GType _tmp13_;
					_tmp13_ = gtype;
					_tmp11_ = _tmp13_ == G_TYPE_INT;
				}
				_tmp14_ = _tmp11_;
				if (_tmp14_) {
					gint64 _tmp15_ = 0LL;
					_tmp15_ = va_arg (args, gint64);
					g_value_set_int64 (&gval, _tmp15_);
				} else {
					GType _tmp16_;
					_tmp16_ = gtype;
					if (_tmp16_ == G_TYPE_DOUBLE) {
						gdouble _tmp17_ = 0.0;
						_tmp17_ = va_arg (args, gdouble);
						g_value_set_double (&gval, _tmp17_);
					} else {
						GType _tmp18_;
						_tmp18_ = gtype;
						if (_tmp18_ == G_TYPE_STRING) {
							const gchar* _tmp19_ = NULL;
							_tmp19_ = va_arg (args, gchar*);
							g_value_set_string (&gval, _tmp19_);
						} else {
							GType _tmp20_;
							_tmp20_ = gtype;
							if (_tmp20_ == G_TYPE_BYTE_ARRAY) {
								void* _tmp21_ = NULL;
								_tmp21_ = va_arg (args, void*);
								g_value_set_boxed (&gval, _tmp21_);
							} else {
								GType _tmp22_;
								_tmp22_ = gtype;
								if (_tmp22_ == G_TYPE_POINTER) {
									g_value_set_pointer (&gval, NULL);
								} else {
									GType _tmp23_;
									const gchar* _tmp24_ = NULL;
									GError* _tmp25_;
									_tmp23_ = gtype;
									_tmp24_ = g_type_name (_tmp23_);
									_tmp25_ = g_error_new (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_DATA_TYPE, "Data type (`%s') unsupported.", _tmp24_);
									_inner_error_ = _tmp25_;
									if (_inner_error_->domain == SQL_HEAVY_ERROR) {
										g_propagate_error (error, _inner_error_);
										G_IS_VALUE (&gval) ? (g_value_unset (&gval), NULL) : NULL;
										_g_hash_table_unref0 (parameters);
										return NULL;
									} else {
										G_IS_VALUE (&gval) ? (g_value_unset (&gval), NULL) : NULL;
										_g_hash_table_unref0 (parameters);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return NULL;
									}
								}
							}
						}
					}
				}
				_tmp26_ = parameters;
				_tmp27_ = current_parameter;
				_tmp28_ = g_strdup (_tmp27_);
				_tmp29_ = gval;
				_tmp30_ = _tmp29_;
				_tmp31_ = __g_value_dup0 (&_tmp30_);
				g_hash_table_replace (_tmp26_, _tmp28_, _tmp31_);
				G_IS_VALUE (&gval) ? (g_value_unset (&gval), NULL) : NULL;
			}
		}
	}
	result = parameters;
	return result;
}


/**
     * Execute the supplied SQL
     *
     * This function accepts an arbitrary number of groups of
     * arguments for binding values. The first argument in the group
     * must be the name of the parameter to bind, the second a GType,
     * and the third the value.
     *
     * @param sql the SQL to execute
     * @return the result
     * @see Query.execute
     */
static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


SQLHeavyQueryResult* sql_heavy_queryable_execute (SQLHeavyQueryable* self, const gchar* sql, GError** error, ...) {
	SQLHeavyQueryResult* result = NULL;
	const gchar* _tmp0_;
	const gchar* s;
	va_list args = {0};
	SQLHeavyQueryResult* _result_;
	GHashTable* parameters;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (sql != NULL, NULL);
	_tmp0_ = sql;
	s = _tmp0_;
	va_start (args, sql);
	_result_ = NULL;
	parameters = NULL;
	{
		const gchar* _tmp1_;
		gchar* sp;
		_tmp1_ = s;
		sp = (gchar*) _tmp1_;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gboolean _tmp8_ = FALSE;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gchar* _tmp4_;
					gchar* _tmp5_;
					_tmp4_ = sp;
					sp = _tmp4_ + 1;
					_tmp5_ = sp;
					s = (const gchar*) _tmp5_;
				}
				_tmp2_ = FALSE;
				_tmp6_ = sp;
				if (!((*_tmp6_) != '\0')) {
					break;
				}
				_tmp7_ = sp;
				_tmp8_ = g_ascii_isspace (*_tmp7_);
				if (!_tmp8_) {
					SQLHeavyQuery* query;
					SQLHeavyQuery* _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					gint param_count;
					SQLHeavyQuery* _tmp40_;
					SQLHeavyQueryResult* _tmp41_ = NULL;
					SQLHeavyQueryResult* _tmp42_;
					query = NULL;
					{
						SQLHeavyQueryResult* _tmp9_;
						const gchar* _tmp10_;
						SQLHeavyQuery* _tmp11_;
						SQLHeavyQuery* _tmp12_;
						const gchar* _tmp13_;
						_tmp9_ = _result_;
						if (_tmp9_ != NULL) {
							g_critical ("sqlheavy-queryable.vala:104: Executing multiple statements from Querya" \
"ble.execute is deprecated. Use Queryable.run.");
						}
						_tmp10_ = s;
						_tmp11_ = sql_heavy_query_new_full (self, (const gchar*) _tmp10_, -1, &s, &_inner_error_);
						_tmp12_ = _tmp11_;
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == SQL_HEAVY_ERROR) {
								goto __catch21_sql_heavy_error;
							}
							_g_object_unref0 (query);
							_g_hash_table_unref0 (parameters);
							_g_object_unref0 (_result_);
							va_end (args);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						_g_object_unref0 (query);
						query = _tmp12_;
						_tmp13_ = s;
						sp = ((gchar*) _tmp13_) - 1;
					}
					goto __finally21;
					__catch21_sql_heavy_error:
					{
						GError* e = NULL;
						GError* _tmp14_;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp14_ = e;
						if (g_error_matches (_tmp14_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_NO_SQL)) {
							_g_error_free0 (e);
							_g_object_unref0 (query);
							break;
						} else {
							GError* _tmp15_;
							GError* _tmp16_;
							_tmp15_ = e;
							_tmp16_ = _g_error_copy0 (_tmp15_);
							_inner_error_ = _tmp16_;
							_g_error_free0 (e);
							goto __finally21;
						}
						_g_error_free0 (e);
					}
					__finally21:
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == SQL_HEAVY_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (query);
							_g_hash_table_unref0 (parameters);
							_g_object_unref0 (_result_);
							va_end (args);
							return NULL;
						} else {
							_g_object_unref0 (query);
							_g_hash_table_unref0 (parameters);
							_g_object_unref0 (_result_);
							va_end (args);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp17_ = query;
					_tmp18_ = sql_heavy_query_get_parameter_count (_tmp17_);
					_tmp19_ = _tmp18_;
					param_count = _tmp19_;
					{
						gint p;
						p = 0;
						{
							gboolean _tmp20_;
							_tmp20_ = TRUE;
							while (TRUE) {
								gboolean _tmp21_;
								gint _tmp23_;
								gint _tmp24_;
								GHashTable* _tmp25_;
								SQLHeavyQuery* _tmp28_;
								gint _tmp29_;
								const gchar* _tmp30_ = NULL;
								const gchar* name;
								GHashTable* _tmp31_;
								const gchar* _tmp32_;
								gconstpointer _tmp33_ = NULL;
								GValue* value;
								GValue* _tmp34_;
								SQLHeavyQuery* _tmp37_;
								const gchar* _tmp38_;
								GValue* _tmp39_;
								_tmp21_ = _tmp20_;
								if (!_tmp21_) {
									gint _tmp22_;
									_tmp22_ = p;
									p = _tmp22_ + 1;
								}
								_tmp20_ = FALSE;
								_tmp23_ = p;
								_tmp24_ = param_count;
								if (!(_tmp23_ < _tmp24_)) {
									break;
								}
								_tmp25_ = parameters;
								if (_tmp25_ == NULL) {
									GHashTable* _tmp26_ = NULL;
									GHashTable* _tmp27_;
									_tmp26_ = sql_heavy_queryable_va_list_to_hash_table (args, &_inner_error_);
									_tmp27_ = _tmp26_;
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == SQL_HEAVY_ERROR) {
											g_propagate_error (error, _inner_error_);
											_g_object_unref0 (query);
											_g_hash_table_unref0 (parameters);
											_g_object_unref0 (_result_);
											va_end (args);
											return NULL;
										} else {
											_g_object_unref0 (query);
											_g_hash_table_unref0 (parameters);
											_g_object_unref0 (_result_);
											va_end (args);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return NULL;
										}
									}
									_g_hash_table_unref0 (parameters);
									parameters = _tmp27_;
								}
								_tmp28_ = query;
								_tmp29_ = p;
								_tmp30_ = sql_heavy_query_parameter_name (_tmp28_, _tmp29_ + 1, &_inner_error_);
								name = _tmp30_;
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == SQL_HEAVY_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_object_unref0 (query);
										_g_hash_table_unref0 (parameters);
										_g_object_unref0 (_result_);
										va_end (args);
										return NULL;
									} else {
										_g_object_unref0 (query);
										_g_hash_table_unref0 (parameters);
										_g_object_unref0 (_result_);
										va_end (args);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return NULL;
									}
								}
								_tmp31_ = parameters;
								_tmp32_ = name;
								_tmp33_ = g_hash_table_lookup (_tmp31_, _tmp32_);
								value = (GValue*) _tmp33_;
								_tmp34_ = value;
								if (_tmp34_ == NULL) {
									const gchar* _tmp35_;
									GError* _tmp36_;
									_tmp35_ = name;
									_tmp36_ = g_error_new (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_MISSING_PARAMETER, "Parameter `%s' left unbound", _tmp35_);
									_inner_error_ = _tmp36_;
									if (_inner_error_->domain == SQL_HEAVY_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_object_unref0 (query);
										_g_hash_table_unref0 (parameters);
										_g_object_unref0 (_result_);
										va_end (args);
										return NULL;
									} else {
										_g_object_unref0 (query);
										_g_hash_table_unref0 (parameters);
										_g_object_unref0 (_result_);
										va_end (args);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return NULL;
									}
								}
								_tmp37_ = query;
								_tmp38_ = name;
								_tmp39_ = value;
								sql_heavy_query_set (_tmp37_, _tmp38_, _tmp39_, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == SQL_HEAVY_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_object_unref0 (query);
										_g_hash_table_unref0 (parameters);
										_g_object_unref0 (_result_);
										va_end (args);
										return NULL;
									} else {
										_g_object_unref0 (query);
										_g_hash_table_unref0 (parameters);
										_g_object_unref0 (_result_);
										va_end (args);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return NULL;
									}
								}
							}
						}
					}
					_tmp40_ = query;
					_tmp41_ = sql_heavy_query_execute (_tmp40_, NULL, &_inner_error_, NULL);
					_tmp42_ = _tmp41_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == SQL_HEAVY_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (query);
							_g_hash_table_unref0 (parameters);
							_g_object_unref0 (_result_);
							va_end (args);
							return NULL;
						} else {
							_g_object_unref0 (query);
							_g_hash_table_unref0 (parameters);
							_g_object_unref0 (_result_);
							va_end (args);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_g_object_unref0 (_result_);
					_result_ = _tmp42_;
					_g_object_unref0 (query);
				}
			}
		}
	}
	result = _result_;
	_g_hash_table_unref0 (parameters);
	va_end (args);
	return result;
}


/**
     * Execute the supplied SQL, iterating through multiple statements
     * if necessary.
     *
     * This function accepts an arbitrary number of groups of
     * arguments for binding values. The first argument in the group
     * must be the name of the parameter to bind, the second a GType,
     * and the third the value.
     *
     * @param sql the SQL query to run
     * @see Query.execute
     */
void sql_heavy_queryable_run (SQLHeavyQueryable* self, const gchar* sql, GError** error, ...) {
	const gchar* _tmp0_;
	const gchar* s;
	va_list args = {0};
	GHashTable* parameters;
	SQLHeavyTransaction* _tmp1_ = NULL;
	SQLHeavyTransaction* trans;
	SQLHeavyTransaction* _tmp44_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (sql != NULL);
	_tmp0_ = sql;
	s = _tmp0_;
	va_start (args, sql);
	parameters = NULL;
	_tmp1_ = sql_heavy_queryable_begin_transaction (self, &_inner_error_);
	trans = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (parameters);
			va_end (args);
			return;
		} else {
			_g_hash_table_unref0 (parameters);
			va_end (args);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	{
		const gchar* _tmp2_;
		gchar* sp;
		_tmp2_ = s;
		sp = (gchar*) _tmp2_;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gboolean _tmp9_ = FALSE;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gchar* _tmp5_;
					gchar* _tmp6_;
					_tmp5_ = sp;
					sp = _tmp5_ + 1;
					_tmp6_ = sp;
					s = (const gchar*) _tmp6_;
				}
				_tmp3_ = FALSE;
				_tmp7_ = sp;
				if (!((*_tmp7_) != '\0')) {
					break;
				}
				_tmp8_ = sp;
				_tmp9_ = g_ascii_isspace (*_tmp8_);
				if (!_tmp9_) {
					SQLHeavyQuery* query;
					SQLHeavyQuery* _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
					gint param_count;
					SQLHeavyQuery* _tmp41_;
					SQLHeavyQueryResult* _tmp42_ = NULL;
					SQLHeavyQueryResult* _tmp43_;
					query = NULL;
					{
						SQLHeavyTransaction* _tmp10_;
						const gchar* _tmp11_;
						SQLHeavyQuery* _tmp12_;
						SQLHeavyQuery* _tmp13_;
						const gchar* _tmp14_;
						_tmp10_ = trans;
						_tmp11_ = s;
						_tmp12_ = sql_heavy_query_new_full ((SQLHeavyQueryable*) _tmp10_, (const gchar*) _tmp11_, -1, &s, &_inner_error_);
						_tmp13_ = _tmp12_;
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == SQL_HEAVY_ERROR) {
								goto __catch22_sql_heavy_error;
							}
							_g_object_unref0 (query);
							_g_object_unref0 (trans);
							_g_hash_table_unref0 (parameters);
							va_end (args);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_g_object_unref0 (query);
						query = _tmp13_;
						_tmp14_ = s;
						sp = ((gchar*) _tmp14_) - 1;
					}
					goto __finally22;
					__catch22_sql_heavy_error:
					{
						GError* e = NULL;
						GError* _tmp15_;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp15_ = e;
						if (g_error_matches (_tmp15_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_NO_SQL)) {
							_g_error_free0 (e);
							_g_object_unref0 (query);
							break;
						} else {
							GError* _tmp16_;
							GError* _tmp17_;
							_tmp16_ = e;
							_tmp17_ = _g_error_copy0 (_tmp16_);
							_inner_error_ = _tmp17_;
							_g_error_free0 (e);
							goto __finally22;
						}
						_g_error_free0 (e);
					}
					__finally22:
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == SQL_HEAVY_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (query);
							_g_object_unref0 (trans);
							_g_hash_table_unref0 (parameters);
							va_end (args);
							return;
						} else {
							_g_object_unref0 (query);
							_g_object_unref0 (trans);
							_g_hash_table_unref0 (parameters);
							va_end (args);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp18_ = query;
					_tmp19_ = sql_heavy_query_get_parameter_count (_tmp18_);
					_tmp20_ = _tmp19_;
					param_count = _tmp20_;
					{
						gint p;
						p = 0;
						{
							gboolean _tmp21_;
							_tmp21_ = TRUE;
							while (TRUE) {
								gboolean _tmp22_;
								gint _tmp24_;
								gint _tmp25_;
								GHashTable* _tmp26_;
								SQLHeavyQuery* _tmp29_;
								gint _tmp30_;
								const gchar* _tmp31_ = NULL;
								const gchar* name;
								GHashTable* _tmp32_;
								const gchar* _tmp33_;
								gconstpointer _tmp34_ = NULL;
								GValue* value;
								GValue* _tmp35_;
								SQLHeavyQuery* _tmp38_;
								const gchar* _tmp39_;
								GValue* _tmp40_;
								_tmp22_ = _tmp21_;
								if (!_tmp22_) {
									gint _tmp23_;
									_tmp23_ = p;
									p = _tmp23_ + 1;
								}
								_tmp21_ = FALSE;
								_tmp24_ = p;
								_tmp25_ = param_count;
								if (!(_tmp24_ < _tmp25_)) {
									break;
								}
								_tmp26_ = parameters;
								if (_tmp26_ == NULL) {
									GHashTable* _tmp27_ = NULL;
									GHashTable* _tmp28_;
									_tmp27_ = sql_heavy_queryable_va_list_to_hash_table (args, &_inner_error_);
									_tmp28_ = _tmp27_;
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == SQL_HEAVY_ERROR) {
											g_propagate_error (error, _inner_error_);
											_g_object_unref0 (query);
											_g_object_unref0 (trans);
											_g_hash_table_unref0 (parameters);
											va_end (args);
											return;
										} else {
											_g_object_unref0 (query);
											_g_object_unref0 (trans);
											_g_hash_table_unref0 (parameters);
											va_end (args);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
									_g_hash_table_unref0 (parameters);
									parameters = _tmp28_;
								}
								_tmp29_ = query;
								_tmp30_ = p;
								_tmp31_ = sql_heavy_query_parameter_name (_tmp29_, _tmp30_ + 1, &_inner_error_);
								name = _tmp31_;
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == SQL_HEAVY_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_object_unref0 (query);
										_g_object_unref0 (trans);
										_g_hash_table_unref0 (parameters);
										va_end (args);
										return;
									} else {
										_g_object_unref0 (query);
										_g_object_unref0 (trans);
										_g_hash_table_unref0 (parameters);
										va_end (args);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
								_tmp32_ = parameters;
								_tmp33_ = name;
								_tmp34_ = g_hash_table_lookup (_tmp32_, _tmp33_);
								value = (GValue*) _tmp34_;
								_tmp35_ = value;
								if (_tmp35_ == NULL) {
									const gchar* _tmp36_;
									GError* _tmp37_;
									_tmp36_ = name;
									_tmp37_ = g_error_new (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_MISSING_PARAMETER, "Parameter `%s' left unbound", _tmp36_);
									_inner_error_ = _tmp37_;
									if (_inner_error_->domain == SQL_HEAVY_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_object_unref0 (query);
										_g_object_unref0 (trans);
										_g_hash_table_unref0 (parameters);
										va_end (args);
										return;
									} else {
										_g_object_unref0 (query);
										_g_object_unref0 (trans);
										_g_hash_table_unref0 (parameters);
										va_end (args);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
								_tmp38_ = query;
								_tmp39_ = name;
								_tmp40_ = value;
								sql_heavy_query_set (_tmp38_, _tmp39_, _tmp40_, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == SQL_HEAVY_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_object_unref0 (query);
										_g_object_unref0 (trans);
										_g_hash_table_unref0 (parameters);
										va_end (args);
										return;
									} else {
										_g_object_unref0 (query);
										_g_object_unref0 (trans);
										_g_hash_table_unref0 (parameters);
										va_end (args);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
							}
						}
					}
					_tmp41_ = query;
					_tmp42_ = sql_heavy_query_execute (_tmp41_, NULL, &_inner_error_, NULL);
					_tmp43_ = _tmp42_;
					_g_object_unref0 (_tmp43_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == SQL_HEAVY_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (query);
							_g_object_unref0 (trans);
							_g_hash_table_unref0 (parameters);
							va_end (args);
							return;
						} else {
							_g_object_unref0 (query);
							_g_object_unref0 (trans);
							_g_hash_table_unref0 (parameters);
							va_end (args);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_g_object_unref0 (query);
				}
			}
		}
	}
	_tmp44_ = trans;
	sql_heavy_transaction_commit (_tmp44_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (trans);
			_g_hash_table_unref0 (parameters);
			va_end (args);
			return;
		} else {
			_g_object_unref0 (trans);
			_g_hash_table_unref0 (parameters);
			va_end (args);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (trans);
	_g_hash_table_unref0 (parameters);
	va_end (args);
}


/**
     * Execute the supplied insert statement
     *
     * This function accepts an arbitrary number of groups of
     * arguments for binding values. The first argument in the group
     * must be the name of the parameter to bind, the second a GType,
     * and the third the value.
     *
     * @param sql an INSERT query
     * @return the inserted row ID
     * @see execute
     * @see Query.execute_insert
     */
gint64 sql_heavy_queryable_execute_insert (SQLHeavyQueryable* self, const gchar* sql, GError** error, ...) {
	gint64 result = 0LL;
	const gchar* _tmp0_;
	SQLHeavyQuery* _tmp1_ = NULL;
	SQLHeavyQuery* query;
	va_list args = {0};
	SQLHeavyQuery* _tmp2_;
	SQLHeavyQuery* _tmp3_;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (sql != NULL, 0LL);
	_tmp0_ = sql;
	_tmp1_ = sql_heavy_queryable_prepare (self, _tmp0_, &_inner_error_);
	query = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0LL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0LL;
		}
	}
	va_start (args, sql);
	_tmp2_ = query;
	sql_heavy_query_set_list (_tmp2_, FALSE, NULL, args, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			va_end (args);
			_g_object_unref0 (query);
			return 0LL;
		} else {
			va_end (args);
			_g_object_unref0 (query);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0LL;
		}
	}
	_tmp3_ = query;
	_tmp4_ = sql_heavy_query_execute_insert (_tmp3_, NULL, &_inner_error_, NULL);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			va_end (args);
			_g_object_unref0 (query);
			return 0LL;
		} else {
			va_end (args);
			_g_object_unref0 (query);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0LL;
		}
	}
	result = _tmp5_;
	va_end (args);
	_g_object_unref0 (query);
	return result;
}


/**
     * Execute the supplied SQL, iterating through multiple statements if necessary.
     *
     * @param sql An SQL query.
     * @param max_len the maximum length of the query, or -1 to use strlen (sql)
     */
static void sql_heavy_queryable_run_internal (SQLHeavyQueryable* self, const gchar* sql, gssize max_len, GError** error) {
	const gchar* _tmp0_;
	const gchar* s;
	GError * _inner_error_ = NULL;
	g_return_if_fail (sql != NULL);
	_tmp0_ = sql;
	s = _tmp0_;
	{
		gssize _tmp1_ = 0L;
		gssize _tmp2_;
		gssize _tmp7_;
		gsize current_max;
		_tmp2_ = max_len;
		if (_tmp2_ < ((gssize) 0)) {
			const gchar* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			_tmp3_ = s;
			_tmp4_ = strlen (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp1_ = (gssize) _tmp5_;
		} else {
			gssize _tmp6_;
			_tmp6_ = max_len;
			_tmp1_ = _tmp6_;
		}
		_tmp7_ = _tmp1_;
		current_max = (gsize) _tmp7_;
		{
			gboolean _tmp8_;
			_tmp8_ = TRUE;
			while (TRUE) {
				gboolean _tmp9_;
				gboolean _tmp10_ = FALSE;
				const gchar* _tmp11_;
				gboolean _tmp13_;
				const gchar* _tmp14_;
				gchar* os;
				gsize _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp9_ = _tmp8_;
				if (!_tmp9_) {
				}
				_tmp8_ = FALSE;
				_tmp11_ = s;
				if (_tmp11_ != NULL) {
					gsize _tmp12_;
					_tmp12_ = current_max;
					_tmp10_ = _tmp12_ > ((gsize) 0);
				} else {
					_tmp10_ = FALSE;
				}
				_tmp13_ = _tmp10_;
				if (!_tmp13_) {
					break;
				}
				_tmp14_ = s;
				os = (gchar*) _tmp14_;
				{
					const gchar* _tmp15_;
					gsize _tmp16_;
					SQLHeavyQuery* _tmp17_;
					SQLHeavyQuery* _tmp18_;
					SQLHeavyQuery* _tmp19_;
					SQLHeavyQueryResult* _tmp20_ = NULL;
					SQLHeavyQueryResult* _tmp21_;
					_tmp15_ = s;
					_tmp16_ = current_max;
					_tmp17_ = sql_heavy_query_new_full (self, (const gchar*) _tmp15_, (gint) _tmp16_, &s, &_inner_error_);
					_tmp18_ = _tmp17_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == SQL_HEAVY_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp19_ = _tmp18_;
					_tmp20_ = sql_heavy_query_execute (_tmp19_, NULL, &_inner_error_, NULL);
					_tmp21_ = _tmp20_;
					_g_object_unref0 (_tmp21_);
					_g_object_unref0 (_tmp19_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == SQL_HEAVY_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
				_tmp22_ = current_max;
				_tmp23_ = s;
				_tmp24_ = os;
				current_max = _tmp22_ - (((gchar*) _tmp23_) - _tmp24_);
				{
					const gchar* _tmp25_;
					gchar* sp;
					_tmp25_ = s;
					sp = (gchar*) _tmp25_;
					{
						gboolean _tmp26_;
						_tmp26_ = TRUE;
						while (TRUE) {
							gboolean _tmp27_;
							gsize _tmp31_;
							gchar* _tmp32_;
							gboolean _tmp33_ = FALSE;
							_tmp27_ = _tmp26_;
							if (!_tmp27_) {
								gsize _tmp28_;
								gchar* _tmp29_;
								gchar* _tmp30_;
								_tmp28_ = current_max;
								current_max = _tmp28_ - 1;
								_tmp29_ = sp;
								sp = _tmp29_ + 1;
								_tmp30_ = sp;
								s = (const gchar*) _tmp30_;
							}
							_tmp26_ = FALSE;
							_tmp31_ = current_max;
							if (!(_tmp31_ > ((gsize) 0))) {
								break;
							}
							_tmp32_ = sp;
							_tmp33_ = g_ascii_isspace (*_tmp32_);
							if (!_tmp33_) {
								break;
							}
						}
					}
				}
			}
		}
	}
}


/**
     * Create a prepared statement.
     *
     * @param sql An SQL query.
     * @return a new statement
     */
static SQLHeavyQuery* sql_heavy_queryable_real_prepare (SQLHeavyQueryable* self, const gchar* sql, GError** error) {
	SQLHeavyQuery* result = NULL;
	const gchar* _tmp0_;
	SQLHeavyQuery* _tmp1_;
	SQLHeavyQuery* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (sql != NULL, NULL);
	_tmp0_ = sql;
	_tmp1_ = sql_heavy_query_new (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp2_;
	return result;
}


SQLHeavyQuery* sql_heavy_queryable_prepare (SQLHeavyQueryable* self, const gchar* sql, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return SQL_HEAVY_QUERYABLE_GET_INTERFACE (self)->prepare (self, sql, error);
}


/**
     * Runs an SQL script located in a file
     *
     * @param filename the location of the script
     */
static void sql_heavy_queryable_real_run_script (SQLHeavyQueryable* self, const gchar* filename, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (filename != NULL);
	{
		const gchar* _tmp0_;
		GMappedFile* _tmp1_;
		GMappedFile* file;
		SQLHeavyTransaction* _tmp2_ = NULL;
		SQLHeavyTransaction* trans;
		SQLHeavyTransaction* _tmp3_;
		GMappedFile* _tmp4_;
		gchar* _tmp5_ = NULL;
		GMappedFile* _tmp6_;
		gsize _tmp7_ = 0UL;
		SQLHeavyTransaction* _tmp8_;
		_tmp0_ = filename;
		_tmp1_ = g_mapped_file_new (_tmp0_, FALSE, &_inner_error_);
		file = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch23_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = sql_heavy_queryable_begin_transaction (self, &_inner_error_);
		trans = _tmp2_;
		if (_inner_error_ != NULL) {
			_g_mapped_file_unref0 (file);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch23_g_file_error;
			}
			goto __finally23;
		}
		_tmp3_ = trans;
		_tmp4_ = file;
		_tmp5_ = g_mapped_file_get_contents (_tmp4_);
		_tmp6_ = file;
		_tmp7_ = g_mapped_file_get_length (_tmp6_);
		sql_heavy_queryable_run_internal ((SQLHeavyQueryable*) _tmp3_, (const gchar*) _tmp5_, (gssize) _tmp7_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (trans);
			_g_mapped_file_unref0 (file);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch23_g_file_error;
			}
			goto __finally23;
		}
		_tmp8_ = trans;
		sql_heavy_transaction_commit (_tmp8_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (trans);
			_g_mapped_file_unref0 (file);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch23_g_file_error;
			}
			goto __finally23;
		}
		_g_object_unref0 (trans);
		_g_mapped_file_unref0 (file);
	}
	goto __finally23;
	__catch23_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		GError* _tmp11_;
		gint _tmp12_;
		GError* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->code;
		_tmp13_ = g_error_new (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_IO, "Unable to open script: %s (%d).", _tmp10_, _tmp12_);
		_inner_error_ = _tmp13_;
		_g_error_free0 (e);
		goto __finally23;
	}
	__finally23:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void sql_heavy_queryable_run_script (SQLHeavyQueryable* self, const gchar* filename, GError** error) {
	g_return_if_fail (self != NULL);
	SQL_HEAVY_QUERYABLE_GET_INTERFACE (self)->run_script (self, filename, error);
}


/**
     * Print the result set to a file stream
     *
     * @param sql the query
     * @param fd the stream to print to
     * @see Queryable.print_table
     */
static void sql_heavy_queryable_real_print_table (SQLHeavyQueryable* self, const gchar* sql, FILE* fd, GError** error) {
	const gchar* _tmp0_;
	SQLHeavyQuery* _tmp1_ = NULL;
	SQLHeavyQuery* _tmp2_;
	SQLHeavyQuery* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (sql != NULL);
	_tmp0_ = sql;
	_tmp1_ = sql_heavy_queryable_prepare (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = _tmp2_;
	sql_heavy_query_print_table (_tmp3_, NULL, &_inner_error_);
	_g_object_unref0 (_tmp3_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void sql_heavy_queryable_print_table (SQLHeavyQueryable* self, const gchar* sql, FILE* fd, GError** error) {
	g_return_if_fail (self != NULL);
	SQL_HEAVY_QUERYABLE_GET_INTERFACE (self)->print_table (self, sql, fd, error);
}


SQLHeavyDatabase* sql_heavy_queryable_get_database (SQLHeavyQueryable* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return SQL_HEAVY_QUERYABLE_GET_INTERFACE (self)->get_database (self);
}


static void sql_heavy_queryable_base_init (SQLHeavyQueryableIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		     * Database
		     */
		g_object_interface_install_property (iface, g_param_spec_object ("database", "database", "database", SQL_HEAVY_TYPE_DATABASE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		     * Signal which is emitted when a query finished executing.
		     *
		     * @param query the query which was executed
		     * @see Database.sql_executed
		     */
		g_signal_new ("query_executed", SQL_HEAVY_TYPE_QUERYABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SQL_HEAVY_TYPE_QUERY);
		iface->begin_transaction = sql_heavy_queryable_real_begin_transaction;
		iface->prepare = sql_heavy_queryable_real_prepare;
		iface->run_script = sql_heavy_queryable_real_run_script;
		iface->print_table = sql_heavy_queryable_real_print_table;
	}
}


/**
   * Interface on which queries may be run
   */
GType sql_heavy_queryable_get_type (void) {
	static volatile gsize sql_heavy_queryable_type_id__volatile = 0;
	if (g_once_init_enter (&sql_heavy_queryable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SQLHeavyQueryableIface), (GBaseInitFunc) sql_heavy_queryable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType sql_heavy_queryable_type_id;
		sql_heavy_queryable_type_id = g_type_register_static (G_TYPE_INTERFACE, "SQLHeavyQueryable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (sql_heavy_queryable_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&sql_heavy_queryable_type_id__volatile, sql_heavy_queryable_type_id);
	}
	return sql_heavy_queryable_type_id__volatile;
}



