/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf.util;

import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogUtil {
    private LogUtil() {
    }

    public static void setVerbosity(int n) {
        int n2 = Level.INFO.intValue() - n * 100;
        Level level = Level.parse(Integer.toString(n2));
        Logger logger = Logger.getLogger("");
        logger.setLevel(level);
        Handler[] handlerArray = logger.getHandlers();
        if (handlerArray.length > 0 && handlerArray[0] instanceof ConsoleHandler) {
            handlerArray[0].setLevel(level);
            handlerArray[0].setFormatter(new LineFormatter(false));
        }
        for (int i = 0; i < handlerArray.length; ++i) {
            handlerArray[i].setLevel(level);
        }
    }

    public static class LineFormatter
    extends Formatter {
        private final boolean debug_;

        public LineFormatter(boolean bl) {
            this.debug_ = bl;
        }

        public String format(LogRecord logRecord) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(logRecord.getLevel().toString()).append(": ").append(this.formatMessage(logRecord));
            if (this.debug_) {
                stringBuffer.append(' ').append('(').append(logRecord.getSourceClassName()).append('.').append(logRecord.getSourceMethodName()).append(')');
            }
            stringBuffer.append('\n');
            return stringBuffer.toString();
        }
    }
}

