use ui;
use core:geometry;
use core:io;
use graphics;
use core:debug;
use lang:bs:macro;

Url resUrl() {
	if (u = (named{res}).url) {
		return u;
	} else {
		return Url();
	}
}

class MainPainter extends Painter {
	SolidBrush brush;
	SolidBrush brush2;
	SolidBrush yellow;
	LinearGradient brush3;
	BitmapBrush brush4;
	Moment started;
	Bitmap bitmap;
	Text text;
	Path star;

	init() {
		Url f = resUrl / "ui_alpha.png";
		Image img = graphics:loadImage(f);
		Image tree = graphics:loadImage(resUrl / "tree-32.bmp");

		Font font = defaultFont;
		font.height(font.height * 3);

		init() {
			brush(red);
			brush2(blue);
			brush3([GradientStop(0, red), GradientStop(1, green)], Point(0, 0), Point(100, 100));
			brush4(Bitmap(tree), scale(0.2) * translate(Point(-40, -40)));
			yellow(yellow);
			bitmap(img);
			text("Hello World!", font);
		}

		Int edges = 5;
		Int stops = edges * 2;
		for (Int i = 0; i < stops; i++) {
			Angle a = 360 deg / stops.float;
			a *= i.float;

			Point p = angle(a) * 20.0;
			if (i % 2 == 0)
				p *= 2.0;
			star.point(p);
		}
		star.close();
	}

	// Share resources from another painter.
	init(MainPainter other) {
		init() {
			brush = other.brush;
			brush2 = other.brush2;
			yellow = other.yellow;
			brush3 = other.brush3;
			brush4 = other.brush4;
			started = other.started;
			bitmap = other.bitmap;
			text = other.text;
			star = other.star;
		}
	}

	Bool render(Size size, Graphics g) {
		Point from(0, 0);
		Point to(size.w, size.h);
		Point center = size / 2;
		Size border(10);
		Moment now;
		Float time = (now - started) / 30 ms;

		var angle3 = time * 3 deg;
		brush3.points(angle3.angle * 200 + center, angle3.angle * -200 + center);

		g.line(from, to, brush);
		g.line(Point(0, size.h), Point(size.w, 0), brush2);
		g.fillOval(Rect(from + border, to - border), brush3);

		Float y = time;
		g.push();
		g.transform(rotate(y * 5 deg, center));

		g.line(Point(0, y), Point(size.w, y), brush);

		g.push();
		g.transform(translate(Point(y, y)));

		g.push();
		g.transform(rotate(45 deg));
		g.draw(bitmap);
		g.pop();

		g.push();
		g.transform(skewX(10 deg));
		g.draw(text, brush2, from);
		g.pop();

		g.pop();
		g.pop();

		g.push();
		g.transform(rotate(y * 4 deg) * translate(Point(100, 100)));
		g.lineWidth(5);
		g.fill(star, yellow);

		g.transform(rotate(y * 4 deg) * translate(Point(300, 300)));
		g.fillOval(Rect(-40, -40, 40, 40), brush4);

		true;
	}
}

class PaintWin extends Frame {
	init() {
		init("Graphics!") {}
		size(Size(400, 400));
		painter(MainPainter());

		create();
	}

	Bool onClick(Bool pressed, Point at, MouseButton button) {
		FilePicker p = FilePicker:open(FileTypes("test"));
		p.show(this);
	}
}

class MultiPaintWin extends Frame {
	init() {
		init("Multi graphics") {}
		size(Size(400.0 * 2 + 8.0 * 3, 400.0 + 8.0 * 2));

		MainPainter p;
		Window p1;
		p1.pos = Rect(8, 8, 408, 408);
		p1.painter(p);
		add(p1);

		Window p2;
		p2.pos = Rect(416, 8, 816, 408);
		p2.painter(MainPainter(p));
		add(p2);

		create();
	}
}

class MainWin extends Frame {
	Label lbl;
	Edit input;
	Button btn;

	init() {
		init("Test window") {
			lbl("Name:");
			input("Your name");
			btn("Click me!");
		}
		size(Size(200, 200));

		add(lbl);

		input.onReturn = &this.enterPressed(Edit);
		add(input);

		btn.onClick = &this.btnClicked(Button);
		add(btn);

		create();
	}

	void resized(Size s) {
		Size border = 8;
		Point w = border;
		Size sz = s - 2*border;

		lbl.pos(Rect(w, Size(sz.w, 20)));
		w.y = w.y + 28;
		sz.h = sz.h - 28;

		input.pos(Rect(w, Size(sz.w, 20)));
		w.y = w.y + 28;
		sz.h = sz.h - 28;

		btn.pos(Rect(w, Size(sz.w, 20)));
	}

	void btnClicked(Button btn) {
		btn.text("Well done: " + input.text);
	}

	void enterPressed(Edit edit) {
		btn.text("Well edited: " + input.text);
	}
}

void closeLater(Frame w) {
	sleep(6 s);
	w.close;
}

void main() {
	print("Opening main window...");
	// MainWin win;
	PaintWin win;
	spawn closeLater(win);
	win.waitForClose;
}

void multi() {
	MultiPaintWin win;
	spawn closeLater(win);
	win.waitForClose;
}

void redoMain() {
	main();
	sleep(1 s);
	main();
}
