// Global integer.
Int globalInt on Compiler;

// Global string, initialized to "hello"
Str globalStr on Compiler = "Hello";

// Make sure we can initialize variables with functions declared later in the same file.
Str globalInit on Compiler = initGlobal("A");

// Make sure we can handle value types properly.
core:debug:DbgNoToS globalValue on Compiler;

Int testGlobal(Int v) on Compiler {
	Int old = globalInt;
	globalInt = v;
	old;
}

Str testGlobal(Str v) on Compiler {
	Str old = globalStr;
	globalStr = v;
	old;
}

core:debug:DbgNoToS testGlobal(core:debug:DbgNoToS v) on Compiler {
	var old = globalValue;
	globalValue = v;
	old;
}

// Global on another thread.
Str threadStr on Other = "Other";

Str getOther() on Other {
	threadStr;
}

Str threadGlobal() {
	getOther();
}

Str failThreadGlobal() {
	// Should not work.
	threadStr;
}

Str initGlobal(Str v) {
	"Global: " + v;
}

Str getInitGlobal() on Compiler {
	globalInit;
}

