/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.sql.SQLException;
import org.apache.derby.impl.drda.FdocaConstants;

class SQLTypes {
    private SQLTypes() {
    }

    protected static int mapDB2SqlTypeToJdbcType(int n, long l, int n2) {
        switch (SQLTypes.getNonNullableSqlType(n)) {
            case 500: {
                return 5;
            }
            case 496: {
                return 4;
            }
            case 492: {
                return -5;
            }
            case 480: {
                if (l == 16L) {
                    return 3;
                }
                if (l == 8L) {
                    return 8;
                }
                if (l == 4L) {
                    return 7;
                }
                return 0;
            }
            case 484: 
            case 488: 
            case 504: {
                return 3;
            }
            case 452: {
                if (n2 == 65535 || n2 == 0) {
                    return -2;
                }
                return 1;
            }
            case 460: 
            case 468: {
                return 1;
            }
            case 448: 
            case 464: {
                if (n2 == 65535 || n2 == 0) {
                    return -3;
                }
                return 12;
            }
            case 476: {
                return 12;
            }
            case 456: 
            case 472: {
                if (n2 == 65535 || n2 == 0) {
                    return -4;
                }
                return -1;
            }
            case 384: {
                return 91;
            }
            case 388: {
                return 92;
            }
            case 392: {
                return 93;
            }
            case 408: 
            case 412: {
                return 2005;
            }
            case 404: 
            case 960: 
            case 964: 
            case 968: {
                return 2004;
            }
        }
        return 0;
    }

    protected static int mapJdbcTypeToDB2SqlType(int n, boolean bl, int[] nArray) throws SQLException {
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        FdocaConstants.mapJdbcTypeToDrdaType(n, bl, nArray);
        switch (n) {
            case -7: 
            case -6: 
            case 5: 
            case 16: {
                return 500 + n2;
            }
            case 4: {
                return 496 + n2;
            }
            case -5: {
                return 492 + n2;
            }
            case 7: 
            case 8: {
                return 480 + n2;
            }
            case 2: 
            case 3: {
                return 484 + n2;
            }
            case 91: {
                return 384 + n2;
            }
            case 92: {
                return 388 + n2;
            }
            case 93: {
                return 392 + n2;
            }
            case 1: {
                return 452 + n2;
            }
            case -2: {
                return 452 + n2;
            }
            case -3: 
            case 12: {
                return 448 + n2;
            }
            case -4: {
                return 456 + n2;
            }
            case 2000: {
                return 456 + n2;
            }
            case 2004: {
                return 404 + n2;
            }
            case 2005: {
                return 408 + n2;
            }
            case -1: {
                return 456 + n2;
            }
            case 0: 
            case 1111: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: {
                throw new SQLException("Jdbc type" + n + "not Supported yet");
            }
        }
        throw new SQLException("unrecognized sql type: " + n);
    }

    protected static int getNonNullableSqlType(int n) {
        return n & 0xFFFFFFFE;
    }
}

