"""
Defines a set of prepasses to cleanup a given header for FFI-npapi generation
"""

_PASSES = []

def _add_pass(p):
    _PASSES.append(p)


# pre-passes definitions

def _cleanup_comments(content):
    """
    cleanup C/C++ style comments
    bad usage of regexp but works for our simplified context
    """
    import re
    return re.sub (r"/\*.*?\*/|//[^\n]*", '', content, flags=re.DOTALL)

def _cleanup_pp_statements(content):
    """
    cleanup of preprocessor statements
    again assume some structure in the input string, very simplistic
    """
    import re
    directive_re = re.compile("^\s*#.*$")
    return "\n".join ([line for line in content.split('\n') if not directive_re.match(line)])

_add_pass (_cleanup_comments)
_add_pass (_cleanup_pp_statements)


def run_prepasses(content):
    for pas in _PASSES:
        content = pas(content)
    return content





