SYNCLIB_SRC_PATH = $(SYNCLIB_PATH)/src
SYNCLIB_SRCS=$(SYNCLIB_SRC_PATH)/EventLinux.cpp \
$(SYNCLIB_SRC_PATH)/RWLock.cpp \
$(SYNCLIB_SRC_PATH)/SemaphoreLinux.cpp \
$(SYNCLIB_SRC_PATH)/ThreadLinux.cpp

SYNCLIB_INC_PATH = $(SYNCLIB_PATH)/Include
SYNCLIB_HDRS=$(SYNCLIB_INC_PATH)/Event.h \
$(SYNCLIB_INC_PATH)/Lock.h \
$(SYNCLIB_INC_PATH)/RWLock.h \
$(SYNCLIB_INC_PATH)/Semaphore.h \
$(SYNCLIB_INC_PATH)/SPtr.h \
$(SYNCLIB_INC_PATH)/Thread.h


AMTSTATUS_SRCS=$(AMT_STATUS_PATH)/AMTStatusThread.cpp \
$(AMT_STATUS_PATH)/IPCAMTStatus.cpp \
$(AMT_STATUS_PATH)/IPCBufferLinux.cpp \
$(AMT_HECI_PATH)/HECILinux.cpp \
$(AMT_HECI_PATH)/PTHICommand.cpp

AMTSTATUS_HDRS=$(AMT_STATUS_PATH)/AMTStatusThread.h \
$(AMT_STATUS_PATH)/IPCAMTStatus.h \
$(AMT_STATUS_PATH)/IPCBuffer.h \
$(AMT_HECI_PATH)/AMTVersn.h \
$(AMT_HECI_PATH)/heci.h \
$(AMT_HECI_PATH)/HECI_if.h \
$(AMT_HECI_PATH)/HECILinux.h \
$(AMT_HECI_PATH)/PTHICommand.h \
$(AMT_STATUS_PATH)/heci/StatusStrings/StatusCodeDefinitions.h


SOAP_GENERATED_SRCS=\
$(GSOAP_GCODE)/soapC.cpp \
$(GSOAP_GCODE)/soapServer.cpp

SOAP_GENERATED_HDRS=$(GSOAP_GCODE)/soapEventManagerClientSoapBindingObject.h \
$(GSOAP_GCODE)/soapH.h \
$(GSOAP_GCODE)/SoapInterfaceTmp.h \
$(GSOAP_GCODE)/soapStub.h \
$(GSOAP_GCODE)/cmn.nsmap \
$(GSOAP_GCODE)/emi.nsmap \
$(GSOAP_GCODE)/EventManagerClientSoapBinding.nsmap \
$(GSOAP_GCODE)/sai.nsmap \
$(GSOAP_GCODE)/SoapBinding.nsmap

SOAP_PLUGIN_SRCS=\
$(GSOAP_PLUGINS)/httpda.c \
$(GSOAP_PLUGINS)/md5evp.c

SOAP_PLUGIN_HDRS=\
$(GSOAP_PLUGINS)/httpda.h \
$(GSOAP_PLUGINS)/md5evp.h \
$(GSOAP_PLUGINS)/threads.h

SOAP_SRCS=$(GSOAP_PATH)/SoapBinding.cpp \
$(SOAP_GENERATED_SRCS) \
$(SOAP_PLUGIN_SRCS)

SOAP_HDRS=$(GSOAP_PATH)/SoapBinding.h \
$(SOAP_GENERATED_HDRS) \
$(SOAP_PLUGIN_HDRS)


NOTIFTHREAD_SRCS=AMTPPSharedData.cpp \
BaseWSManClient.cpp \
ConfigFile.cpp \
ConfigLinuxInfo.cpp \
Credentials.cpp \
CryptUtils.cpp \
EACWSManClient.cpp \
EventMessages.cpp \
LinuxEventLog.cpp \
LinuxRegistry.cpp \
Options.cpp \
PeriodicActionThread.cpp \
PostureRetrievalThread.cpp \
UNSCommonDefs.cpp \
UNSConfig.cpp \
UNSEventLogger.cpp \
UNSSoapServer.cpp \
UNSWSManClient.cpp \
UserNotificationServiceLinux.cpp \
UserNotificationThread.cpp

NOTIFTHREAD_HDRS=AMTPPDefs.h \
AMTPPSharedData.h \
BaseEventLog.h \
BaseWSManClient.h \
ConfigFile.h \
ConfigLinuxInfo.h \
ConfigOSInfo.h \
Credentials.h \
CryptUtils.h \
EACWSManClient.h \
EventMessages.h \
LinuxEventLog.h \
LinuxRegistryInfo.h \
Options.h \
PeriodicActionThread.h \
PostureRetrievalThread.h \
registryWrapper.h \
UNSCommonDefs.h \
UNSConfig.h \
UNSEventLogger.h \
UNSMessageFileLinux.h \
UNSSoapServer.h \
UNSStatus.h \
UNSWSManClient.h \
UserNotificationServiceLinux.h \
UserNotificationThread.h


WSMAN_SRCS = $(WSMAN_PATH)/Src/CimClass.cpp
WSMAN_SRCS += $(WSMAN_PATH)/Src/Deserializable.cpp
WSMAN_SRCS += $(WSMAN_PATH)/Src/EndpointReference.cpp
WSMAN_SRCS += $(WSMAN_PATH)/Src/Serializable.cpp
WSMAN_SRCS += $(WSMAN_PATH)/Src/XMLTypes.cpp
WSMAN_SRCS += $(WSMAN_PATH)/Src/XMLUtils_XRCS.cpp
WSMAN_SRCS += $(WSMANMCPP_PATH)/Src/AMT_EndpointAccessControlService.cpp  
WSMAN_SRCS += $(WSMANMCPP_PATH)/Src/AMT_SOAPEventSubscriber.cpp 
WSMAN_SRCS += $(WSMANMCPP_PATH)/Src/AMT_EventSubscriber.cpp
WSMAN_SRCS += $(WSMANMCPP_PATH)/Src/CIM_RemotePort.cpp
WSMAN_SRCS += $(WSMANMCPP_PATH)/Src/CIM_RemoteServiceAccessPoint.cpp
WSMAN_SRCS += $(WSMANMCPP_PATH)/Src/CIM_ServiceAccessPoint.cpp
WSMAN_SRCS += $(WSMANMCPP_PATH)/Src/CIM_EnabledLogicalElement.cpp
WSMAN_SRCS += $(WSMANMCPP_PATH)/Src/CIM_LogicalElement.cpp
WSMAN_SRCS += $(WSMANMCPP_PATH)/Src/CIM_ManagedSystemElement.cpp
WSMAN_SRCS += $(WSMANMCPP_PATH)/Src/CIM_ManagedElement.cpp
WSMAN_SRCS += $(WSMANMCPP_PATH)/Src/CIM_Service.cpp

WSMAN_HDRS = $(WSMAN_PATH)/Include/CimClass.h
WSMAN_HDRS += $(WSMAN_PATH)/Include/Deserializable.h
WSMAN_HDRS += $(WSMAN_PATH)/Include/EndpointReference.h
WSMAN_HDRS += $(WSMAN_PATH)/Include/Serializable.h
WSMAN_HDRS += $(WSMAN_PATH)/Include/XMLTypes.h
WSMAN_HDRS += $(WSMAN_PATH)/Include/XMLUtils.h
WSMAN_HDRS += $(WSMANMCPP_PATH)/Include/AMT_EndpointAccessControlService.h
WSMAN_HDRS += $(WSMANMCPP_PATH)/Include/AMT_EventSubscriber.h
WSMAN_HDRS += $(WSMANMCPP_PATH)/Include/AMT_SOAPEventSubscriber.h
WSMAN_HDRS += $(WSMANMCPP_PATH)/Include/CIM_EnabledLogicalElement.h
WSMAN_HDRS += $(WSMANMCPP_PATH)/Include/CIM_LogicalElement.h
WSMAN_HDRS += $(WSMANMCPP_PATH)/Include/CIM_ManagedElement.h
WSMAN_HDRS += $(WSMANMCPP_PATH)/Include/CIM_ManagedSystemElement.h
WSMAN_HDRS += $(WSMANMCPP_PATH)/Include/CIM_RemotePort.h
WSMAN_HDRS += $(WSMANMCPP_PATH)/Include/CIM_RemoteServiceAccessPoint.h
WSMAN_HDRS += $(WSMANMCPP_PATH)/Include/CIM_ServiceAccessPoint.h
WSMAN_HDRS += $(WSMANMCPP_PATH)/Include/CIM_Service.h


uns_SOURCES=UNSMainLinux.cpp \
$(NOTIFTHREAD_SRCS) \
$(WSMAN_SRCS) \
$(AMTSTATUS_SRCS) \
$(SOAP_SRCS)

noinst_HEADERS=\
$(NOTIFTHREAD_HDRS) \
$(WSMAN_HDRS) \
$(AMTSTATUS_HDRS) \
$(SOAP_HDRS)

dist_noinst_SCRIPTS=mc.pl

dist_noinst_DATA=UNSMessageFile.mc
