
#ifndef _HOSTFILETONED_H_
#define _HOSTFILETONED_H_

VPB_DETECT toned_dial = {
	2,			// number of cadence states
	0,		// tone id
	1,			// number of tones
	400,			// freq1
	100,			// bandwidth1
	0,			// freq2, N/A
	0,			// bandwidth2, N/A
	-40,			// level1
	0,			// level2, N/A
	0,			// twist, N/A
	10,			// SNR
	40,			// glitchs of 40ms ignored

	
	{
		{
			RISING,
			0,
			0,
			0
		},
	
		{
			TIMER,			// state 1
			2000,                   // 2s to avoid mix-up with US
			0,                      // US ringback
			0
		}
	}
};

// Aust. Ringback
VPB_DETECT toned_ringback_aust = {
	4,		  // number of cadence states
	1, // tone id
	1,		// number of tones
	425,		// freq1
	100,		// bandwidth1
	0,		// freq2, N/A
	0,	        // bandwidth2, N/A
	-20,		// level1
	0,		// level2, N/A
	0,		// twist, N/A
	10,		// SNR
	40,		// glitchs of 40ms ignored
	
	{
		{
			VPB_RISING,	// state 0			
			0,
			0,
			0
		},

		{
			VPB_FALLING,	// state 1			
			0,
			360,		// ton min		
			440		// ton max		
		},
		{
			VPB_RISING,	// state 2			
			0,
			180,
			220
		},

		{
			VPB_FALLING,	// state 3			
			0,
			360,		// ton min		
			440		// ton max		
		}
	}
};

// Studio 308 ringback

// VPB_TONE1=RINGBACK,P2,400,150,1000,1000
VPB_DETECT toned_ringback_308 = {
	2,		  // number of cadence states
	2, // tone id
	1,		// number of tones
	400,		// freq1
	100,		// bandwidth1
	0,		// freq2, N/A
	0,	        // bandwidth2, N/A
	-20,		// level1
	0,		// level2, N/A
	0,		// twist, N/A
	10,		// SNR
	40,		// glitchs of 40ms ignored
	
	{
		{
			VPB_RISING,	// state 0			
			0,
			0,
			0
		},

		{
			VPB_FALLING,	// state 1			
			0,
			900,		// ton min		
			1100		// ton max		
		}
	}
};

// message describing state transitions for Studio 308 busy 

VPB_DETECT toned_busy_308 = {
	3,		// number of states		
	3,	// tone id
	1,		// number of tones		
	425,		// f1:  centre frequency	
	100,		// bw1: bandwidth		
	0,		// f2: N/A			
	0,		// bw2: N/A			
	-20,		// A1: -10 dbm0			
	0,		// A2: N/A 			
	0,		// twist: N/A			
	10,		// SNR: 10dB			
	40,		// glitchs of 40ms ignored

	{
		{
			VPB_RISING,	// state 0			
			0,
			0,
			0
		},

		{
			VPB_FALLING,	// state 1			
			0,
			450,		// 450ms ton min		
			550		// 550ms ton max		
		},

		{
			VPB_RISING,	// state 2			
			0,
			450,		// 450ms toff min		
			550		// 550ms toff max		
		}
	}
};

// message describing state transitions for Australian Busy/Disconnect

VPB_DETECT toned_busy_aust = {
	3,		 // number of states		
	4,   // tone id
	1,		 // number of tones		
	425,		 // f1:  centre frequency	
	100,		 // bw1: bandwidth		
	0,		 // f2: N/A			
	0,		 // bw2: N/A			
	-40,		 // A1: 			
	0,		 // A2: N/A 			
	0,		 // twist: N/A			
	10,		 // SNR: 10dB			
	40,		 // glitchs of 40ms ignored

	{
		{
			VPB_RISING,	 // state 0			
			0,
			0,
			0
		},

		{
			VPB_FALLING,	 // state 1			
			0,
			300,					
			450
		},					

		{
			VPB_RISING,	 // state 2			
			0,
			300,					
			450
		},					
	}
};

// grunt detector, looks for wide band energy between 500 and 3000 Hz
// we want it to reliably fire on speech, but not typical call
// progress tones that are below 500Hz.

VPB_DETECT toned_grunt = {
	3,			// number of states		
	5,		// tone id
	1,			// number of tones		
	2000,			// f1:  centre frequency	
	3000,			// bw1: bandwidth		
	0,			// f2: N/A			
	0,			// bw2: N/A			
	-40,			// A1: dbM0		
	0,			// A2: N/A 			
	0,			// twist: N/A			
	0,			// SNR: 10dB			
	40,			// glitchs of 40ms ignored

	{
		
		{
			VPB_DELAY,		// state 0		
			100,
			0,
			0
		},
		
		{
			VPB_RISING,		// state 1
			0,
			0,
			0
		},
		
		{
			VPB_TIMER,	       // state 2
			50,
			0,
			0
		}
	}

};

// US PSTN ringback

VPB_DETECT toned_ringback_us = {
	2,		// number of cadence states
	6,	// tone id
	1,		// number of tones
	425,		// freq1
	200,		// bandwidth1
	0,		// freq2, N/A
	0,	        // bandwidth2, N/A
	-20,		// level1
	0,		// level2, N/A
	0,		// twist, N/A
	10,		// SNR
	40,		// glitchs of 40ms ignored
	
	{
		{
			VPB_RISING,	// state 0			
			0,
			0,
			0
		},

		{
			VPB_FALLING,	// state 1			
			0,
			1600,		// ton min		
			2400		// ton max		
		}
	}
};

// US busy tone

VPB_DETECT toned_busy_us = {
	3,		 // number of states		
	7,        // tone id
	2,		 // number of tones		
	480,		 // f1:  centre frequency	
	100,		 // bw1: bandwidth		
	620,		 // f2: N/A			
	100,		 // bw2: N/A			
	-20,		 // A1: -10 dbm0			
	-20,		 // A2: N/A 			
	10,		 // twist: N/A			
	10,		 // SNR: 10dB			
	40,		 // glitchs of 40ms ignored

	{
		{
			VPB_RISING,	 // state 0			
			0,
			0,
			0
		},

		{
			VPB_FALLING,	 // state 1			
			0,
			450,					
			550
		},					

		{
			VPB_RISING,	 // state 2			
			0,
			450,					
			550
		},					
	}
};

// Tone detector params describing Fax CNG/preamble

VPB_DETECT toned_fax = {
	2,			// number of cadence states
	8,		// tone id
	1,			// number of tones
	1100,			// freq1
	400,			// bandwidth1
	0,			// freq2, N/A
	0,			// bandwidth2, N/A
	-40,			// level1
	0,			// level2, N/A
	0,			// twist, N/A
	10,			// SNR
	40,			// glitchs of 40ms ignored

	
	{
		{
			VPB_RISING,	 // state 0			
			0,
			0,
			0
		},

		{
			VPB_FALLING,	 // state 1			
			0,
			450,					
			550
		}					
			
	}

};

VPB_DETECT user_tone = {
        3,      // number of cadence states
        9,      // tone id ******** RENAME THIS, eg VPB_DIAL or VPB_BUSY etc *********
        1,      // number of tones
        406,    // freq1
        100,    // bandwidth1
        0,      // freq2
        100,    // bandwidth2
        -22,    // level1
        -20,    // level2
        10,     // twist
        10,     // SNR
        100,     // glitch duration in ms
        {
                // Cadence 0
                {1,     // VPB_TIMER, VPB_RISING, or VPB_FALLING
                0,      // timer mode only
                0,      // minimum tone on/off time (non timer) in ms
                0},     // maximum tone on/off time (non timer) in ms
                // Cadence 1
                {2,     // VPB_TIMER, VPB_RISING, or VPB_FALLING
                0,      // timer mode only
                940,    // minimum tone on/off time (non timer) in ms
                1040},  // maximum tone on/off time (non timer) in ms
                // Cadence 2
                {1,     // VPB_TIMER, VPB_RISING, or VPB_FALLING
                0,      // timer mode only
                1930,   // minimum tone on/off time (non timer) in ms
                2030},  // maximum tone on/off time (non timer) in ms
        }
};
#endif
