/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.BitSet;
import java.util.Date;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.AtomDataServer;
import org.jmol.atomdata.RadiusData;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeDataReader;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

abstract class AtomDataReader
extends VolumeDataReader {
    protected AtomDataServer atomDataServer;
    protected String fileName;
    protected String fileDotModel;
    protected int modelIndex;
    protected AtomData atomData = new AtomData();
    protected Point3f[] atomXyz;
    protected float[] atomRadius;
    protected float[] atomProp;
    protected int[] atomNo;
    protected int[] atomIndex;
    protected int[] myIndex;
    protected int atomCount;
    protected int myAtomCount;
    protected int nearbyAtomCount;
    protected int firstNearbyAtom;
    protected BitSet bsMySelected;
    protected BitSet bsMyIgnored;
    protected boolean doAddHydrogens;
    protected boolean doUsePlane;
    protected boolean doUseIterator;

    AtomDataReader(SurfaceGenerator surfaceGenerator) {
        super(surfaceGenerator);
        this.precalculateVoxelData = true;
        this.atomDataServer = surfaceGenerator.getAtomDataServer();
    }

    protected void setup() {
        this.params.iUseBitSets = true;
        this.doAddHydrogens = this.atomDataServer != null && this.params.addHydrogens;
        this.modelIndex = this.params.modelIndex;
        this.bsMySelected = new BitSet();
        this.bsMyIgnored = this.params.bsIgnore == null ? new BitSet() : this.params.bsIgnore;
        boolean bl = this.doUsePlane = this.params.thePlane != null;
        if (this.doUsePlane) {
            this.volumeData.setPlaneParameters(this.params.thePlane);
        }
    }

    protected void getAtoms(float f, boolean bl, boolean bl2) {
        int n;
        int n2;
        if (this.params.atomRadiusData == null) {
            this.params.atomRadiusData = new RadiusData(1.0f, 2, 8);
        }
        this.atomData.radiusData = this.params.atomRadiusData;
        if (this.doAddHydrogens) {
            this.atomData.radiusData.vdwType = 7;
        }
        this.atomData.modelIndex = this.modelIndex;
        this.atomData.bsSelected = this.doUseIterator ? null : this.params.bsSelected;
        this.atomData.bsIgnored = this.bsMyIgnored;
        this.atomDataServer.fillAtomData(this.atomData, 2);
        this.atomCount = this.atomData.atomCount;
        this.modelIndex = this.atomData.firstModelIndex;
        int n3 = 0;
        boolean bl3 = false;
        for (int i = 0; i < this.atomCount; ++i) {
            if ((this.params.bsSelected == null || this.params.bsSelected.get(i)) && !this.bsMyIgnored.get(i)) {
                if (this.doUsePlane) {
                    float f2;
                    this.atomData.atomRadius[i] = this.getWorkingRadius(i, f);
                    if (Math.abs(this.volumeData.distancePointToPlane(this.atomData.atomXyz[i])) > 2.0f * f2) continue;
                }
                this.bsMySelected.set(i);
                ++n3;
                boolean bl4 = bl3 = !this.doUsePlane;
            }
            if (!bl2 && !bl3) continue;
            this.atomData.atomRadius[i] = this.getWorkingRadius(i, f);
        }
        float f3 = this.doAddHydrogens ? this.getWorkingRadius(-1, f) : 0.0f;
        this.myAtomCount = BitSetUtil.cardinalityOf(this.bsMySelected);
        BitSet bitSet = BitSetUtil.copy(this.bsMySelected);
        int n4 = 0;
        this.atomProp = null;
        if (this.myAtomCount > 0) {
            int n5;
            int n6;
            Point3f[] point3fArray = null;
            if (this.doAddHydrogens) {
                this.atomData.bsSelected = bitSet;
                this.atomDataServer.fillAtomData(this.atomData, 3);
                n4 = this.atomData.hydrogenAtomCount;
                point3fArray = new Point3f[n4];
                for (n6 = 0; n6 < this.atomData.hAtoms.length; ++n6) {
                    if (this.atomData.hAtoms[n6] == null) continue;
                    n5 = this.atomData.hAtoms[n6].length;
                    while (--n5 >= 0) {
                        point3fArray[--n4] = this.atomData.hAtoms[n6][n5];
                    }
                }
                n4 = point3fArray.length;
                Logger.info(n4 + " attached hydrogens added");
            }
            n6 = n4 + this.myAtomCount;
            this.atomRadius = new float[n6];
            this.atomXyz = new Point3f[n6];
            if (this.params.theProperty != null) {
                this.atomProp = new float[n6];
            }
            this.atomNo = new int[n6];
            if (this.doUseIterator) {
                this.atomIndex = new int[n6];
                this.myIndex = new int[this.atomCount];
            }
            for (n5 = 0; n5 < n4; ++n5) {
                this.atomRadius[n5] = f3;
                this.atomXyz[n5] = point3fArray[n5];
                this.atomNo[n5] = -1;
                if (this.atomProp == null) continue;
                this.atomProp[n5] = Float.NaN;
            }
            this.myAtomCount = n4;
            float[] fArray = this.params.theProperty;
            n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                if (this.atomProp != null) {
                    this.atomProp[this.myAtomCount] = fArray != null && n2 < fArray.length ? fArray[n2] : Float.NaN;
                }
                this.atomXyz[this.myAtomCount] = this.atomData.atomXyz[n2];
                this.atomNo[this.myAtomCount] = this.atomData.atomicNumber[n2];
                if (this.doUseIterator) {
                    this.atomIndex[this.myAtomCount] = n2;
                    this.myIndex[n2] = this.myAtomCount;
                }
                this.atomRadius[this.myAtomCount++] = this.atomData.atomRadius[n2];
                n2 = bitSet.nextSetBit(n2 + 1);
            }
        }
        this.firstNearbyAtom = this.myAtomCount;
        Logger.info(this.myAtomCount + " atoms will be used in the surface calculation");
        for (int i = 0; i < this.myAtomCount; ++i) {
            this.setBoundingBox(this.atomXyz[i], this.atomRadius[i]);
        }
        if (!Float.isNaN(this.params.scale)) {
            Vector3f vector3f = new Vector3f(this.xyzMax);
            vector3f.sub(this.xyzMin);
            vector3f.scale(0.5f);
            this.xyzMin.add(vector3f);
            vector3f.scale(this.params.scale);
            this.xyzMax.set(this.xyzMin);
            this.xyzMax.add(vector3f);
            this.xyzMin.sub(vector3f);
        }
        if (!bl2) {
            return;
        }
        Point3f point3f = new Point3f();
        BitSet bitSet2 = new BitSet();
        for (n = 0; n < this.atomCount; ++n) {
            if (bitSet.get(n) || this.bsMyIgnored.get(n)) continue;
            float f4 = this.atomData.atomRadius[n];
            if (this.params.thePlane != null && Math.abs(this.volumeData.distancePointToPlane(this.atomData.atomXyz[n])) > 2.0f * f4) continue;
            point3f = this.atomData.atomXyz[n];
            if (!(point3f.x + f4 > this.xyzMin.x) || !(point3f.x - f4 < this.xyzMax.x) || !(point3f.y + f4 > this.xyzMin.y) || !(point3f.y - f4 < this.xyzMax.y) || !(point3f.z + f4 > this.xyzMin.z) || !(point3f.z - f4 < this.xyzMax.z)) continue;
            bitSet2.set(n);
            ++this.nearbyAtomCount;
        }
        n = this.myAtomCount;
        if (this.nearbyAtomCount != 0) {
            this.atomRadius = ArrayUtil.setLength(this.atomRadius, n += this.nearbyAtomCount);
            this.atomXyz = (Point3f[])ArrayUtil.setLength(this.atomXyz, n);
            n2 = bitSet2.nextSetBit(0);
            while (n2 >= 0) {
                this.atomXyz[this.myAtomCount] = this.atomData.atomXyz[n2];
                this.atomRadius[this.myAtomCount++] = this.atomData.atomRadius[n2];
                n2 = bitSet2.nextSetBit(n2 + 1);
            }
        }
    }

    private float getWorkingRadius(int n, float f) {
        float f2;
        float f3 = f2 = n < 0 ? this.atomData.hAtomRadius : this.atomData.atomRadius[n];
        if (!Float.isNaN(f)) {
            return f2 + f;
        }
        switch (this.params.atomRadiusData.type) {
            case 0: {
                f2 = this.params.atomRadiusData.value;
                break;
            }
            case 1: {
                f2 += this.params.atomRadiusData.value;
                break;
            }
            case 2: {
                f2 *= this.params.atomRadiusData.value;
            }
        }
        f2 += this.params.solventExtendedAtomRadius;
        if ((double)f2 < 0.1) {
            f2 = 0.1f;
        }
        return f2;
    }

    protected void setHeader(String string, String string2) {
        this.jvxlFileHeaderBuffer = new StringBuffer();
        if (this.atomData.programInfo != null) {
            this.jvxlFileHeaderBuffer.append("#created by ").append(this.atomData.programInfo).append(" on ").append(new Date()).append("\n");
        }
        this.jvxlFileHeaderBuffer.append(string).append("\n").append(string2).append("\n");
    }

    protected void setRangesAndAddAtoms(float f, int n, int n2) {
        if (this.xyzMin == null) {
            return;
        }
        this.setVoxelRange(0, this.xyzMin.x, this.xyzMax.x, f, n);
        this.setVoxelRange(1, this.xyzMin.y, this.xyzMax.y, f, n);
        this.setVoxelRange(2, this.xyzMin.z, this.xyzMax.z, f, n);
        JvxlCoder.jvxlCreateHeader(this.volumeData, n2, this.atomXyz, this.atomNo, this.jvxlFileHeaderBuffer);
    }

    protected boolean fixTitleLine(int n) {
        if (this.params.title == null) {
            return false;
        }
        String string = this.params.title[n];
        if (string.indexOf("%F") > 0) {
            string = this.params.title[n] = TextFormat.formatString(string, "F", this.atomData.fileName);
        }
        if (string.indexOf("%M") > 0) {
            this.params.title[n] = TextFormat.formatString(string, "M", this.atomData.modelName);
        }
        return true;
    }
}

