\name{simulations.plot}
\alias{simulations.plot}
\title{Plot Quantities of Interest in a Zelig-fashion}
\usage{
  simulations.plot(y, y1=NULL, xlab="", ylab="", main="",
    col=NULL, line.col=NULL, axisnames=TRUE)
}
\arguments{
  \item{y}{A matrix or vector of simulated results
  generated by Zelig, to be graphed.}

  \item{y1}{For comparison of two sets of simulated results
  at different choices of covariates, this should be an
  object of the same type and dimension as y.  If no
  comparison is to be made, this should be NULL.}

  \item{xlab}{Label for the x-axis.}

  \item{ylab}{Label for the y-axis.}

  \item{main}{Main plot title.}

  \item{col}{A vector of colors.  Colors will be used in
  turn as the graph is built for main plot objects. For
  nominal/categorical data, this colors renders as the bar
  color, while for numeric data it renders as the
  background color.}

  \item{line.col}{A vector of colors.  Colors will be used
  in turn as the graph is built for line color shading of
  plot objects.}

  \item{axisnames}{a character-vector, specifying the names
  of the axes}
}
\value{
  nothing
}
\description{
  Various graph generation for different common types of
  simulated results from Zelig
}
\author{
  James Honaker
}

