/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.Communicator;
import Ice.Identity;
import Ice.InitializationData;
import Ice.MarshalException;
import Ice.ObjectPrx;
import Ice.Properties;
import Ice.ProtocolException;
import Ice.StringSeqHolder;
import IceInternal.Instance;
import IceInternal.Network;
import IceUtil.UUID;

public final class Util {
    private static String _localAddress = null;

    public static Properties createProperties() {
        return new Properties();
    }

    public static Properties createProperties(StringSeqHolder stringSeqHolder) {
        return new Properties(stringSeqHolder, null);
    }

    public static Properties createProperties(StringSeqHolder stringSeqHolder, Properties properties) {
        return new Properties(stringSeqHolder, properties);
    }

    public static Properties createProperties(String[] stringArray) {
        StringSeqHolder stringSeqHolder = new StringSeqHolder(stringArray);
        return Util.createProperties(stringSeqHolder);
    }

    public static Properties createProperties(String[] stringArray, Properties properties) {
        StringSeqHolder stringSeqHolder = new StringSeqHolder(stringArray);
        return Util.createProperties(stringSeqHolder, properties);
    }

    public static Communicator initialize(StringSeqHolder stringSeqHolder) {
        InitializationData initializationData = new InitializationData();
        return Util.initialize(stringSeqHolder, initializationData);
    }

    public static Communicator initialize(String[] stringArray) {
        StringSeqHolder stringSeqHolder = new StringSeqHolder(stringArray);
        return Util.initialize(stringSeqHolder);
    }

    public static Communicator initialize(StringSeqHolder stringSeqHolder, InitializationData initializationData) {
        initializationData = initializationData == null ? new InitializationData() : (InitializationData)initializationData.ice_clone();
        initializationData.properties = Util.createProperties(stringSeqHolder, initializationData.properties);
        Communicator communicator = new Communicator(initializationData);
        communicator.finishSetup(stringSeqHolder);
        return communicator;
    }

    public static Communicator initialize(String[] stringArray, InitializationData initializationData) {
        StringSeqHolder stringSeqHolder = new StringSeqHolder(stringArray);
        return Util.initialize(stringSeqHolder, initializationData);
    }

    public static Communicator initialize(InitializationData initializationData) {
        initializationData = initializationData == null ? new InitializationData() : (InitializationData)initializationData.ice_clone();
        Communicator communicator = new Communicator(initializationData);
        communicator.finishSetup(new StringSeqHolder(new String[0]));
        return communicator;
    }

    public static Communicator initialize() {
        return Util.initialize(new InitializationData());
    }

    public static Communicator initializeWithProperties(StringSeqHolder stringSeqHolder, Properties properties) {
        InitializationData initializationData = new InitializationData();
        initializationData.properties = properties;
        return Util.initialize(stringSeqHolder, initializationData);
    }

    public static Communicator initializeWithProperties(String[] stringArray, Properties properties) {
        InitializationData initializationData = new InitializationData();
        initializationData.properties = properties;
        return Util.initialize(stringArray, initializationData);
    }

    public static Instance getInstance(Communicator communicator) {
        return communicator.getInstance();
    }

    public static synchronized String generateUUID() {
        if (_localAddress == null) {
            byte[] byArray = Network.getLocalAddress();
            _localAddress = "";
            for (int i = 0; i < byArray.length; ++i) {
                if (i > 0) {
                    _localAddress = _localAddress + ":";
                }
                int n = byArray[i] < 0 ? byArray[i] + 256 : byArray[i];
                _localAddress = _localAddress + Integer.toHexString(n);
            }
        }
        return _localAddress + ":" + UUID.create();
    }

    public static int proxyIdentityCompare(ObjectPrx objectPrx, ObjectPrx objectPrx2) {
        if (objectPrx == null && objectPrx2 == null) {
            return 0;
        }
        if (objectPrx == null && objectPrx2 != null) {
            return -1;
        }
        if (objectPrx != null && objectPrx2 == null) {
            return 1;
        }
        Identity identity = objectPrx.ice_getIdentity();
        Identity identity2 = objectPrx2.ice_getIdentity();
        int n = identity.name.compareTo(identity2.name);
        if (n != 0) {
            return n;
        }
        return identity.category.compareTo(identity2.category);
    }

    public static int proxyIdentityAndFacetCompare(ObjectPrx objectPrx, ObjectPrx objectPrx2) {
        if (objectPrx == null && objectPrx2 == null) {
            return 0;
        }
        if (objectPrx == null && objectPrx2 != null) {
            return -1;
        }
        if (objectPrx != null && objectPrx2 == null) {
            return 1;
        }
        Identity identity = objectPrx.ice_getIdentity();
        Identity identity2 = objectPrx2.ice_getIdentity();
        int n = identity.name.compareTo(identity2.name);
        if (n != 0) {
            return n;
        }
        n = identity.category.compareTo(identity2.category);
        if (n != 0) {
            return n;
        }
        String string = objectPrx.ice_getFacet();
        String string2 = objectPrx2.ice_getFacet();
        if (string == null && string2 == null) {
            return 0;
        }
        if (string == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        return string.compareTo(string2);
    }

    public static void throwBadMagicException(byte[] byArray) {
        String string = "unknown magic number: ";
        string = string + "0x" + Integer.toHexString(byArray[0]) + ", ";
        string = string + "0x" + Integer.toHexString(byArray[1]) + ", ";
        string = string + "0x" + Integer.toHexString(byArray[2]) + ", ";
        string = string + "0x" + Integer.toHexString(byArray[3]) + "";
        throw new ProtocolException(string);
    }

    public static void throwUnsupportedProtocolException(int n, int n2) {
        String string = "unsupported protocol version: " + n + "." + n2;
        string = string + "\n(can only support protocols compatible with version ";
        string = string + "1.0";
        throw new ProtocolException(string);
    }

    public static void throwUnsupportedEncodingException(int n, int n2) {
        String string = "unsupported encoding version: " + n + "." + n2;
        string = string + "\n(can only support protocols compatible with version ";
        string = string + "1.0";
        throw new ProtocolException(string);
    }

    public static void throwUnknownMessageException() {
        throw new ProtocolException("unknown message type");
    }

    public static void throwConnectionNotValidatedException() {
        throw new ProtocolException("received message over unvalidated connection");
    }

    public static void throwUnknownRequestIdException() {
        throw new ProtocolException("unknown request id");
    }

    public static void throwUnknownReplyStatusException() {
        throw new ProtocolException("unknown reply status");
    }

    public static void throwIllegalMessageSizeException() {
        throw new ProtocolException("illegal message size");
    }

    public static void throwUnmarshalOutOfBoundsException() {
        throw new MarshalException("out of bounds during unmarshaling");
    }

    public static void throwNegativeSizeException() {
        throw new MarshalException("negative size for sequence, dictionary, etc.");
    }

    public static void throwProxyUnmarshalException() {
        throw new MarshalException("inconsistent proxy data during unmarshaling");
    }
}

